/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StringUTF8DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.TerminatedUnicode32DataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.data.Unicode32DataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.data.WideChar16DataType;
import ghidra.program.model.data.WideChar32DataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.DecompilerLanguage;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.FunctionPrototype;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.Arrays;

public class PcodeDataTypeManager {
    private Program program;
    private DataTypeManager progDataTypes;
    private DataTypeManager builtInDataTypes = BuiltInDataTypeManager.getDataTypeManager();
    private DataOrganization dataOrganization;
    private DecompilerLanguage displayLanguage;
    private boolean voidInputIsVarargs;
    private TypeMap[] coreBuiltin;
    private VoidDataType voidDt;
    private int pointerWordSize;

    public PcodeDataTypeManager(Program prog) {
        this.program = prog;
        this.progDataTypes = prog.getDataTypeManager();
        this.dataOrganization = this.progDataTypes.getDataOrganization();
        this.voidInputIsVarargs = true;
        this.displayLanguage = prog.getCompilerSpec().getDecompilerOutputLanguage(prog);
        if (this.displayLanguage != DecompilerLanguage.C_LANGUAGE) {
            this.voidInputIsVarargs = false;
        }
        this.generateCoreTypes();
        this.sortCoreTypes();
        this.pointerWordSize = ((SleighLanguage)prog.getLanguage()).getDefaultPointerWordSize();
    }

    public Program getProgram() {
        return this.program;
    }

    public DataType findUndefined(int size) {
        return Undefined.getUndefinedDataType(size);
    }

    public DataType findBaseType(String nm, String idstr) {
        long id = 0L;
        if (idstr != null) {
            id = SpecXmlUtils.decodeLong((String)idstr);
            if (id > 0L) {
                DataType dt = this.progDataTypes.getDataType(id);
                if (dt != null) {
                    return dt;
                }
            } else {
                int index = this.findTypeById(id);
                if (index >= 0) {
                    return this.coreBuiltin[index].dt;
                }
            }
        }
        ArrayList<DataType> datatypes = new ArrayList<DataType>();
        this.builtInDataTypes.findDataTypes(nm, datatypes);
        if (datatypes.size() != 0) {
            return datatypes.get(0).clone(this.progDataTypes);
        }
        if (nm.equals("code")) {
            return DataType.DEFAULT;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataType readXMLDataType(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"type", "void", "typeref"});
        try {
            if (el == null) {
                throw new PcodeXMLException("Bad <type> tag");
            }
            if (el.getName().equals("void")) {
                VoidDataType voidDataType = this.voidDt;
                return voidDataType;
            }
            if (el.getName().equals("typeref")) {
                DataType dataType = this.findBaseType(el.getAttribute("name"), el.getAttribute("id"));
                return dataType;
            }
            String name = el.getAttribute("name");
            if (name.length() != 0) {
                DataType dataType = this.findBaseType(name, el.getAttribute("id"));
                return dataType;
            }
            String meta = el.getAttribute("metatype");
            DataTypeImpl restype = null;
            if (meta.equals("ptr")) {
                int size = SpecXmlUtils.decodeInt((String)el.getAttribute("size"));
                if (parser.peek().isStart()) {
                    DataType dt = this.readXMLDataType(parser);
                    boolean useDefaultSize = size == this.dataOrganization.getPointerSize() || size > 8;
                    restype = new PointerDataType(dt, useDefaultSize ? -1 : size, this.progDataTypes);
                }
            } else if (meta.equals("array")) {
                int arrsize = SpecXmlUtils.decodeInt((String)el.getAttribute("arraysize"));
                if (parser.peek().isStart()) {
                    DataType dt = this.readXMLDataType(parser);
                    if (dt == null || dt.getLength() == 0) {
                        dt = DataType.DEFAULT;
                    }
                    restype = new ArrayDataType(dt, arrsize, dt.getLength(), this.progDataTypes);
                }
            } else {
                if (meta.equals("spacebase")) {
                    parser.discardSubTree();
                    VoidDataType arrsize = this.voidDt;
                    return arrsize;
                }
                if (meta.equals("struct")) {
                    int size = SpecXmlUtils.decodeInt((String)el.getAttribute("size"));
                    DataType dataType = Undefined.getUndefinedDataType(size);
                    return dataType;
                }
                if (meta.equals("int")) {
                    int size = SpecXmlUtils.decodeInt((String)el.getAttribute("size"));
                    DataType dataType = AbstractIntegerDataType.getSignedDataType(size, this.progDataTypes);
                    return dataType;
                }
                if (meta.equals("uint")) {
                    int size = SpecXmlUtils.decodeInt((String)el.getAttribute("size"));
                    DataType dataType = AbstractIntegerDataType.getUnsignedDataType(size, this.progDataTypes);
                    return dataType;
                }
                if (meta.equals("float")) {
                    int size = SpecXmlUtils.decodeInt((String)el.getAttribute("size"));
                    DataType dataType = AbstractFloatDataType.getFloatDataType(size, this.progDataTypes);
                    return dataType;
                }
                int size = SpecXmlUtils.decodeInt((String)el.getAttribute("size"));
                DataType dataType = Undefined.getUndefinedDataType(size).clone(this.progDataTypes);
                return dataType;
            }
            if (restype == null) {
                throw new PcodeXMLException("Unable to resolve DataType");
            }
            PointerDataType pointerDataType = restype;
            return pointerDataType;
        }
        finally {
            parser.discardSubTree(el);
        }
    }

    public StringBuilder buildTypeRef(DataType type, int size) {
        long id;
        if (type != null && type.getDataTypeManager() != this.progDataTypes) {
            type = type.clone(this.progDataTypes);
        }
        if (type instanceof VoidDataType || type == null) {
            return this.buildType(type, size);
        }
        if (type instanceof AbstractIntegerDataType) {
            return this.buildType(type, size);
        }
        if (type instanceof Pointer) {
            return this.buildType(type, size);
        }
        if (type instanceof Array) {
            return this.buildType(type, size);
        }
        if (type instanceof FunctionDefinition ? (id = this.progDataTypes.getID(type)) <= 0L : type.getLength() <= 0) {
            return this.buildType(type, size);
        }
        StringBuilder resBuf = new StringBuilder();
        resBuf.append("<typeref");
        if (type instanceof BuiltIn) {
            SpecXmlUtils.xmlEscapeAttribute((StringBuilder)resBuf, (String)"name", (String)((BuiltIn)type).getDecompilerDisplayName(this.displayLanguage));
        } else {
            SpecXmlUtils.xmlEscapeAttribute((StringBuilder)resBuf, (String)"name", (String)type.getName());
            long id2 = this.progDataTypes.getID(type);
            if (id2 > 0L) {
                SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)resBuf, (String)"id", (long)id2);
            }
        }
        resBuf.append("/>");
        return resBuf;
    }

    private StringBuilder getCharTypeRef(int size) {
        if (size == this.dataOrganization.getCharSize()) {
            return new StringBuilder("<typeref name=\"char\"/>");
        }
        if (size == this.dataOrganization.getWideCharSize()) {
            return new StringBuilder("<typeref name=\"wchar_t\"/>");
        }
        if (size == 2) {
            return new StringBuilder("<typeref name=\"wchar16\"/>");
        }
        if (size == 4) {
            return new StringBuilder("<typeref name=\"wchar32\"/>");
        }
        if (size == 1) {
            return new StringBuilder("<typeref name=\"byte\"/>");
        }
        throw new IllegalArgumentException("Unsupported character size");
    }

    private String buildTypeInternal(DataType type, int size) {
        if (type instanceof TypeDef) {
            type = ((TypeDef)type).getBaseDataType();
        }
        StringBuilder resBuf = new StringBuilder();
        if (type instanceof Pointer) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)"ptr");
            int ptrLen = type.getLength();
            if (ptrLen <= 0) {
                ptrLen = size;
            }
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)ptrLen);
            if (this.pointerWordSize != 1) {
                SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"wordsize", (long)this.pointerWordSize);
            }
            resBuf.append('>');
            DataType ptrto = ((Pointer)type).getDataType();
            if (ptrto != null && ptrto.getDataTypeManager() != this.progDataTypes) {
                ptrto = ptrto.clone(this.progDataTypes);
            }
            StringBuilder ptrtoTypeRef = ptrto == null ? this.buildTypeRef(DefaultDataType.dataType, 1) : (ptrto instanceof StringDataType || type instanceof TerminatedStringDataType ? this.getCharTypeRef(this.dataOrganization.getCharSize()) : (ptrto instanceof StringUTF8DataType ? this.getCharTypeRef(1) : (ptrto instanceof FunctionDefinition ? this.buildTypeRef(ptrto, ptrto.getLength()) : (ptrto instanceof UnicodeDataType || ptrto instanceof TerminatedUnicodeDataType ? this.getCharTypeRef(2) : (ptrto instanceof Unicode32DataType || ptrto instanceof TerminatedUnicode32DataType ? this.getCharTypeRef(4) : (ptrto.getLength() < 0 && !(ptrto instanceof FunctionDefinition) ? this.buildTypeRef(Undefined1DataType.dataType, 1) : this.buildTypeRef(ptrto, ptrto.getLength())))))));
            resBuf.append((CharSequence)ptrtoTypeRef);
        } else if (type instanceof Array) {
            int sz = type.getLength();
            if (sz == 0) {
                sz = size;
            }
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)"array");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)sz);
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"arraysize", (long)((Array)type).getNumElements());
            resBuf.append('>');
            resBuf.append((CharSequence)this.buildTypeRef(((Array)type).getDataType(), ((Array)type).getElementLength()));
        } else if (type instanceof Structure) {
            DataTypeComponent[] comps;
            int sz = type.getLength();
            if (sz == 0) {
                type = new StructureDataType(type.getCategoryPath(), type.getName(), 1);
                sz = type.getLength();
            }
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)"struct");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)sz);
            resBuf.append(">\n");
            for (DataTypeComponent comp : comps = ((Structure)type).getDefinedComponents()) {
                if (comp.isBitFieldComponent()) continue;
                resBuf.append("<field");
                String field_name = comp.getFieldName();
                if (field_name == null) {
                    field_name = comp.getDefaultFieldName();
                }
                SpecXmlUtils.xmlEscapeAttribute((StringBuilder)resBuf, (String)"name", (String)field_name);
                SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"offset", (long)comp.getOffset());
                resBuf.append('>');
                DataType fieldtype = comp.getDataType();
                resBuf.append((CharSequence)this.buildTypeRef(fieldtype, comp.getLength()));
                resBuf.append("</field>\n");
            }
        } else if (type instanceof Enum) {
            Enum enumDt = (Enum)type;
            long[] keys = enumDt.getValues();
            String metatype = "uint";
            for (long key : keys) {
                if (key >= 0L) continue;
                metatype = "int";
                break;
            }
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)metatype);
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)enumDt.getLength());
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)resBuf, (String)"enum", (boolean)true);
            resBuf.append(">\n");
            for (long key : keys) {
                resBuf.append("<val");
                SpecXmlUtils.xmlEscapeAttribute((StringBuilder)resBuf, (String)"name", (String)enumDt.getName(key));
                SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"value", (long)key);
                resBuf.append("/>");
            }
        } else if (type instanceof CharDataType) {
            boolean signed = ((CharDataType)type).isSigned();
            int sz = type.getLength();
            if (sz <= 0) {
                sz = size;
            }
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)(signed ? "int" : "uint"));
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)sz);
            if (sz == 1) {
                SpecXmlUtils.encodeBooleanAttribute((StringBuilder)resBuf, (String)"char", (boolean)true);
            } else {
                SpecXmlUtils.encodeBooleanAttribute((StringBuilder)resBuf, (String)"utf", (boolean)true);
            }
            resBuf.append('>');
        } else if (type instanceof WideCharDataType || type instanceof WideChar16DataType || type instanceof WideChar32DataType) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)"int");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)type.getLength());
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)resBuf, (String)"utf", (boolean)true);
            resBuf.append('>');
        } else if (type instanceof StringDataType || type instanceof TerminatedStringDataType) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)"array");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)size);
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"arraysize", (long)size);
            resBuf.append('>');
            resBuf.append((CharSequence)this.getCharTypeRef(this.dataOrganization.getCharSize()));
        } else if (type instanceof StringUTF8DataType) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)"array");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)size);
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"arraysize", (long)size);
            resBuf.append('>');
            resBuf.append((CharSequence)this.getCharTypeRef(1));
        } else if (type instanceof UnicodeDataType || type instanceof TerminatedUnicodeDataType) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)"array");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)size);
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"arraysize", (long)(size / 2));
            resBuf.append('>');
            resBuf.append((CharSequence)this.getCharTypeRef(2));
        } else if (type instanceof Unicode32DataType || type instanceof TerminatedUnicode32DataType) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)"array");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)size);
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"arraysize", (long)(size / 4));
            resBuf.append('>');
            resBuf.append((CharSequence)this.getCharTypeRef(4));
        } else if (type instanceof FunctionDefinition) {
            if (size <= 0) {
                size = 1;
            }
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)"code");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)1L);
            resBuf.append('>');
            FunctionDefinition fdef = (FunctionDefinition)type;
            CompilerSpec cspec = this.program.getCompilerSpec();
            FunctionPrototype fproto = new FunctionPrototype(fdef, cspec, this.voidInputIsVarargs);
            fproto.buildPrototypeXML(resBuf, this);
        } else if (type instanceof BooleanDataType) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)"bool");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)type.getLength());
            resBuf.append('>');
        } else if (type instanceof AbstractIntegerDataType) {
            boolean signed = ((AbstractIntegerDataType)type).isSigned();
            int sz = type.getLength();
            if (sz <= 0) {
                sz = size;
            }
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)(signed ? "int" : "uint"));
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)sz);
            resBuf.append('>');
        } else if (type instanceof AbstractFloatDataType) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)"float");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)type.getLength());
            resBuf.append('>');
        } else {
            int sz = type.getLength();
            if (sz <= 0) {
                sz = size;
            }
            if (sz < 16) {
                SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)"unknown");
                SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)sz);
                resBuf.append('>');
            } else {
                SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"metatype", (String)"array");
                SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)sz);
                SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"arraysize", (long)sz);
                resBuf.append('>');
                resBuf.append((CharSequence)this.buildTypeRef(new ByteDataType(), 1));
            }
        }
        return resBuf.toString();
    }

    public StringBuilder buildType(DataType type, int size) {
        if (type != null && type.getDataTypeManager() != this.progDataTypes) {
            type = type.clone(this.progDataTypes);
        }
        StringBuilder resBuf = new StringBuilder();
        if (type instanceof VoidDataType || type == null) {
            return resBuf.append("<void/>");
        }
        resBuf.append("<type");
        if (type instanceof Pointer || type instanceof Array || !(type instanceof FunctionDefinition) && type.getLength() <= 0) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"name", (String)"");
        } else if (type instanceof BuiltIn) {
            SpecXmlUtils.xmlEscapeAttribute((StringBuilder)resBuf, (String)"name", (String)((BuiltIn)type).getDecompilerDisplayName(this.displayLanguage));
        } else {
            SpecXmlUtils.xmlEscapeAttribute((StringBuilder)resBuf, (String)"name", (String)type.getName());
            long id = this.progDataTypes.getID(type);
            if (id > 0L) {
                SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)resBuf, (String)"id", (long)id);
            }
        }
        resBuf.append(this.buildTypeInternal(type, size));
        resBuf.append("</type>");
        return resBuf;
    }

    public StringBuilder buildStructTypeZeroSizeOveride(DataType type) {
        StringBuilder resBuf = new StringBuilder();
        if (!(type instanceof Structure || type instanceof TypeDef && ((TypeDef)type).getBaseDataType() instanceof Structure)) {
            return resBuf;
        }
        resBuf.append("<type");
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)resBuf, (String)"name", (String)type.getDisplayName());
        resBuf.append(" id=\"0x" + Long.toHexString(this.progDataTypes.getID(type)) + "\"");
        resBuf.append(" metatype=\"struct\" size=\"0\"></type>");
        return resBuf;
    }

    private void generateCoreTypes() {
        this.voidDt = new VoidDataType(this.progDataTypes);
        ArrayList<TypeMap> typeList = new ArrayList<TypeMap>();
        typeList.add(new TypeMap(DataType.DEFAULT, "undefined", " metatype=\"unknown\""));
        for (Undefined undefined : Undefined.getUndefinedDataTypes()) {
            typeList.add(new TypeMap(this.displayLanguage, undefined, " metatype=\"unknown\""));
        }
        for (BuiltIn builtIn : AbstractIntegerDataType.getSignedDataTypes(this.progDataTypes)) {
            typeList.add(new TypeMap(this.displayLanguage, builtIn.clone(this.progDataTypes), " metatype=\"int\""));
        }
        for (BuiltIn builtIn : AbstractIntegerDataType.getUnsignedDataTypes(this.progDataTypes)) {
            typeList.add(new TypeMap(this.displayLanguage, builtIn.clone(this.progDataTypes), " metatype=\"uint\""));
        }
        for (BuiltIn builtIn : AbstractFloatDataType.getFloatDataTypes(this.progDataTypes)) {
            typeList.add(new TypeMap(this.displayLanguage, builtIn, " metatype=\"float\""));
        }
        typeList.add(new TypeMap(DataType.DEFAULT, "code", " metatype=\"code\""));
        CharDataType charDataType = new CharDataType(this.progDataTypes);
        Object charMetatype = null;
        charMetatype = charDataType instanceof CharDataType && charDataType.isSigned() ? " metatype=\"int\"" : " metatype=\"uint\"";
        charMetatype = charDataType.getLength() == 1 ? (String)charMetatype + " char=\"true\"" : (String)charMetatype + " utf=\"true\"";
        typeList.add(new TypeMap(this.displayLanguage, charDataType, (String)charMetatype));
        WideCharDataType wideDataType = new WideCharDataType(this.progDataTypes);
        typeList.add(new TypeMap(this.displayLanguage, wideDataType, " metatype=\"int\" utf=\"true\""));
        if (wideDataType.getLength() != 2) {
            typeList.add(new TypeMap(this.displayLanguage, new WideChar16DataType(this.progDataTypes), " metatype=\"int\" utf=\"true\""));
        }
        if (wideDataType.getLength() != 4) {
            typeList.add(new TypeMap(this.displayLanguage, new WideChar32DataType(this.progDataTypes), " metatype=\"int\" utf=\"true\""));
        }
        BooleanDataType booleanDataType = new BooleanDataType(this.progDataTypes);
        typeList.add(new TypeMap(this.displayLanguage, booleanDataType, " metatype=\"bool\""));
        this.coreBuiltin = new TypeMap[typeList.size()];
        typeList.toArray(this.coreBuiltin);
    }

    private void sortCoreTypes() {
        Arrays.sort(this.coreBuiltin, (o1, o2) -> Long.compare(o1.id, o2.id));
    }

    private int findTypeById(long id) {
        int min = 0;
        int max = this.coreBuiltin.length - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            TypeMap typeMap = this.coreBuiltin[mid];
            if (id == typeMap.id) {
                return mid;
            }
            if (id < typeMap.id) {
                max = mid - 1;
                continue;
            }
            min = mid + 1;
        }
        return -1;
    }

    public String buildCoreTypes() {
        StringBuilder buf = new StringBuilder();
        buf.append("<coretypes>\n");
        buf.append("<void/>\n");
        for (TypeMap typeMap : this.coreBuiltin) {
            buf.append("<type name=\"");
            buf.append(typeMap.name);
            buf.append("\" size=\"");
            buf.append(Integer.toString(typeMap.dt.getLength()));
            buf.append('\"');
            buf.append(typeMap.metatype);
            buf.append(" id=\"");
            buf.append(Long.toString(typeMap.id));
            buf.append("\"/>\n");
        }
        buf.append("</coretypes>\n");
        return buf.toString();
    }

    private static class TypeMap {
        public DataType dt;
        public String name;
        public String metatype;
        public long id;

        public TypeMap(DecompilerLanguage lang, DataType d, String meta) {
            this.dt = d;
            this.name = d instanceof BuiltIn ? ((BuiltIn)d).getDecompilerDisplayName(lang) : d.getName();
            this.metatype = meta;
            this.id = TypeMap.hashName(this.name);
        }

        public TypeMap(DataType d, String nm, String meta) {
            this.dt = d;
            this.name = nm;
            this.metatype = meta;
            this.id = TypeMap.hashName(this.name);
        }

        public static long hashName(String name) {
            long res = 123L;
            for (int i = 0; i < name.length(); ++i) {
                res = res << 8 | res >>> 56;
                if (((res += (long)name.charAt(i)) & 1L) != 0L) continue;
                res ^= 0xFEABFEABL;
            }
            return res |= Long.MIN_VALUE;
        }
    }
}

