/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Stack<E>
implements Iterable<E> {
    protected List<E> list;

    public Stack() {
        this.list = new ArrayList();
    }

    public Stack(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    public Stack(Stack<E> stack) {
        this.list = new ArrayList<E>(stack.list);
    }

    public boolean isEmpty() {
        return this.list.size() == 0;
    }

    public E peek() {
        return this.list.size() > 0 ? (E)this.list.get(this.list.size() - 1) : null;
    }

    public E pop() {
        return this.list.size() > 0 ? (E)this.list.remove(this.list.size() - 1) : null;
    }

    public E push(E item) {
        if (this.list.add(item)) {
            return item;
        }
        return null;
    }

    public int search(E o) {
        return this.list.indexOf(o);
    }

    public int size() {
        return this.list.size();
    }

    public E get(int depth) {
        return this.list.get(depth);
    }

    public void add(E item) {
        this.list.add(item);
    }

    public void clear() {
        this.list.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack stack = (Stack)obj;
        return this.list.equals(stack.list);
    }

    public String toString() {
        return this.list.toString();
    }
}

