/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.fusesource.jansi.AnsiOutputStream;
import org.fusesource.jansi.WindowsAnsiPrintStream;
import org.fusesource.jansi.internal.CLibrary;
import org.fusesource.jansi.internal.Kernel32;
import org.gradle.internal.os.OperatingSystem;

final class AnsiConsoleUtil {
    private static final int ENABLE_VIRTUAL_TERMINAL_PROCESSING = 4;
    private static final int DISABLE_NEWLINE_AUTO_RETURN = 8;
    private static final boolean IS_XTERM = AnsiConsoleUtil.environmentVariableStartsWith("TERM", "xterm");
    private static final boolean IS_MINGW_XTERM = IS_XTERM && AnsiConsoleUtil.environmentVariableStartsWith("MSYSTEM", "MINGW");

    private static boolean environmentVariableStartsWith(String name, String pattern) {
        return System.getenv(name) != null && System.getenv(name).startsWith(pattern);
    }

    private AnsiConsoleUtil() {
    }

    static OutputStream wrapOutputStream(OutputStream stream) {
        try {
            return AnsiConsoleUtil.wrapOutputStream(stream, CLibrary.STDOUT_FILENO);
        }
        catch (Throwable ignore) {
            return AnsiConsoleUtil.wrapOutputStream(stream, 0);
        }
    }

    private static OutputStream wrapOutputStream(OutputStream stream, int fileno) {
        if (Boolean.getBoolean("jansi.passthrough")) {
            return stream;
        }
        if (Boolean.getBoolean("jansi.strip")) {
            return new AnsiOutputStream(stream);
        }
        if (OperatingSystem.current().isWindows() && !IS_MINGW_XTERM) {
            final long stdOutputHandle = Kernel32.GetStdHandle((int)Kernel32.STD_OUTPUT_HANDLE);
            final int[] mode = new int[1];
            if (stdOutputHandle != (long)Kernel32.INVALID_HANDLE_VALUE && 0 != Kernel32.GetConsoleMode((long)stdOutputHandle, (int[])mode) && 0 != Kernel32.SetConsoleMode((long)stdOutputHandle, (int)(mode[0] | 4 | 8))) {
                return new FilterOutputStream(stream){

                    @Override
                    public void close() throws IOException {
                        this.write(AnsiOutputStream.RESET_CODE);
                        this.flush();
                        Kernel32.SetConsoleMode((long)stdOutputHandle, (int)mode[0]);
                        super.close();
                    }
                };
            }
            try {
                return new WindowsAnsiPrintStream(new PrintStream(stream));
            }
            catch (Throwable throwable) {
                return new AnsiOutputStream(stream);
            }
        }
        try {
            boolean forceColored = Boolean.getBoolean("jansi.force");
            if (!IS_XTERM && !forceColored && CLibrary.isatty((int)fileno) == 0) {
                return new AnsiOutputStream(stream);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new FilterOutputStream(stream){

            @Override
            public void close() throws IOException {
                this.write(AnsiOutputStream.RESET_CODE);
                this.flush();
                super.close();
            }
        };
    }
}

