/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal.jni;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import net.rubygrapefruit.platform.file.FileWatchEvent;
import net.rubygrapefruit.platform.internal.jni.AbstractFileEventFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsFileEventFunctions
extends AbstractFileEventFunctions {
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final int DEFAULT_COMMAND_TIMEOUT_IN_SECONDS = 5;

    @Override
    public WatcherBuilder newWatcher(BlockingQueue<FileWatchEvent> eventQueue) {
        return new WatcherBuilder(eventQueue);
    }

    private static native Object startWatcher0(int var0, long var1, AbstractFileEventFunctions.NativeFileWatcherCallback var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WatcherBuilder
    extends AbstractFileEventFunctions.AbstractWatcherBuilder {
        private int bufferSize = 65536;
        private long commandTimeoutInMillis = TimeUnit.SECONDS.toMillis(5L);

        private WatcherBuilder(BlockingQueue<FileWatchEvent> eventQueue) {
            super(eventQueue);
        }

        public WatcherBuilder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public WatcherBuilder withCommandTimeout(int timeoutValue, TimeUnit timeoutUnit) {
            this.commandTimeoutInMillis = timeoutUnit.toMillis(timeoutValue);
            return this;
        }

        @Override
        protected Object startWatcher(AbstractFileEventFunctions.NativeFileWatcherCallback callback) {
            return WindowsFileEventFunctions.startWatcher0(this.bufferSize, this.commandTimeoutInMillis, callback);
        }
    }
}

