/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging.slf4j;

import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.slf4j.Slf4jLocationAwareLoggerImpl;
import org.apache.ibatis.logging.slf4j.Slf4jLoggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jImpl
implements Log {
    private Log log;

    public Slf4jImpl(String clazz) {
        Logger logger = LoggerFactory.getLogger((String)clazz);
        if (logger instanceof LocationAwareLogger) {
            try {
                logger.getClass().getMethod("log", Marker.class, String.class, Integer.TYPE, String.class, Object[].class, Throwable.class);
                this.log = new Slf4jLocationAwareLoggerImpl((LocationAwareLogger)logger);
                return;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        this.log = new Slf4jLoggerImpl(logger);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public void error(String s2, Throwable e) {
        this.log.error(s2, e);
    }

    @Override
    public void error(String s2) {
        this.log.error(s2);
    }

    @Override
    public void debug(String s2) {
        this.log.debug(s2);
    }

    @Override
    public void trace(String s2) {
        this.log.trace(s2);
    }

    @Override
    public void warn(String s2) {
        this.log.warn(s2);
    }
}

