/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.lang.reflect.Method;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;
import org.mybatis.guice.mappers.MapperProvider;
import org.mybatis.guice.session.SqlSessionManagerProvider;
import org.mybatis.guice.transactional.Transactional;
import org.mybatis.guice.transactional.TransactionalMethodInterceptor;

abstract class AbstractMyBatisModule
extends AbstractModule {
    protected static final AbstractMatcher<Method> DECLARED_BY_OBJECT = new AbstractMatcher<Method>(){

        @Override
        public boolean matches(Method method) {
            return method.getDeclaringClass() == Object.class;
        }
    };
    protected static final AbstractMatcher<Method> SYNTHETIC = new AbstractMatcher<Method>(){

        @Override
        public boolean matches(Method method) {
            return method.isSynthetic();
        }
    };
    private ClassLoader resourcesClassLoader = this.getDefaultClassLoader();
    private ClassLoader driverClassLoader = this.getDefaultClassLoader();

    AbstractMyBatisModule() {
    }

    @Override
    protected final void configure() {
        try {
            this.bind(SqlSessionManager.class).toProvider(SqlSessionManagerProvider.class).in(Scopes.SINGLETON);
            this.bind(SqlSession.class).to(SqlSessionManager.class).in(Scopes.SINGLETON);
            this.internalConfigure();
            this.bindTransactionInterceptors();
            this.bind(ClassLoader.class).annotatedWith(Names.named("JDBC.driverClassLoader")).toInstance(this.driverClassLoader);
        }
        finally {
            this.resourcesClassLoader = this.getDefaultClassLoader();
            this.driverClassLoader = this.getDefaultClassLoader();
        }
    }

    protected void bindTransactionInterceptors() {
        TransactionalMethodInterceptor interceptor = new TransactionalMethodInterceptor();
        this.requestInjection(interceptor);
        this.bindInterceptor(Matchers.any(), Matchers.not(SYNTHETIC).and(Matchers.not(DECLARED_BY_OBJECT)).and(Matchers.annotatedWith(Transactional.class)), interceptor);
        this.bindInterceptor(Matchers.annotatedWith(Transactional.class), Matchers.not(SYNTHETIC).and(Matchers.not(DECLARED_BY_OBJECT)).and(Matchers.not(Matchers.annotatedWith(Transactional.class))), interceptor);
    }

    final <T> void bindMapper(Class<T> mapperType) {
        this.bind(mapperType).toProvider(Providers.guicify(new MapperProvider<T>(mapperType))).in(Scopes.SINGLETON);
    }

    public void useResourceClassLoader(ClassLoader resourceClassLoader) {
        this.resourcesClassLoader = resourceClassLoader;
    }

    protected final ClassLoader getResourceClassLoader() {
        return this.resourcesClassLoader;
    }

    public void useJdbcDriverClassLoader(ClassLoader driverClassLoader) {
        this.driverClassLoader = driverClassLoader;
    }

    private ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    abstract void internalConfigure();

    protected abstract void initialize();
}

