/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.plaf.FontUIResource;
import sun.awt.FcFontManager;
import sun.awt.FontConfiguration;
import sun.awt.motif.MFontConfiguration;
import sun.font.CompositeFont;
import sun.font.FcFontConfiguration;
import sun.font.FontAccess;
import sun.font.FontUtilities;
import sun.font.NativeFont;
import sun.font.SunFontManager;
import sun.util.logging.PlatformLogger;

public final class X11FontManager
extends FcFontManager {
    private static final int FOUNDRY_FIELD = 1;
    private static final int FAMILY_NAME_FIELD = 2;
    private static final int WEIGHT_NAME_FIELD = 3;
    private static final int SLANT_FIELD = 4;
    private static final int SETWIDTH_NAME_FIELD = 5;
    private static final int ADD_STYLE_NAME_FIELD = 6;
    private static final int PIXEL_SIZE_FIELD = 7;
    private static final int POINT_SIZE_FIELD = 8;
    private static final int RESOLUTION_X_FIELD = 9;
    private static final int RESOLUTION_Y_FIELD = 10;
    private static final int SPACING_FIELD = 11;
    private static final int AVERAGE_WIDTH_FIELD = 12;
    private static final int CHARSET_REGISTRY_FIELD = 13;
    private static final int CHARSET_ENCODING_FIELD = 14;
    private static Map fontNameMap = new HashMap();
    private static Map xlfdMap = new HashMap();
    private static Map xFontDirsMap;
    private static HashSet<String> fontConfigDirs;
    HashMap<String, String> oblmap = null;
    private static HashMap registeredDirs;
    private static String[] fontdirs;

    public static X11FontManager getInstance() {
        return (X11FontManager)SunFontManager.getInstance();
    }

    @Override
    public String getFileNameFromPlatformName(String string) {
        Vector vector;
        if (string.startsWith("/")) {
            return string;
        }
        String string2 = null;
        String string3 = this.specificFontIDForName(string);
        string2 = super.getFileNameFromPlatformName(string);
        if (string2 != null) {
            if (this.isHeadless() && string2.startsWith("-")) {
                return null;
            }
            if (string2.startsWith("/")) {
                vector = (Vector)xlfdMap.get(string2);
                if (vector == null) {
                    if (this.getFontConfiguration().needToSearchForFile(string2)) {
                        string2 = null;
                    }
                    if (string2 != null) {
                        vector = new Vector();
                        vector.add(string);
                        xlfdMap.put(string2, vector);
                    }
                } else if (!vector.contains(string)) {
                    vector.add(string);
                }
            }
            if (string2 != null) {
                fontNameMap.put(string3, string2);
                return string2;
            }
        }
        if (string3 != null) {
            string2 = (String)fontNameMap.get(string3);
            if (string2 == null && (FontUtilities.isLinux || FontUtilities.isBSD) && !X11FontManager.isOpenJDK()) {
                if (this.oblmap == null) {
                    this.initObliqueLucidaFontMap();
                }
                if ((vector = this.getObliqueLucidaFontID(string3)) != null) {
                    string2 = this.oblmap.get(vector);
                }
            }
            if (!(this.fontPath != null || string2 != null && string2.startsWith("/"))) {
                if (FontUtilities.debugFonts()) {
                    FontUtilities.getLogger().warning("** Registering all font paths because can't find file for " + string);
                }
                this.fontPath = this.getPlatformFontPath(noType1Font);
                this.registerFontDirs(this.fontPath);
                if (FontUtilities.debugFonts()) {
                    FontUtilities.getLogger().warning("** Finished registering all font paths");
                }
                string2 = (String)fontNameMap.get(string3);
            }
            if (string2 == null && !this.isHeadless()) {
                string2 = X11FontManager.getX11FontName(string);
            }
            if (string2 == null) {
                string3 = this.switchFontIDForName(string);
                string2 = (String)fontNameMap.get(string3);
            }
            if (string2 != null) {
                fontNameMap.put(string3, string2);
            }
        }
        return string2;
    }

    @Override
    protected String[] getNativeNames(String string, String string2) {
        Vector vector = (Vector)xlfdMap.get(string);
        if (vector == null) {
            if (string2 == null) {
                return null;
            }
            String[] stringArray = new String[]{string2};
            return stringArray;
        }
        int n = vector.size();
        return vector.toArray(new String[n]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void registerFontDir(String string) {
        block27: {
            if (FontUtilities.debugFonts()) {
                FontUtilities.getLogger().info("ParseFontDir " + string);
            }
            File file = new File(string + File.separator + "fonts.dir");
            InputStreamReader inputStreamReader = null;
            try {
                if (!file.canRead()) break block27;
                inputStreamReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 8192);
                StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
                streamTokenizer.eolIsSignificant(true);
                int n = streamTokenizer.nextToken();
                if (n == -2) {
                    int n2 = (int)streamTokenizer.nval;
                    n = streamTokenizer.nextToken();
                    if (n == 10) {
                        streamTokenizer.resetSyntax();
                        streamTokenizer.wordChars(32, 127);
                        streamTokenizer.wordChars(160, 255);
                        streamTokenizer.whitespaceChars(0, 31);
                        for (int i = 0; i < n2 && (n = streamTokenizer.nextToken()) != -1 && n == -3; ++i) {
                            Serializable serializable;
                            Object object;
                            int n3 = streamTokenizer.sval.indexOf(32);
                            if (n3 <= 0) {
                                ++n2;
                                n = streamTokenizer.nextToken();
                                if (n == 10) continue;
                                break;
                            }
                            if (streamTokenizer.sval.charAt(0) == '!') {
                                ++n2;
                                n = streamTokenizer.nextToken();
                                if (n == 10) continue;
                                break;
                            }
                            String string2 = streamTokenizer.sval.substring(0, n3);
                            int n4 = string2.lastIndexOf(58);
                            if (n4 > 0) {
                                if (n4 + 1 >= string2.length()) continue;
                                string2 = string2.substring(n4 + 1);
                            }
                            String string3 = streamTokenizer.sval.substring(n3 + 1);
                            String string4 = this.specificFontIDForName(string3);
                            String string5 = (String)fontNameMap.get(string4);
                            if (FontUtilities.debugFonts()) {
                                object = FontUtilities.getLogger();
                                ((PlatformLogger)object).info("file=" + string2 + " xlfd=" + string3);
                                ((PlatformLogger)object).info("fontID=" + string4 + " sVal=" + string5);
                            }
                            object = null;
                            try {
                                serializable = new File(string, string2);
                                if (xFontDirsMap == null) {
                                    xFontDirsMap = new HashMap();
                                }
                                xFontDirsMap.put(string4, string);
                                object = ((File)serializable).getCanonicalPath();
                            }
                            catch (IOException iOException) {
                                object = string + File.separator + string2;
                            }
                            serializable = (Vector)xlfdMap.get(object);
                            if (FontUtilities.debugFonts()) {
                                FontUtilities.getLogger().info("fullPath=" + (String)object + " xVal=" + serializable);
                            }
                            if ((serializable == null || !((Vector)serializable).contains(string3)) && string5 == null || !string5.startsWith("/")) {
                                if (FontUtilities.debugFonts()) {
                                    FontUtilities.getLogger().info("Map fontID:" + string4 + "to file:" + (String)object);
                                }
                                fontNameMap.put(string4, object);
                                if (serializable == null) {
                                    serializable = new Vector();
                                    xlfdMap.put(object, serializable);
                                }
                                ((Vector)serializable).add(string3);
                            }
                            if ((n = streamTokenizer.nextToken()) != 10) break;
                        }
                    }
                }
                inputStreamReader.close();
            }
            catch (IOException iOException) {
            }
            finally {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public void loadFonts() {
        super.loadFonts();
        xFontDirsMap = null;
        xlfdMap = new HashMap(1);
        fontNameMap = new HashMap(1);
    }

    private String getObliqueLucidaFontID(String string) {
        if (string.startsWith("-lucidasans-medium-i-normal") || string.startsWith("-lucidasans-bold-i-normal") || string.startsWith("-lucidatypewriter-medium-i-normal") || string.startsWith("-lucidatypewriter-bold-i-normal")) {
            return string.substring(0, string.indexOf("-i-"));
        }
        return null;
    }

    private static String getX11FontName(String string) {
        String string2 = string.replaceAll("%d", "*");
        if (NativeFont.fontExists(string2)) {
            return string2;
        }
        return null;
    }

    private void initObliqueLucidaFontMap() {
        this.oblmap = new HashMap();
        this.oblmap.put("-lucidasans-medium", jreLibDirName + "/fonts/LucidaSansRegular.ttf");
        this.oblmap.put("-lucidasans-bold", jreLibDirName + "/fonts/LucidaSansDemiBold.ttf");
        this.oblmap.put("-lucidatypewriter-medium", jreLibDirName + "/fonts/LucidaTypewriterRegular.ttf");
        this.oblmap.put("-lucidatypewriter-bold", jreLibDirName + "/fonts/LucidaTypewriterBold.ttf");
    }

    private boolean isHeadless() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return GraphicsEnvironment.isHeadless();
    }

    private String specificFontIDForName(String string) {
        int[] nArray = new int[14];
        int n = 1;
        int n2 = 1;
        while (n2 != -1 && n < 14) {
            if ((n2 = string.indexOf(45, n2)) == -1) continue;
            nArray[n++] = n2++;
        }
        if (n != 14) {
            if (FontUtilities.debugFonts()) {
                FontUtilities.getLogger().severe("Font Configuration Font ID is malformed:" + string);
            }
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(nArray[1], nArray[5]));
        stringBuffer.append(string.substring(nArray[12]));
        String string2 = stringBuffer.toString().toLowerCase(Locale.ENGLISH);
        return string2;
    }

    private String switchFontIDForName(String string) {
        int[] nArray = new int[14];
        int n = 1;
        int n2 = 1;
        while (n2 != -1 && n < 14) {
            if ((n2 = string.indexOf(45, n2)) == -1) continue;
            nArray[n++] = n2++;
        }
        if (n != 14) {
            if (FontUtilities.debugFonts()) {
                FontUtilities.getLogger().severe("Font Configuration Font ID is malformed:" + string);
            }
            return string;
        }
        String string2 = string.substring(nArray[3] + 1, nArray[4]);
        String string3 = string.substring(nArray[1] + 1, nArray[2]);
        String string4 = string.substring(nArray[12] + 1, nArray[13]);
        String string5 = string.substring(nArray[13] + 1);
        if (string2.equals("i")) {
            string2 = "o";
        } else if (string2.equals("o")) {
            string2 = "i";
        }
        if (string3.equals("itc zapfdingbats") && string4.equals("sun") && string5.equals("fontspecific")) {
            string4 = "adobe";
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(nArray[1], nArray[3] + 1));
        stringBuffer.append(string2);
        stringBuffer.append(string.substring(nArray[4], nArray[5] + 1));
        stringBuffer.append(string4);
        stringBuffer.append(string.substring(nArray[13]));
        String string6 = stringBuffer.toString().toLowerCase(Locale.ENGLISH);
        return string6;
    }

    public String getFileNameFromXLFD(String string) {
        String string2 = null;
        String string3 = this.specificFontIDForName(string);
        if (string3 != null) {
            string2 = (String)fontNameMap.get(string3);
            if (string2 == null) {
                string3 = this.switchFontIDForName(string);
                string2 = (String)fontNameMap.get(string3);
            }
            if (string2 == null) {
                string2 = this.getDefaultFontFile();
            }
        }
        return string2;
    }

    @Override
    protected void registerFontDirs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || registeredDirs.containsKey(string2)) continue;
                registeredDirs.put(string2, null);
                this.registerFontDir(string2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    protected void addFontToPlatformFontPath(String string) {
        String string2;
        String string3;
        this.getPlatformFontPathFromFontConfig();
        if (xFontDirsMap != null && (string3 = (String)xFontDirsMap.get(string2 = this.specificFontIDForName(string))) != null) {
            fontConfigDirs.add(string3);
        }
    }

    private void getPlatformFontPathFromFontConfig() {
        if (fontConfigDirs == null) {
            fontConfigDirs = this.getFontConfiguration().getAWTFontPathSet();
            if (FontUtilities.debugFonts() && fontConfigDirs != null) {
                String[] stringArray = fontConfigDirs.toArray(new String[0]);
                for (int i = 0; i < stringArray.length; ++i) {
                    FontUtilities.getLogger().info("awtfontpath : " + stringArray[i]);
                }
            }
        }
    }

    @Override
    protected void registerPlatformFontsUsedByFontConfiguration() {
        this.getPlatformFontPathFromFontConfig();
        if (fontConfigDirs == null) {
            return;
        }
        if (FontUtilities.isLinux || FontUtilities.isBSD) {
            fontConfigDirs.add(jreLibDirName + File.separator + "oblique-fonts");
        }
        fontdirs = fontConfigDirs.toArray(new String[0]);
    }

    @Override
    protected FontConfiguration createFontConfiguration() {
        FcFontConfiguration fcFontConfiguration;
        MFontConfiguration mFontConfiguration = new MFontConfiguration(this);
        if ((FontUtilities.isOpenSolaris || (FontUtilities.isLinux || FontUtilities.isBSD) && (!mFontConfiguration.foundOsSpecificFile() || !mFontConfiguration.fontFilesArePresent()) || FontUtilities.isSolaris && !mFontConfiguration.fontFilesArePresent()) && (fcFontConfiguration = new FcFontConfiguration(this)).init()) {
            return fcFontConfiguration;
        }
        mFontConfiguration.init();
        return mFontConfiguration;
    }

    @Override
    public FontConfiguration createFontConfiguration(boolean bl, boolean bl2) {
        return new MFontConfiguration(this, bl, bl2);
    }

    @Override
    protected synchronized String getFontPath(boolean bl) {
        this.isHeadless();
        return this.getFontPathNative(bl, true);
    }

    @Override
    protected FontUIResource getFontConfigFUIR(String string, int n, int n2) {
        CompositeFont compositeFont = this.getFontConfigManager().getFontConfigFont(string, n);
        if (compositeFont == null) {
            return new FontUIResource(string, n, n2);
        }
        FontUIResource fontUIResource = new FontUIResource(compositeFont.getFamilyName(null), n, n2);
        FontAccess.getFontAccess().setFont2D(fontUIResource, compositeFont.handle);
        FontAccess.getFontAccess().setCreatedFont(fontUIResource);
        return fontUIResource;
    }

    static {
        fontConfigDirs = null;
        registeredDirs = new HashMap();
        fontdirs = null;
    }
}

