/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

public class JitsiMeetConfig {
    private static final Logger logger = new LoggerImpl(JitsiMeetConfig.class.getName());
    public static final String PNAME_MIN_BITRATE = "minBitrate";
    public static final String PNAME_START_AUDIO_MUTED = "startAudioMuted";
    public static final String PNAME_START_VIDEO_MUTED = "startVideoMuted";
    public static final String PNAME_RTCSTATS_ENABLED = "rtcstatsEnabled";
    public static final String PNAME_CALLSTATS_ENABLED = "callstatsEnabled";
    public static final String PNAME_START_BITRATE = "startBitrate";
    public static final String PNAME_STEREO = "stereo";
    public static final String PNAME_OPUS_MAX_AVG_BITRATE = "opusMaxAverageBitrate";
    public static final int DEFAULT_START_BITRATE = 800;
    private final Map<String, String> properties;

    public JitsiMeetConfig(Map<String, String> properties2) {
        this.properties = properties2;
    }

    private Boolean getBoolean(String name) {
        String stringValue = this.properties.get(name);
        Boolean boolValue = null;
        if (StringUtils.isNotBlank(stringValue)) {
            boolValue = Boolean.parseBoolean(stringValue);
        }
        return boolValue;
    }

    private Integer getInt(String name) {
        String stringValue = this.properties.get(name);
        Integer intValue = null;
        if (StringUtils.isNotBlank(stringValue)) {
            try {
                intValue = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException ex) {
                logger.error("Error parsing: " + name + ", v: " + stringValue);
            }
        }
        return intValue;
    }

    public Integer getStartAudioMuted() {
        return this.getInt(PNAME_START_AUDIO_MUTED);
    }

    public Integer getStartVideoMuted() {
        return this.getInt(PNAME_START_VIDEO_MUTED);
    }

    public boolean getRtcStatsEnabled() {
        Boolean enabled2 = this.getBoolean(PNAME_RTCSTATS_ENABLED);
        return enabled2 == null || enabled2 != false;
    }

    public boolean getCallStatsEnabled() {
        Boolean enabled2 = this.getBoolean(PNAME_CALLSTATS_ENABLED);
        return enabled2 == null || enabled2 != false;
    }

    public int getMinBitrate() {
        Integer minBitrate = this.getInt(PNAME_MIN_BITRATE);
        return minBitrate == null ? -1 : minBitrate;
    }

    public int getStartBitrate() {
        Integer startBitrate = this.getInt(PNAME_START_BITRATE);
        return startBitrate == null ? 800 : startBitrate;
    }

    public boolean stereoEnabled() {
        Boolean stereo = this.getBoolean(PNAME_STEREO);
        return stereo != null && stereo != false;
    }

    public int getOpusMaxAverageBitrate() {
        Integer maxAvgBitrate = this.getInt(PNAME_OPUS_MAX_AVG_BITRATE);
        return maxAvgBitrate == null ? -1 : maxAvgBitrate;
    }

    @NotNull
    public OrderedJsonObject getDebugState() {
        OrderedJsonObject o = new OrderedJsonObject();
        o.put("start_audio_muted", String.valueOf(this.getStartAudioMuted()));
        o.put("start_video_muted", String.valueOf(this.getStartVideoMuted()));
        o.put("rtcstats_enabled", (Object)this.getRtcStatsEnabled());
        o.put("callstats_enabled", (Object)this.getCallStatsEnabled());
        o.put("min_bitrate", (Object)this.getMinBitrate());
        o.put("start_bitrate", (Object)this.getStartBitrate());
        o.put("stereo_enabled", (Object)this.stereoEnabled());
        o.put("opus_max_average_bitrate", (Object)this.getOpusMaxAverageBitrate());
        return o;
    }
}

