/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.OctoConfig;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeConfig;
import org.jitsi.jicofo.bridge.BridgeSelectionStrategy;
import org.jitsi.jicofo.bridge.HealthCheckListener;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.concurrent.CustomizableThreadFactory;
import org.jitsi.utils.event.AsyncEventEmitter;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.colibri.ColibriStatsExtension;
import org.json.simple.JSONObject;
import org.jxmpp.jid.Jid;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00014B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0015J\u001c\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\r2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010(H\u0007J\u0010\u0010)\u001a\u00020$2\u0006\u0010'\u001a\u00020\rH\u0016J\u0010\u0010*\u001a\u00020$2\u0006\u0010'\u001a\u00020\rH\u0016J\u0010\u0010+\u001a\u00020$2\u0006\u0010'\u001a\u00020\rH\u0016J\u0006\u0010\u001b\u001a\u00020\u0006J\u000e\u0010,\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0015J\u000e\u0010-\u001a\u00020$2\u0006\u0010'\u001a\u00020\rJ8\u0010.\u001a\u0004\u0018\u00010\u000e2\u0014\b\u0002\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0006002\n\b\u0002\u00101\u001a\u0004\u0018\u0001022\n\b\u0002\u00103\u001a\u0004\u0018\u000102H\u0007R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\bR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00065"}, d2={"Lorg/jitsi/jicofo/bridge/BridgeSelector;", "Lorg/jitsi/jicofo/bridge/HealthCheckListener;", "clock", "Ljava/time/Clock;", "(Ljava/time/Clock;)V", "bridgeCount", "", "getBridgeCount", "()I", "bridgeSelectionStrategy", "Lorg/jitsi/jicofo/bridge/BridgeSelectionStrategy;", "bridges", "", "Lorg/jxmpp/jid/Jid;", "Lorg/jitsi/jicofo/bridge/Bridge;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "eventEmitter", "Lorg/jitsi/utils/event/AsyncEventEmitter;", "Lorg/jitsi/jicofo/bridge/BridgeSelector$EventHandler;", "eventEmitterExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "logger", "Lorg/jitsi/utils/logging2/Logger;", "lostBridges", "Ljava/util/concurrent/atomic/AtomicInteger;", "operationalBridgeCount", "getOperationalBridgeCount", "stats", "Lorg/json/simple/JSONObject;", "getStats", "()Lorg/json/simple/JSONObject;", "addHandler", "", "eventHandler", "addJvbAddress", "bridgeJid", "Lorg/jitsi/xmpp/extensions/colibri/ColibriStatsExtension;", "healthCheckFailed", "healthCheckPassed", "healthCheckTimedOut", "removeHandler", "removeJvbAddress", "selectBridge", "conferenceBridges", "", "participantRegion", "", "version", "EventHandler", "jicofo"})
public final class BridgeSelector
implements HealthCheckListener {
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    private final ExecutorService eventEmitterExecutor;
    @NotNull
    private final AsyncEventEmitter<EventHandler> eventEmitter;
    @NotNull
    private final BridgeSelectionStrategy bridgeSelectionStrategy;
    @NotNull
    private final Map<Jid, Bridge> bridges;
    @NotNull
    private final AtomicInteger lostBridges;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public BridgeSelector(@NotNull Clock clock) {
        void it;
        BridgeSelectionStrategy bridgeSelectionStrategy;
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        ExecutorService executorService = this.eventEmitterExecutor = Executors.newSingleThreadExecutor(new CustomizableThreadFactory("BridgeSelector-AsyncEventEmitter", false));
        Intrinsics.checkNotNullExpressionValue(executorService, "eventEmitterExecutor");
        this.eventEmitter = new AsyncEventEmitter(executorService);
        BridgeSelectionStrategy bridgeSelectionStrategy2 = bridgeSelectionStrategy = BridgeConfig.config.getSelectionStrategy();
        BridgeSelector bridgeSelector = this;
        boolean bl = false;
        this.logger.info("Using " + it.getClass().getName());
        bridgeSelector.bridgeSelectionStrategy = bridgeSelectionStrategy;
        this.bridges = new LinkedHashMap();
        this.lostBridges = new AtomicInteger();
    }

    public /* synthetic */ BridgeSelector(Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(clock);
    }

    public final void addHandler(@NotNull EventHandler eventHandler) {
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        this.eventEmitter.addHandler(eventHandler);
    }

    public final void removeHandler(@NotNull EventHandler eventHandler) {
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        this.eventEmitter.removeHandler(eventHandler);
    }

    public final synchronized int getBridgeCount() {
        return this.bridges.size();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized int getOperationalBridgeCount() {
        int n;
        Iterable $this$count$iv = this.bridges.values();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!(it.isOperational() && !it.isInGracefulShutdown()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    public final int lostBridges() {
        return this.lostBridges.get();
    }

    @JvmOverloads
    @NotNull
    public final synchronized Bridge addJvbAddress(@NotNull Jid bridgeJid, @Nullable ColibriStatsExtension stats) {
        Bridge bridge2;
        Intrinsics.checkNotNullParameter(bridgeJid, "bridgeJid");
        Bridge bridge3 = this.bridges.get(bridgeJid);
        if (bridge3 != null) {
            Bridge it = bridge3;
            boolean bl = false;
            boolean wasShutingDown = it.isShuttingDown();
            it.setStats(stats);
            if (!wasShutingDown && it.isShuttingDown()) {
                this.logger.info(it.getJid() + " entered SHUTTING_DOWN");
                this.eventEmitter.fireEvent(new Function1<EventHandler, Unit>(it){
                    final /* synthetic */ Bridge $it;
                    {
                        this.$it = $it;
                        super(1);
                    }

                    public final void invoke(@NotNull EventHandler $this$fireEvent) {
                        Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                        $this$fireEvent.bridgeIsShuttingDown(this.$it);
                    }
                });
            }
            return it;
        }
        Bridge newBridge = bridge2 = new Bridge(bridgeJid, this.clock);
        boolean bl = false;
        if (stats != null) {
            newBridge.setStats(stats);
        }
        this.logger.info("Added new videobridge: " + newBridge);
        this.bridges.put(bridgeJid, newBridge);
        this.eventEmitter.fireEvent(new Function1<EventHandler, Unit>(newBridge){
            final /* synthetic */ Bridge $newBridge;
            {
                this.$newBridge = $newBridge;
                super(1);
            }

            public final void invoke(@NotNull EventHandler $this$fireEvent) {
                Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                $this$fireEvent.bridgeAdded(this.$newBridge);
            }
        });
        return bridge2;
    }

    public static /* synthetic */ Bridge addJvbAddress$default(BridgeSelector bridgeSelector, Jid jid, ColibriStatsExtension colibriStatsExtension, int n, Object object) {
        if ((n & 2) != 0) {
            colibriStatsExtension = null;
        }
        return bridgeSelector.addJvbAddress(jid, colibriStatsExtension);
    }

    public final synchronized void removeJvbAddress(@NotNull Jid bridgeJid) {
        block1: {
            Intrinsics.checkNotNullParameter(bridgeJid, "bridgeJid");
            this.logger.info("Removing JVB: " + bridgeJid);
            Bridge bridge2 = this.bridges.remove(bridgeJid);
            if (bridge2 == null) break block1;
            Bridge it = bridge2;
            boolean bl = false;
            if (!it.isInGracefulShutdown() && !it.isShuttingDown()) {
                this.logger.warn("Lost a bridge: " + bridgeJid);
                this.lostBridges.incrementAndGet();
            }
            this.eventEmitter.fireEvent(new Function1<EventHandler, Unit>(it){
                final /* synthetic */ Bridge $it;
                {
                    this.$it = $it;
                    super(1);
                }

                public final void invoke(@NotNull EventHandler $this$fireEvent) {
                    Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                    $this$fireEvent.bridgeRemoved(this.$it);
                }
            });
        }
    }

    @Override
    public void healthCheckPassed(@NotNull Jid bridgeJid) {
        Intrinsics.checkNotNullParameter(bridgeJid, "bridgeJid");
        Bridge bridge2 = this.bridges.get(bridgeJid);
        if (bridge2 != null) {
            bridge2.setOperational(true);
        }
    }

    @Override
    public void healthCheckFailed(@NotNull Jid bridgeJid) {
        Unit unit;
        Intrinsics.checkNotNullParameter(bridgeJid, "bridgeJid");
        Bridge bridge2 = this.bridges.get(bridgeJid);
        if (bridge2 != null) {
            Bridge it = bridge2;
            boolean bl = false;
            it.setOperational(false);
            this.eventEmitter.fireEvent(new Function1<EventHandler, Unit>(it){
                final /* synthetic */ Bridge $it;
                {
                    this.$it = $it;
                    super(1);
                }

                public final void invoke(@NotNull EventHandler $this$fireEvent) {
                    Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                    $this$fireEvent.bridgeRemoved(this.$it);
                }
            });
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit != null) {
            // empty if block
        }
    }

    @Override
    public void healthCheckTimedOut(@NotNull Jid bridgeJid) {
        Unit unit;
        Intrinsics.checkNotNullParameter(bridgeJid, "bridgeJid");
        Bridge bridge2 = this.bridges.get(bridgeJid);
        if (bridge2 != null) {
            Bridge it = bridge2;
            boolean bl = false;
            it.setOperational(false);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit != null) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmOverloads
    @Nullable
    public final synchronized Bridge selectBridge(@NotNull Map<Bridge, Integer> conferenceBridges, @Nullable String participantRegion, @Nullable String version) {
        Bridge bridge2;
        block17: {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Bridge it;
            Iterable $this$filterTo$iv$iv3;
            ArrayList<Bridge> $i$a$-synchronized-BridgeSelector$selectBridge$prioritizedBridges$22;
            Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
            String v = null;
            Bridge bridge3 = (Bridge)CollectionsKt.firstOrNull((Iterable)conferenceBridges.keySet());
            String string = v = bridge3 != null ? bridge3.getFullVersion() : null;
            if (v == null) {
                v = version;
            } else if (version != null && !Intrinsics.areEqual(version, v)) {
                this.logger.warn("An inconsistent version was requested: " + version + ". Conference is using version: " + v);
                return null;
            }
            BridgeSelector bridgeSelector = this;
            synchronized (bridgeSelector) {
                boolean $i$a$-synchronized-BridgeSelector$selectBridge$prioritizedBridges$22 = false;
                $i$a$-synchronized-BridgeSelector$selectBridge$prioritizedBridges$22 = new ArrayList<Bridge>(this.bridges.values());
            }
            ArrayList<Bridge> prioritizedBridges = $i$a$-synchronized-BridgeSelector$selectBridge$prioritizedBridges$22;
            CollectionsKt.sort((List)prioritizedBridges);
            Iterable $this$filter$iv = prioritizedBridges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                it = (Bridge)element$iv$iv;
                boolean bl = false;
                if (!it.isOperational()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List<Bridge> candidateBridges = CollectionsKt.toList((List)destination$iv$iv);
            if (candidateBridges.isEmpty()) {
                this.logger.warn("There are no operational bridges.");
                return null;
            }
            $this$filter$iv = candidateBridges;
            $i$f$filter = false;
            $this$filterTo$iv$iv3 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                it = (Bridge)element$iv$iv;
                boolean bl = false;
                if (!(!it.isShuttingDown())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            candidateBridges = CollectionsKt.toList((List)destination$iv$iv);
            if (candidateBridges.isEmpty()) {
                this.logger.warn("All operational bridges are SHUTTING_DOWN");
                return null;
            }
            if (v != null && !OctoConfig.config.getAllowMixedVersions()) {
                $this$filter$iv = candidateBridges;
                $i$f$filter = false;
                $this$filterTo$iv$iv3 = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    it = (Bridge)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getFullVersion(), v)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                candidateBridges = (List<Bridge>)destination$iv$iv;
                if (candidateBridges.isEmpty()) {
                    this.logger.warn("There are no bridges with the required version: " + v);
                    return null;
                }
            }
            Iterable $this$filter$iv2 = candidateBridges;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Bridge it2 = (Bridge)element$iv$iv;
                boolean bl = false;
                if (!(!it2.isDraining())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List<Bridge> activeBridges = CollectionsKt.toList((List)destination$iv$iv2);
            if (!activeBridges.isEmpty()) {
                candidateBridges = activeBridges;
            }
            Iterable $this$filter$iv3 = candidateBridges;
            boolean $i$f$filter3 = false;
            destination$iv$iv2 = $this$filter$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Bridge it3 = (Bridge)element$iv$iv;
                boolean bl = false;
                if (!(!it3.isInGracefulShutdown())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List runningBridges = CollectionsKt.toList((List)destination$iv$iv3);
            if (!runningBridges.isEmpty()) {
                candidateBridges = runningBridges;
            }
            Bridge it4 = bridge2 = this.bridgeSelectionStrategy.select(candidateBridges, conferenceBridges, participantRegion, OctoConfig.config.getEnabled());
            boolean bl = false;
            Bridge bridge4 = it4;
            if (bridge4 == null) break block17;
            bridge4.endpointAdded();
        }
        return bridge2;
    }

    public static /* synthetic */ Bridge selectBridge$default(BridgeSelector bridgeSelector, Map map, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return bridgeSelector.selectBridge(map, string, string2);
    }

    @NotNull
    public final synchronized JSONObject getStats() {
        int n;
        Bridge it;
        Object element$iv;
        Iterator iterator2;
        int count$iv;
        int n2;
        JSONObject jSONObject;
        JSONObject $this$_get_stats__u24lambda_u2d16 = jSONObject = this.bridgeSelectionStrategy.getStats();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue($this$_get_stats__u24lambda_u2d16, "this");
        ((Map)$this$_get_stats__u24lambda_u2d16).put("bridge_count", this.getBridgeCount());
        Map map = $this$_get_stats__u24lambda_u2d16;
        String string = "operational_bridge_count";
        Object $this$count$iv = this.bridges.values();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            iterator2 = $this$count$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                it = (Bridge)element$iv;
                boolean bl2 = false;
                if (!it.isOperational() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        $this$count$iv = n2;
        map.put(string, $this$count$iv);
        map = $this$_get_stats__u24lambda_u2d16;
        string = "in_shutdown_bridge_count";
        $this$count$iv = this.bridges.values();
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            iterator2 = $this$count$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                it = (Bridge)element$iv;
                boolean bl3 = false;
                if (!it.isInGracefulShutdown() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        Integer n3 = n;
        map.put(string, n3);
        ((Map)$this$_get_stats__u24lambda_u2d16).put("lost_bridges", this.lostBridges.get());
        JSONObject jSONObject2 = jSONObject;
        Intrinsics.checkNotNullExpressionValue(jSONObject2, "bridgeSelectionStrategy.\u2026stBridges.get()\n        }");
        return jSONObject2;
    }

    @NotNull
    public final synchronized OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$_get_debugState__u24lambda_u2d19 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        Map map = $this$_get_debugState__u24lambda_u2d19;
        String string = "strategy";
        String string2 = this.bridgeSelectionStrategy.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "bridgeSelectionStrategy.javaClass.simpleName");
        Object object = string2;
        map.put(string, object);
        map = $this$_get_debugState__u24lambda_u2d19;
        string = "bridge";
        Object $this$_get_debugState__u24lambda_u2d19_u24lambda_u2d18 = object = new OrderedJsonObject();
        boolean bl2 = false;
        Iterable $this$forEach$iv = this.bridges.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bridge it = (Bridge)element$iv;
            boolean bl3 = false;
            ((OrderedJsonObject)$this$_get_debugState__u24lambda_u2d19_u24lambda_u2d18).put(((Object)it.getJid()).toString(), it.getDebugState());
        }
        map.put(string, object);
        return orderedJsonObject;
    }

    @JvmOverloads
    public BridgeSelector() {
        this(null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Bridge addJvbAddress(@NotNull Jid bridgeJid) {
        Intrinsics.checkNotNullParameter(bridgeJid, "bridgeJid");
        return BridgeSelector.addJvbAddress$default(this, bridgeJid, null, 2, null);
    }

    @JvmOverloads
    @Nullable
    public final Bridge selectBridge(@NotNull Map<Bridge, Integer> conferenceBridges, @Nullable String participantRegion) {
        Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
        return BridgeSelector.selectBridge$default(this, conferenceBridges, participantRegion, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final Bridge selectBridge(@NotNull Map<Bridge, Integer> conferenceBridges) {
        Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
        return BridgeSelector.selectBridge$default(this, conferenceBridges, null, null, 6, null);
    }

    @JvmOverloads
    @Nullable
    public final Bridge selectBridge() {
        return BridgeSelector.selectBridge$default(this, null, null, null, 7, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lorg/jitsi/jicofo/bridge/BridgeSelector$EventHandler;", "", "bridgeAdded", "", "bridge", "Lorg/jitsi/jicofo/bridge/Bridge;", "bridgeIsShuttingDown", "bridgeRemoved", "jicofo"})
    public static interface EventHandler {
        public void bridgeRemoved(@NotNull Bridge var1);

        public void bridgeAdded(@NotNull Bridge var1);

        public void bridgeIsShuttingDown(@NotNull Bridge var1);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void bridgeIsShuttingDown(@NotNull EventHandler this_, @NotNull Bridge bridge2) {
                Intrinsics.checkNotNullParameter(bridge2, "bridge");
            }
        }
    }
}

