/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.impl.AmqpConstants;
import com.microsoft.azure.eventhubs.impl.EventDataUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public final class EventDataImpl
implements EventData {
    private static final long serialVersionUID = -5631628195600014255L;
    private static final int BODY_DATA_NULL = -1;
    private transient Binary bodyData;
    private transient Object amqpBody;
    private Map<String, Object> properties;
    private EventData.SystemProperties systemProperties;

    private EventDataImpl() {
    }

    EventDataImpl(Message amqpMessage) {
        if (amqpMessage == null) {
            throw new IllegalArgumentException("amqpMessage cannot be null");
        }
        Map messageAnnotations = amqpMessage.getMessageAnnotations().getValue();
        HashMap<String, Object> receiveProperties = new HashMap<String, Object>();
        for (Map.Entry annotation : messageAnnotations.entrySet()) {
            receiveProperties.put(((Symbol)annotation.getKey()).toString(), annotation.getValue() != null ? (Object)annotation.getValue() : null);
        }
        if (amqpMessage.getProperties() != null) {
            if (amqpMessage.getMessageId() != null) {
                receiveProperties.put("message-id", amqpMessage.getMessageId());
            }
            if (amqpMessage.getUserId() != null) {
                receiveProperties.put("user-id", amqpMessage.getUserId());
            }
            if (amqpMessage.getAddress() != null) {
                receiveProperties.put("to", amqpMessage.getAddress());
            }
            if (amqpMessage.getSubject() != null) {
                receiveProperties.put("subject", amqpMessage.getSubject());
            }
            if (amqpMessage.getReplyTo() != null) {
                receiveProperties.put("reply-to", amqpMessage.getReplyTo());
            }
            if (amqpMessage.getCorrelationId() != null) {
                receiveProperties.put("correlation-id", amqpMessage.getCorrelationId());
            }
            if (amqpMessage.getContentType() != null) {
                receiveProperties.put("content-type", amqpMessage.getContentType());
            }
            if (amqpMessage.getContentEncoding() != null) {
                receiveProperties.put("content-encoding", amqpMessage.getContentEncoding());
            }
            if (amqpMessage.getProperties().getAbsoluteExpiryTime() != null) {
                receiveProperties.put("absolute-expiry-time", amqpMessage.getExpiryTime());
            }
            if (amqpMessage.getProperties().getCreationTime() != null) {
                receiveProperties.put("creation-time", amqpMessage.getCreationTime());
            }
            if (amqpMessage.getGroupId() != null) {
                receiveProperties.put("group-id", amqpMessage.getGroupId());
            }
            if (amqpMessage.getProperties().getGroupSequence() != null) {
                receiveProperties.put("group-sequence", amqpMessage.getGroupSequence());
            }
            if (amqpMessage.getReplyToGroupId() != null) {
                receiveProperties.put("reply-to-group-id", amqpMessage.getReplyToGroupId());
            }
        }
        this.systemProperties = new EventData.SystemProperties(receiveProperties);
        this.properties = amqpMessage.getApplicationProperties() == null ? null : amqpMessage.getApplicationProperties().getValue();
        Section bodySection = amqpMessage.getBody();
        if (bodySection != null) {
            if (bodySection instanceof Data) {
                this.bodyData = ((Data)bodySection).getValue();
                this.amqpBody = this.bodyData;
            } else if (bodySection instanceof AmqpValue) {
                this.amqpBody = ((AmqpValue)bodySection).getValue();
            } else if (bodySection instanceof AmqpSequence) {
                this.amqpBody = ((AmqpSequence)bodySection).getValue();
            }
        }
        amqpMessage.clear();
    }

    public EventDataImpl(byte[] data) {
        this();
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.bodyData = new Binary(data);
    }

    public EventDataImpl(byte[] data, int offset, int length) {
        this();
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.bodyData = new Binary(data, offset, length);
    }

    public EventDataImpl(ByteBuffer buffer) {
        this();
        if (buffer == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.bodyData = Binary.create((ByteBuffer)buffer);
    }

    @Override
    public Object getObject() {
        return this.amqpBody;
    }

    @Override
    public byte[] getBytes() {
        if (this.bodyData == null) {
            return null;
        }
        return this.bodyData.getArray();
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    @Override
    public EventData.SystemProperties getSystemProperties() {
        return this.systemProperties;
    }

    Message toAmqpMessage() {
        Message amqpMessage = Proton.message();
        if (this.properties != null && !this.properties.isEmpty()) {
            ApplicationProperties applicationProperties = new ApplicationProperties(this.properties);
            amqpMessage.setApplicationProperties(applicationProperties);
        }
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            for (Map.Entry systemProperty : this.systemProperties.entrySet()) {
                String propertyName = (String)systemProperty.getKey();
                if (EventDataUtil.RESERVED_SYSTEM_PROPERTIES.contains(propertyName)) continue;
                if (AmqpConstants.RESERVED_PROPERTY_NAMES.contains(propertyName)) {
                    switch (propertyName) {
                        case "message-id": {
                            amqpMessage.setMessageId(systemProperty.getValue());
                            break;
                        }
                        case "user-id": {
                            amqpMessage.setUserId((byte[])systemProperty.getValue());
                            break;
                        }
                        case "to": {
                            amqpMessage.setAddress((String)systemProperty.getValue());
                            break;
                        }
                        case "subject": {
                            amqpMessage.setSubject((String)systemProperty.getValue());
                            break;
                        }
                        case "reply-to": {
                            amqpMessage.setReplyTo((String)systemProperty.getValue());
                            break;
                        }
                        case "correlation-id": {
                            amqpMessage.setCorrelationId(systemProperty.getValue());
                            break;
                        }
                        case "content-type": {
                            amqpMessage.setContentType((String)systemProperty.getValue());
                            break;
                        }
                        case "content-encoding": {
                            amqpMessage.setContentEncoding((String)systemProperty.getValue());
                            break;
                        }
                        case "absolute-expiry-time": {
                            amqpMessage.setExpiryTime(((Long)systemProperty.getValue()).longValue());
                            break;
                        }
                        case "creation-time": {
                            amqpMessage.setCreationTime(((Long)systemProperty.getValue()).longValue());
                            break;
                        }
                        case "group-id": {
                            amqpMessage.setGroupId((String)systemProperty.getValue());
                            break;
                        }
                        case "group-sequence": {
                            amqpMessage.setGroupSequence(((Long)systemProperty.getValue()).longValue());
                            break;
                        }
                        case "reply-to-group-id": {
                            amqpMessage.setReplyToGroupId((String)systemProperty.getValue());
                            break;
                        }
                        default: {
                            throw new RuntimeException("unreachable");
                        }
                    }
                    continue;
                }
                MessageAnnotations messageAnnotations = amqpMessage.getMessageAnnotations() == null ? new MessageAnnotations(new HashMap()) : amqpMessage.getMessageAnnotations();
                messageAnnotations.getValue().put(Symbol.getSymbol((String)((String)systemProperty.getKey())), systemProperty.getValue());
                amqpMessage.setMessageAnnotations(messageAnnotations);
            }
        }
        if (this.bodyData != null) {
            amqpMessage.setBody((Section)new Data(this.bodyData));
        } else if (this.amqpBody != null) {
            if (this.amqpBody instanceof List) {
                amqpMessage.setBody((Section)new AmqpSequence((List)this.amqpBody));
            } else {
                amqpMessage.setBody((Section)new AmqpValue(this.amqpBody));
            }
        }
        return amqpMessage;
    }

    Message toAmqpMessage(String partitionKey) {
        Message amqpMessage = this.toAmqpMessage();
        MessageAnnotations messageAnnotations = amqpMessage.getMessageAnnotations() == null ? new MessageAnnotations(new HashMap()) : amqpMessage.getMessageAnnotations();
        messageAnnotations.getValue().put(AmqpConstants.PARTITION_KEY, partitionKey);
        amqpMessage.setMessageAnnotations(messageAnnotations);
        return amqpMessage;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.bodyData == null ? -1 : this.bodyData.getLength());
        if (this.bodyData != null) {
            out.write(this.bodyData.getArray(), this.bodyData.getArrayOffset(), this.bodyData.getLength());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int length = in.readInt();
        if (length != -1) {
            byte[] data = new byte[length];
            in.readFully(data, 0, length);
            this.bodyData = new Binary(data, 0, length);
        }
    }

    @Override
    public int compareTo(EventData other) {
        return Long.compare(this.getSystemProperties().getSequenceNumber(), other.getSystemProperties().getSequenceNumber());
    }
}

