/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.shaderc;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.util.shaderc.ShadercIncludeResolveI;
import org.lwjgl.util.shaderc.ShadercIncludeResultReleaseI;

public class Shaderc {
    public static final int shaderc_target_env_vulkan = 0;
    public static final int shaderc_target_env_opengl = 1;
    public static final int shaderc_target_env_opengl_compat = 2;
    public static final int shaderc_target_env_webgpu = 3;
    public static final int shaderc_target_env_default = 0;
    public static final int shaderc_env_version_vulkan_1_0 = 0x400000;
    public static final int shaderc_env_version_vulkan_1_1 = 0x401000;
    public static final int shaderc_env_version_vulkan_1_2 = 0x402000;
    public static final int shaderc_env_version_opengl_4_5 = 450;
    public static final int shaderc_env_version_webgpu = 451;
    public static final int shaderc_spirv_version_1_0 = 65536;
    public static final int shaderc_spirv_version_1_1 = 65792;
    public static final int shaderc_spirv_version_1_2 = 66048;
    public static final int shaderc_spirv_version_1_3 = 66304;
    public static final int shaderc_spirv_version_1_4 = 66560;
    public static final int shaderc_spirv_version_1_5 = 66816;
    public static final int shaderc_compilation_status_success = 0;
    public static final int shaderc_compilation_status_invalid_stage = 1;
    public static final int shaderc_compilation_status_compilation_error = 2;
    public static final int shaderc_compilation_status_internal_error = 3;
    public static final int shaderc_compilation_status_null_result_object = 4;
    public static final int shaderc_compilation_status_invalid_assembly = 5;
    public static final int shaderc_compilation_status_validation_error = 6;
    public static final int shaderc_compilation_status_transformation_error = 7;
    public static final int shaderc_compilation_status_configuration_error = 8;
    public static final int shaderc_source_language_glsl = 0;
    public static final int shaderc_source_language_hlsl = 1;
    public static final int shaderc_vertex_shader = 0;
    public static final int shaderc_fragment_shader = 1;
    public static final int shaderc_compute_shader = 2;
    public static final int shaderc_geometry_shader = 3;
    public static final int shaderc_tess_control_shader = 4;
    public static final int shaderc_tess_evaluation_shader = 5;
    public static final int shaderc_glsl_vertex_shader = 0;
    public static final int shaderc_glsl_fragment_shader = 1;
    public static final int shaderc_glsl_compute_shader = 2;
    public static final int shaderc_glsl_geometry_shader = 3;
    public static final int shaderc_glsl_tess_control_shader = 4;
    public static final int shaderc_glsl_tess_evaluation_shader = 5;
    public static final int shaderc_glsl_infer_from_source = 6;
    public static final int shaderc_glsl_default_vertex_shader = 7;
    public static final int shaderc_glsl_default_fragment_shader = 8;
    public static final int shaderc_glsl_default_compute_shader = 9;
    public static final int shaderc_glsl_default_geometry_shader = 10;
    public static final int shaderc_glsl_default_tess_control_shader = 11;
    public static final int shaderc_glsl_default_tess_evaluation_shader = 12;
    public static final int shaderc_spirv_assembly = 13;
    public static final int shaderc_raygen_shader = 14;
    public static final int shaderc_anyhit_shader = 15;
    public static final int shaderc_closesthit_shader = 16;
    public static final int shaderc_miss_shader = 17;
    public static final int shaderc_intersection_shader = 18;
    public static final int shaderc_callable_shader = 19;
    public static final int shaderc_glsl_raygen_shader = 14;
    public static final int shaderc_glsl_anyhit_shader = 15;
    public static final int shaderc_glsl_closesthit_shader = 16;
    public static final int shaderc_glsl_miss_shader = 17;
    public static final int shaderc_glsl_intersection_shader = 18;
    public static final int shaderc_glsl_callable_shader = 19;
    public static final int shaderc_glsl_default_raygen_shader = 20;
    public static final int shaderc_glsl_default_anyhit_shader = 21;
    public static final int shaderc_glsl_default_closesthit_shader = 22;
    public static final int shaderc_glsl_default_miss_shader = 23;
    public static final int shaderc_glsl_default_intersection_shader = 24;
    public static final int shaderc_glsl_default_callable_shader = 25;
    public static final int shaderc_task_shader = 26;
    public static final int shaderc_mesh_shader = 27;
    public static final int shaderc_glsl_task_shader = 26;
    public static final int shaderc_glsl_mesh_shader = 27;
    public static final int shaderc_glsl_default_task_shader = 28;
    public static final int shaderc_glsl_default_mesh_shader = 29;
    public static final int shaderc_profile_none = 0;
    public static final int shaderc_profile_core = 1;
    public static final int shaderc_profile_compatibility = 2;
    public static final int shaderc_profile_es = 3;
    public static final int shaderc_optimization_level_zero = 0;
    public static final int shaderc_optimization_level_size = 1;
    public static final int shaderc_optimization_level_performance = 2;
    public static final int shaderc_limit_max_lights = 0;
    public static final int shaderc_limit_max_clip_planes = 1;
    public static final int shaderc_limit_max_texture_units = 2;
    public static final int shaderc_limit_max_texture_coords = 3;
    public static final int shaderc_limit_max_vertex_attribs = 4;
    public static final int shaderc_limit_max_vertex_uniform_components = 5;
    public static final int shaderc_limit_max_varying_floats = 6;
    public static final int shaderc_limit_max_vertex_texture_image_units = 7;
    public static final int shaderc_limit_max_combined_texture_image_units = 8;
    public static final int shaderc_limit_max_texture_image_units = 9;
    public static final int shaderc_limit_max_fragment_uniform_components = 10;
    public static final int shaderc_limit_max_draw_buffers = 11;
    public static final int shaderc_limit_max_vertex_uniform_vectors = 12;
    public static final int shaderc_limit_max_varying_vectors = 13;
    public static final int shaderc_limit_max_fragment_uniform_vectors = 14;
    public static final int shaderc_limit_max_vertex_output_vectors = 15;
    public static final int shaderc_limit_max_fragment_input_vectors = 16;
    public static final int shaderc_limit_min_program_texel_offset = 17;
    public static final int shaderc_limit_max_program_texel_offset = 18;
    public static final int shaderc_limit_max_clip_distances = 19;
    public static final int shaderc_limit_max_compute_work_group_count_x = 20;
    public static final int shaderc_limit_max_compute_work_group_count_y = 21;
    public static final int shaderc_limit_max_compute_work_group_count_z = 22;
    public static final int shaderc_limit_max_compute_work_group_size_x = 23;
    public static final int shaderc_limit_max_compute_work_group_size_y = 24;
    public static final int shaderc_limit_max_compute_work_group_size_z = 25;
    public static final int shaderc_limit_max_compute_uniform_components = 26;
    public static final int shaderc_limit_max_compute_texture_image_units = 27;
    public static final int shaderc_limit_max_compute_image_uniforms = 28;
    public static final int shaderc_limit_max_compute_atomic_counters = 29;
    public static final int shaderc_limit_max_compute_atomic_counter_buffers = 30;
    public static final int shaderc_limit_max_varying_components = 31;
    public static final int shaderc_limit_max_vertex_output_components = 32;
    public static final int shaderc_limit_max_geometry_input_components = 33;
    public static final int shaderc_limit_max_geometry_output_components = 34;
    public static final int shaderc_limit_max_fragment_input_components = 35;
    public static final int shaderc_limit_max_image_units = 36;
    public static final int shaderc_limit_max_combined_image_units_and_fragment_outputs = 37;
    public static final int shaderc_limit_max_combined_shader_output_resources = 38;
    public static final int shaderc_limit_max_image_samples = 39;
    public static final int shaderc_limit_max_vertex_image_uniforms = 40;
    public static final int shaderc_limit_max_tess_control_image_uniforms = 41;
    public static final int shaderc_limit_max_tess_evaluation_image_uniforms = 42;
    public static final int shaderc_limit_max_geometry_image_uniforms = 43;
    public static final int shaderc_limit_max_fragment_image_uniforms = 44;
    public static final int shaderc_limit_max_combined_image_uniforms = 45;
    public static final int shaderc_limit_max_geometry_texture_image_units = 46;
    public static final int shaderc_limit_max_geometry_output_vertices = 47;
    public static final int shaderc_limit_max_geometry_total_output_components = 48;
    public static final int shaderc_limit_max_geometry_uniform_components = 49;
    public static final int shaderc_limit_max_geometry_varying_components = 50;
    public static final int shaderc_limit_max_tess_control_input_components = 51;
    public static final int shaderc_limit_max_tess_control_output_components = 52;
    public static final int shaderc_limit_max_tess_control_texture_image_units = 53;
    public static final int shaderc_limit_max_tess_control_uniform_components = 54;
    public static final int shaderc_limit_max_tess_control_total_output_components = 55;
    public static final int shaderc_limit_max_tess_evaluation_input_components = 56;
    public static final int shaderc_limit_max_tess_evaluation_output_components = 57;
    public static final int shaderc_limit_max_tess_evaluation_texture_image_units = 58;
    public static final int shaderc_limit_max_tess_evaluation_uniform_components = 59;
    public static final int shaderc_limit_max_tess_patch_components = 60;
    public static final int shaderc_limit_max_patch_vertices = 61;
    public static final int shaderc_limit_max_tess_gen_level = 62;
    public static final int shaderc_limit_max_viewports = 63;
    public static final int shaderc_limit_max_vertex_atomic_counters = 64;
    public static final int shaderc_limit_max_tess_control_atomic_counters = 65;
    public static final int shaderc_limit_max_tess_evaluation_atomic_counters = 66;
    public static final int shaderc_limit_max_geometry_atomic_counters = 67;
    public static final int shaderc_limit_max_fragment_atomic_counters = 68;
    public static final int shaderc_limit_max_combined_atomic_counters = 69;
    public static final int shaderc_limit_max_atomic_counter_bindings = 70;
    public static final int shaderc_limit_max_vertex_atomic_counter_buffers = 71;
    public static final int shaderc_limit_max_tess_control_atomic_counter_buffers = 72;
    public static final int shaderc_limit_max_tess_evaluation_atomic_counter_buffers = 73;
    public static final int shaderc_limit_max_geometry_atomic_counter_buffers = 74;
    public static final int shaderc_limit_max_fragment_atomic_counter_buffers = 75;
    public static final int shaderc_limit_max_combined_atomic_counter_buffers = 76;
    public static final int shaderc_limit_max_atomic_counter_buffer_size = 77;
    public static final int shaderc_limit_max_transform_feedback_buffers = 78;
    public static final int shaderc_limit_max_transform_feedback_interleaved_components = 79;
    public static final int shaderc_limit_max_cull_distances = 80;
    public static final int shaderc_limit_max_combined_clip_and_cull_distances = 81;
    public static final int shaderc_limit_max_samples = 82;
    public static final int shaderc_uniform_kind_image = 0;
    public static final int shaderc_uniform_kind_sampler = 1;
    public static final int shaderc_uniform_kind_texture = 2;
    public static final int shaderc_uniform_kind_buffer = 3;
    public static final int shaderc_uniform_kind_storage_buffer = 4;
    public static final int shaderc_uniform_kind_unordered_access_view = 5;
    public static final int shaderc_include_type_relative = 0;
    public static final int shaderc_include_type_standard = 1;
    private static final SharedLibrary SHADERC = Library.loadNative(Shaderc.class, (String)"org.lwjgl.shaderc", (String)((String)Configuration.SHADERC_LIBRARY_NAME.get((Object)Platform.mapLibraryNameBundled((String)"shaderc"))), (boolean)true);

    protected Shaderc() {
        throw new UnsupportedOperationException();
    }

    public static SharedLibrary getLibrary() {
        return SHADERC;
    }

    @NativeType(value="shaderc_compiler_t")
    public static long shaderc_compiler_initialize() {
        long __functionAddress = Functions.compiler_initialize;
        return JNI.invokeP((long)__functionAddress);
    }

    public static void shaderc_compiler_release(@NativeType(value="shaderc_compiler_t") long compiler) {
        long __functionAddress = Functions.compiler_release;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        JNI.invokePV((long)compiler, (long)__functionAddress);
    }

    @NativeType(value="shaderc_compile_options_t")
    public static long shaderc_compile_options_initialize() {
        long __functionAddress = Functions.compile_options_initialize;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="shaderc_compile_options_t")
    public static long shaderc_compile_options_clone(@NativeType(value="shaderc_compile_options_t const") long options) {
        long __functionAddress = Functions.compile_options_clone;
        return JNI.invokePP((long)options, (long)__functionAddress);
    }

    public static void shaderc_compile_options_release(@NativeType(value="shaderc_compile_options_t") long options) {
        long __functionAddress = Functions.compile_options_release;
        JNI.invokePV((long)options, (long)__functionAddress);
    }

    public static void nshaderc_compile_options_add_macro_definition(long options, long name, long name_length, long value, long value_length) {
        long __functionAddress = Functions.compile_options_add_macro_definition;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePPPPPV((long)options, (long)name, (long)name_length, (long)value, (long)value_length, (long)__functionAddress);
    }

    public static void shaderc_compile_options_add_macro_definition(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="char const *") ByteBuffer name, @Nullable @NativeType(value="char const *") ByteBuffer value) {
        Shaderc.nshaderc_compile_options_add_macro_definition(options, MemoryUtil.memAddress((ByteBuffer)name), name.remaining(), MemoryUtil.memAddressSafe((ByteBuffer)value), Checks.remainingSafe((Buffer)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shaderc_compile_options_add_macro_definition(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="char const *") CharSequence name, @Nullable @NativeType(value="char const *") CharSequence value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int nameEncodedLength = stack.nUTF8(name, false);
            long nameEncoded = stack.getPointerAddress();
            int valueEncodedLength = stack.nUTF8Safe(value, false);
            long valueEncoded = value == null ? 0L : stack.getPointerAddress();
            Shaderc.nshaderc_compile_options_add_macro_definition(options, nameEncoded, nameEncodedLength, valueEncoded, valueEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void shaderc_compile_options_set_source_language(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="shaderc_source_language") int lang) {
        long __functionAddress = Functions.compile_options_set_source_language;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)lang, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_generate_debug_info(@NativeType(value="shaderc_compile_options_t") long options) {
        long __functionAddress = Functions.compile_options_set_generate_debug_info;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_optimization_level(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="shaderc_optimization_level") int level) {
        long __functionAddress = Functions.compile_options_set_optimization_level;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)level, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_forced_version_profile(@NativeType(value="shaderc_compile_options_t") long options, int version, @NativeType(value="shaderc_profile") int profile) {
        long __functionAddress = Functions.compile_options_set_forced_version_profile;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)version, (int)profile, (long)__functionAddress);
    }

    public static void nshaderc_compile_options_set_include_callbacks(long options, long resolver, long result_releaser, long user_data) {
        long __functionAddress = Functions.compile_options_set_include_callbacks;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePPPPV((long)options, (long)resolver, (long)result_releaser, (long)user_data, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_include_callbacks(@NativeType(value="shaderc_compile_options_t") long options, @Nullable @NativeType(value="shaderc_include_resolve_fn") ShadercIncludeResolveI resolver, @Nullable @NativeType(value="shaderc_include_result_release_fn") ShadercIncludeResultReleaseI result_releaser, @NativeType(value="void *") long user_data) {
        Shaderc.nshaderc_compile_options_set_include_callbacks(options, MemoryUtil.memAddressSafe((Pointer)resolver), MemoryUtil.memAddressSafe((Pointer)result_releaser), user_data);
    }

    public static void shaderc_compile_options_set_suppress_warnings(@NativeType(value="shaderc_compile_options_t") long options) {
        long __functionAddress = Functions.compile_options_set_suppress_warnings;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_target_env(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="shaderc_target_env") int target, @NativeType(value="uint32_t") int version) {
        long __functionAddress = Functions.compile_options_set_target_env;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)target, (int)version, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_target_spirv(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="shaderc_spirv_version") int version) {
        long __functionAddress = Functions.compile_options_set_target_spirv;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)version, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_warnings_as_errors(@NativeType(value="shaderc_compile_options_t") long options) {
        long __functionAddress = Functions.compile_options_set_warnings_as_errors;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_limit(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="shaderc_limit") int limit, int value) {
        long __functionAddress = Functions.compile_options_set_limit;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)limit, (int)value, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_auto_bind_uniforms(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="bool") boolean auto_bind) {
        long __functionAddress = Functions.compile_options_set_auto_bind_uniforms;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)auto_bind, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_hlsl_io_mapping(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="bool") boolean hlsl_iomap) {
        long __functionAddress = Functions.compile_options_set_hlsl_io_mapping;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)hlsl_iomap, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_hlsl_offsets(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="bool") boolean hlsl_offsets) {
        long __functionAddress = Functions.compile_options_set_hlsl_offsets;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)hlsl_offsets, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_binding_base(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="shaderc_uniform_kind") int kind, @NativeType(value="uint32_t") int base) {
        long __functionAddress = Functions.compile_options_set_binding_base;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)kind, (int)base, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_binding_base_for_stage(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="shaderc_shader_kind") int shader_kind, @NativeType(value="shaderc_uniform_kind") int kind, @NativeType(value="uint32_t") int base) {
        long __functionAddress = Functions.compile_options_set_binding_base_for_stage;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)shader_kind, (int)kind, (int)base, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_auto_map_locations(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="bool") boolean auto_map) {
        long __functionAddress = Functions.compile_options_set_auto_map_locations;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)auto_map, (long)__functionAddress);
    }

    public static void nshaderc_compile_options_set_hlsl_register_set_and_binding_for_stage(long options, int shader_kind, long reg, long set, long binding) {
        long __functionAddress = Functions.compile_options_set_hlsl_register_set_and_binding_for_stage;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePPPPV((long)options, (int)shader_kind, (long)reg, (long)set, (long)binding, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_hlsl_register_set_and_binding_for_stage(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="shaderc_shader_kind") int shader_kind, @NativeType(value="char const *") ByteBuffer reg, @NativeType(value="char const *") ByteBuffer set, @NativeType(value="char const *") ByteBuffer binding) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)reg);
            Checks.checkNT1((ByteBuffer)set);
            Checks.checkNT1((ByteBuffer)binding);
        }
        Shaderc.nshaderc_compile_options_set_hlsl_register_set_and_binding_for_stage(options, shader_kind, MemoryUtil.memAddress((ByteBuffer)reg), MemoryUtil.memAddress((ByteBuffer)set), MemoryUtil.memAddress((ByteBuffer)binding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shaderc_compile_options_set_hlsl_register_set_and_binding_for_stage(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="shaderc_shader_kind") int shader_kind, @NativeType(value="char const *") CharSequence reg, @NativeType(value="char const *") CharSequence set, @NativeType(value="char const *") CharSequence binding) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(reg, true);
            long regEncoded = stack.getPointerAddress();
            stack.nUTF8(set, true);
            long setEncoded = stack.getPointerAddress();
            stack.nUTF8(binding, true);
            long bindingEncoded = stack.getPointerAddress();
            Shaderc.nshaderc_compile_options_set_hlsl_register_set_and_binding_for_stage(options, shader_kind, regEncoded, setEncoded, bindingEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nshaderc_compile_options_set_hlsl_register_set_and_binding(long options, long reg, long set, long binding) {
        long __functionAddress = Functions.compile_options_set_hlsl_register_set_and_binding;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePPPPV((long)options, (long)reg, (long)set, (long)binding, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_hlsl_register_set_and_binding(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="char const *") ByteBuffer reg, @NativeType(value="char const *") ByteBuffer set, @NativeType(value="char const *") ByteBuffer binding) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)reg);
            Checks.checkNT1((ByteBuffer)set);
            Checks.checkNT1((ByteBuffer)binding);
        }
        Shaderc.nshaderc_compile_options_set_hlsl_register_set_and_binding(options, MemoryUtil.memAddress((ByteBuffer)reg), MemoryUtil.memAddress((ByteBuffer)set), MemoryUtil.memAddress((ByteBuffer)binding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shaderc_compile_options_set_hlsl_register_set_and_binding(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="char const *") CharSequence reg, @NativeType(value="char const *") CharSequence set, @NativeType(value="char const *") CharSequence binding) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(reg, true);
            long regEncoded = stack.getPointerAddress();
            stack.nUTF8(set, true);
            long setEncoded = stack.getPointerAddress();
            stack.nUTF8(binding, true);
            long bindingEncoded = stack.getPointerAddress();
            Shaderc.nshaderc_compile_options_set_hlsl_register_set_and_binding(options, regEncoded, setEncoded, bindingEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void shaderc_compile_options_set_hlsl_functionality1(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="bool") boolean enable) {
        long __functionAddress = Functions.compile_options_set_hlsl_functionality1;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)enable, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_invert_y(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="bool") boolean enable) {
        long __functionAddress = Functions.compile_options_set_invert_y;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)enable, (long)__functionAddress);
    }

    public static void shaderc_compile_options_set_nan_clamp(@NativeType(value="shaderc_compile_options_t") long options, @NativeType(value="bool") boolean enable) {
        long __functionAddress = Functions.compile_options_set_nan_clamp;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)enable, (long)__functionAddress);
    }

    public static long nshaderc_compile_into_spv(long compiler, long source_text, long source_text_size, int shader_kind, long input_file_name, long entry_point_name, long additional_options) {
        long __functionAddress = Functions.compile_into_spv;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPPPPP((long)compiler, (long)source_text, (long)source_text_size, (int)shader_kind, (long)input_file_name, (long)entry_point_name, (long)additional_options, (long)__functionAddress);
    }

    @NativeType(value="shaderc_compilation_result_t")
    public static long shaderc_compile_into_spv(@NativeType(value="shaderc_compiler_t const") long compiler, @NativeType(value="char const *") ByteBuffer source_text, @NativeType(value="shaderc_shader_kind") int shader_kind, @NativeType(value="char const *") ByteBuffer input_file_name, @NativeType(value="char const *") ByteBuffer entry_point_name, @NativeType(value="shaderc_compile_options_t const") long additional_options) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)input_file_name);
            Checks.checkNT1((ByteBuffer)entry_point_name);
        }
        return Shaderc.nshaderc_compile_into_spv(compiler, MemoryUtil.memAddress((ByteBuffer)source_text), source_text.remaining(), shader_kind, MemoryUtil.memAddress((ByteBuffer)input_file_name), MemoryUtil.memAddress((ByteBuffer)entry_point_name), additional_options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="shaderc_compilation_result_t")
    public static long shaderc_compile_into_spv(@NativeType(value="shaderc_compiler_t const") long compiler, @NativeType(value="char const *") CharSequence source_text, @NativeType(value="shaderc_shader_kind") int shader_kind, @NativeType(value="char const *") CharSequence input_file_name, @NativeType(value="char const *") CharSequence entry_point_name, @NativeType(value="shaderc_compile_options_t const") long additional_options) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int source_textEncodedLength = stack.nUTF8(source_text, false);
            long source_textEncoded = stack.getPointerAddress();
            stack.nUTF8(input_file_name, true);
            long input_file_nameEncoded = stack.getPointerAddress();
            stack.nUTF8(entry_point_name, true);
            long entry_point_nameEncoded = stack.getPointerAddress();
            long l = Shaderc.nshaderc_compile_into_spv(compiler, source_textEncoded, source_textEncodedLength, shader_kind, input_file_nameEncoded, entry_point_nameEncoded, additional_options);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nshaderc_compile_into_spv_assembly(long compiler, long source_text, long source_text_size, int shader_kind, long input_file_name, long entry_point_name, long additional_options) {
        long __functionAddress = Functions.compile_into_spv_assembly;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPPPPP((long)compiler, (long)source_text, (long)source_text_size, (int)shader_kind, (long)input_file_name, (long)entry_point_name, (long)additional_options, (long)__functionAddress);
    }

    @NativeType(value="shaderc_compilation_result_t")
    public static long shaderc_compile_into_spv_assembly(@NativeType(value="shaderc_compiler_t const") long compiler, @NativeType(value="char const *") ByteBuffer source_text, @NativeType(value="shaderc_shader_kind") int shader_kind, @NativeType(value="char const *") ByteBuffer input_file_name, @NativeType(value="char const *") ByteBuffer entry_point_name, @NativeType(value="shaderc_compile_options_t const") long additional_options) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)input_file_name);
            Checks.checkNT1((ByteBuffer)entry_point_name);
        }
        return Shaderc.nshaderc_compile_into_spv_assembly(compiler, MemoryUtil.memAddress((ByteBuffer)source_text), source_text.remaining(), shader_kind, MemoryUtil.memAddress((ByteBuffer)input_file_name), MemoryUtil.memAddress((ByteBuffer)entry_point_name), additional_options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="shaderc_compilation_result_t")
    public static long shaderc_compile_into_spv_assembly(@NativeType(value="shaderc_compiler_t const") long compiler, @NativeType(value="char const *") CharSequence source_text, @NativeType(value="shaderc_shader_kind") int shader_kind, @NativeType(value="char const *") CharSequence input_file_name, @NativeType(value="char const *") CharSequence entry_point_name, @NativeType(value="shaderc_compile_options_t const") long additional_options) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int source_textEncodedLength = stack.nUTF8(source_text, false);
            long source_textEncoded = stack.getPointerAddress();
            stack.nUTF8(input_file_name, true);
            long input_file_nameEncoded = stack.getPointerAddress();
            stack.nUTF8(entry_point_name, true);
            long entry_point_nameEncoded = stack.getPointerAddress();
            long l = Shaderc.nshaderc_compile_into_spv_assembly(compiler, source_textEncoded, source_textEncodedLength, shader_kind, input_file_nameEncoded, entry_point_nameEncoded, additional_options);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nshaderc_compile_into_preprocessed_text(long compiler, long source_text, long source_text_size, int shader_kind, long input_file_name, long entry_point_name, long additional_options) {
        long __functionAddress = Functions.compile_into_preprocessed_text;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPPPPP((long)compiler, (long)source_text, (long)source_text_size, (int)shader_kind, (long)input_file_name, (long)entry_point_name, (long)additional_options, (long)__functionAddress);
    }

    @NativeType(value="shaderc_compilation_result_t")
    public static long shaderc_compile_into_preprocessed_text(@NativeType(value="shaderc_compiler_t const") long compiler, @NativeType(value="char const *") ByteBuffer source_text, @NativeType(value="shaderc_shader_kind") int shader_kind, @NativeType(value="char const *") ByteBuffer input_file_name, @NativeType(value="char const *") ByteBuffer entry_point_name, @NativeType(value="shaderc_compile_options_t const") long additional_options) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)input_file_name);
            Checks.checkNT1((ByteBuffer)entry_point_name);
        }
        return Shaderc.nshaderc_compile_into_preprocessed_text(compiler, MemoryUtil.memAddress((ByteBuffer)source_text), source_text.remaining(), shader_kind, MemoryUtil.memAddress((ByteBuffer)input_file_name), MemoryUtil.memAddress((ByteBuffer)entry_point_name), additional_options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="shaderc_compilation_result_t")
    public static long shaderc_compile_into_preprocessed_text(@NativeType(value="shaderc_compiler_t const") long compiler, @NativeType(value="char const *") CharSequence source_text, @NativeType(value="shaderc_shader_kind") int shader_kind, @NativeType(value="char const *") CharSequence input_file_name, @NativeType(value="char const *") CharSequence entry_point_name, @NativeType(value="shaderc_compile_options_t const") long additional_options) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int source_textEncodedLength = stack.nUTF8(source_text, false);
            long source_textEncoded = stack.getPointerAddress();
            stack.nUTF8(input_file_name, true);
            long input_file_nameEncoded = stack.getPointerAddress();
            stack.nUTF8(entry_point_name, true);
            long entry_point_nameEncoded = stack.getPointerAddress();
            long l = Shaderc.nshaderc_compile_into_preprocessed_text(compiler, source_textEncoded, source_textEncodedLength, shader_kind, input_file_nameEncoded, entry_point_nameEncoded, additional_options);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nshaderc_assemble_into_spv(long compiler, long source_assembly, long source_assembly_size, long additional_options) {
        long __functionAddress = Functions.assemble_into_spv;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPPP((long)compiler, (long)source_assembly, (long)source_assembly_size, (long)additional_options, (long)__functionAddress);
    }

    @NativeType(value="shaderc_compilation_result_t")
    public static long shaderc_assemble_into_spv(@NativeType(value="shaderc_compiler_t const") long compiler, @NativeType(value="char const *") ByteBuffer source_assembly, @NativeType(value="shaderc_compile_options_t const") long additional_options) {
        return Shaderc.nshaderc_assemble_into_spv(compiler, MemoryUtil.memAddress((ByteBuffer)source_assembly), source_assembly.remaining(), additional_options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="shaderc_compilation_result_t")
    public static long shaderc_assemble_into_spv(@NativeType(value="shaderc_compiler_t const") long compiler, @NativeType(value="char const *") CharSequence source_assembly, @NativeType(value="shaderc_compile_options_t const") long additional_options) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int source_assemblyEncodedLength = stack.nUTF8(source_assembly, false);
            long source_assemblyEncoded = stack.getPointerAddress();
            long l = Shaderc.nshaderc_assemble_into_spv(compiler, source_assemblyEncoded, source_assemblyEncodedLength, additional_options);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void shaderc_result_release(@NativeType(value="shaderc_compilation_result_t") long result) {
        long __functionAddress = Functions.result_release;
        if (Checks.CHECKS) {
            Checks.check((long)result);
        }
        JNI.invokePV((long)result, (long)__functionAddress);
    }

    @NativeType(value="size_t")
    public static long shaderc_result_get_length(@NativeType(value="shaderc_compilation_result_t const") long result) {
        long __functionAddress = Functions.result_get_length;
        if (Checks.CHECKS) {
            Checks.check((long)result);
        }
        return JNI.invokePP((long)result, (long)__functionAddress);
    }

    @NativeType(value="size_t")
    public static long shaderc_result_get_num_warnings(@NativeType(value="shaderc_compilation_result_t const") long result) {
        long __functionAddress = Functions.result_get_num_warnings;
        if (Checks.CHECKS) {
            Checks.check((long)result);
        }
        return JNI.invokePP((long)result, (long)__functionAddress);
    }

    @NativeType(value="size_t")
    public static long shaderc_result_get_num_errors(@NativeType(value="shaderc_compilation_result_t const") long result) {
        long __functionAddress = Functions.result_get_num_errors;
        if (Checks.CHECKS) {
            Checks.check((long)result);
        }
        return JNI.invokePP((long)result, (long)__functionAddress);
    }

    @NativeType(value="shaderc_compilation_status")
    public static int shaderc_result_get_compilation_status(@NativeType(value="shaderc_compilation_result_t const") long result) {
        long __functionAddress = Functions.result_get_compilation_status;
        if (Checks.CHECKS) {
            Checks.check((long)result);
        }
        return JNI.invokePI((long)result, (long)__functionAddress);
    }

    public static long nshaderc_result_get_bytes(long result) {
        long __functionAddress = Functions.result_get_bytes;
        if (Checks.CHECKS) {
            Checks.check((long)result);
        }
        return JNI.invokePP((long)result, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static ByteBuffer shaderc_result_get_bytes(@NativeType(value="shaderc_compilation_result_t const") long result) {
        long __result = Shaderc.nshaderc_result_get_bytes(result);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)Shaderc.shaderc_result_get_length(result)));
    }

    @Nullable
    @NativeType(value="char const *")
    public static ByteBuffer shaderc_result_get_bytes(@NativeType(value="shaderc_compilation_result_t const") long result, long length) {
        long __result = Shaderc.nshaderc_result_get_bytes(result);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)length));
    }

    public static long nshaderc_result_get_error_message(long result) {
        long __functionAddress = Functions.result_get_error_message;
        if (Checks.CHECKS) {
            Checks.check((long)result);
        }
        return JNI.invokePP((long)result, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String shaderc_result_get_error_message(@NativeType(value="shaderc_compilation_result_t const") long result) {
        long __result = Shaderc.nshaderc_result_get_error_message(result);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static void nshaderc_get_spv_version(long version, long revision) {
        long __functionAddress = Functions.get_spv_version;
        JNI.invokePPV((long)version, (long)revision, (long)__functionAddress);
    }

    public static void shaderc_get_spv_version(@NativeType(value="unsigned int *") IntBuffer version, @NativeType(value="unsigned int *") IntBuffer revision) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)version, (int)1);
            Checks.check((Buffer)revision, (int)1);
        }
        Shaderc.nshaderc_get_spv_version(MemoryUtil.memAddress((IntBuffer)version), MemoryUtil.memAddress((IntBuffer)revision));
    }

    public static boolean nshaderc_parse_version_profile(long str, long version, long profile) {
        long __functionAddress = Functions.parse_version_profile;
        return JNI.invokePPPZ((long)str, (long)version, (long)profile, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean shaderc_parse_version_profile(@NativeType(value="char const *") ByteBuffer str, @NativeType(value="int *") IntBuffer version, @NativeType(value="shaderc_profile *") IntBuffer profile) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)str);
            Checks.check((Buffer)version, (int)1);
            Checks.check((Buffer)profile, (int)1);
        }
        return Shaderc.nshaderc_parse_version_profile(MemoryUtil.memAddress((ByteBuffer)str), MemoryUtil.memAddress((IntBuffer)version), MemoryUtil.memAddress((IntBuffer)profile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean shaderc_parse_version_profile(@NativeType(value="char const *") CharSequence str, @NativeType(value="int *") IntBuffer version, @NativeType(value="shaderc_profile *") IntBuffer profile) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)version, (int)1);
            Checks.check((Buffer)profile, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(str, true);
            long strEncoded = stack.getPointerAddress();
            boolean bl = Shaderc.nshaderc_parse_version_profile(strEncoded, MemoryUtil.memAddress((IntBuffer)version), MemoryUtil.memAddress((IntBuffer)profile));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static /* synthetic */ SharedLibrary access$000() {
        return SHADERC;
    }

    public static final class Functions {
        public static final long compiler_initialize = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compiler_initialize");
        public static final long compiler_release = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compiler_release");
        public static final long compile_options_initialize = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_initialize");
        public static final long compile_options_clone = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_clone");
        public static final long compile_options_release = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_release");
        public static final long compile_options_add_macro_definition = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_add_macro_definition");
        public static final long compile_options_set_source_language = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_source_language");
        public static final long compile_options_set_generate_debug_info = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_generate_debug_info");
        public static final long compile_options_set_optimization_level = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_optimization_level");
        public static final long compile_options_set_forced_version_profile = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_forced_version_profile");
        public static final long compile_options_set_include_callbacks = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_include_callbacks");
        public static final long compile_options_set_suppress_warnings = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_suppress_warnings");
        public static final long compile_options_set_target_env = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_target_env");
        public static final long compile_options_set_target_spirv = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_target_spirv");
        public static final long compile_options_set_warnings_as_errors = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_warnings_as_errors");
        public static final long compile_options_set_limit = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_limit");
        public static final long compile_options_set_auto_bind_uniforms = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_auto_bind_uniforms");
        public static final long compile_options_set_hlsl_io_mapping = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_hlsl_io_mapping");
        public static final long compile_options_set_hlsl_offsets = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_hlsl_offsets");
        public static final long compile_options_set_binding_base = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_binding_base");
        public static final long compile_options_set_binding_base_for_stage = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_binding_base_for_stage");
        public static final long compile_options_set_auto_map_locations = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_auto_map_locations");
        public static final long compile_options_set_hlsl_register_set_and_binding_for_stage = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_hlsl_register_set_and_binding_for_stage");
        public static final long compile_options_set_hlsl_register_set_and_binding = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_hlsl_register_set_and_binding");
        public static final long compile_options_set_hlsl_functionality1 = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_hlsl_functionality1");
        public static final long compile_options_set_invert_y = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_invert_y");
        public static final long compile_options_set_nan_clamp = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_options_set_nan_clamp");
        public static final long compile_into_spv = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_into_spv");
        public static final long compile_into_spv_assembly = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_into_spv_assembly");
        public static final long compile_into_preprocessed_text = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_compile_into_preprocessed_text");
        public static final long assemble_into_spv = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_assemble_into_spv");
        public static final long result_release = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_result_release");
        public static final long result_get_length = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_result_get_length");
        public static final long result_get_num_warnings = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_result_get_num_warnings");
        public static final long result_get_num_errors = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_result_get_num_errors");
        public static final long result_get_compilation_status = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_result_get_compilation_status");
        public static final long result_get_bytes = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_result_get_bytes");
        public static final long result_get_error_message = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_result_get_error_message");
        public static final long get_spv_version = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_get_spv_version");
        public static final long parse_version_profile = APIUtil.apiGetFunctionAddress((FunctionProvider)Shaderc.access$000(), (String)"shaderc_parse_version_profile");

        private Functions() {
        }
    }
}

