/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bullet;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct b3CollisionShapeData")
public class B3CollisionShapeData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_OBJECTUNIQUEID;
    public static final int M_LINKINDEX;
    public static final int M_COLLISIONGEOMETRYTYPE;
    public static final int M_DIMENSIONS;
    public static final int M_LOCALCOLLISIONFRAME;
    public static final int M_MESHASSETFILENAME;

    public B3CollisionShapeData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), B3CollisionShapeData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int m_objectUniqueId() {
        return B3CollisionShapeData.nm_objectUniqueId(this.address());
    }

    public int m_linkIndex() {
        return B3CollisionShapeData.nm_linkIndex(this.address());
    }

    public int m_collisionGeometryType() {
        return B3CollisionShapeData.nm_collisionGeometryType(this.address());
    }

    @NativeType(value="double[3]")
    public DoubleBuffer m_dimensions() {
        return B3CollisionShapeData.nm_dimensions(this.address());
    }

    public double m_dimensions(int index) {
        return B3CollisionShapeData.nm_dimensions(this.address(), index);
    }

    @NativeType(value="double[7]")
    public DoubleBuffer m_localCollisionFrame() {
        return B3CollisionShapeData.nm_localCollisionFrame(this.address());
    }

    public double m_localCollisionFrame(int index) {
        return B3CollisionShapeData.nm_localCollisionFrame(this.address(), index);
    }

    @NativeType(value="char[VISUAL_SHAPE_MAX_PATH_LEN]")
    public ByteBuffer m_meshAssetFileName() {
        return B3CollisionShapeData.nm_meshAssetFileName(this.address());
    }

    @NativeType(value="char[VISUAL_SHAPE_MAX_PATH_LEN]")
    public String m_meshAssetFileNameString() {
        return B3CollisionShapeData.nm_meshAssetFileNameString(this.address());
    }

    public B3CollisionShapeData m_objectUniqueId(int value) {
        B3CollisionShapeData.nm_objectUniqueId(this.address(), value);
        return this;
    }

    public B3CollisionShapeData m_linkIndex(int value) {
        B3CollisionShapeData.nm_linkIndex(this.address(), value);
        return this;
    }

    public B3CollisionShapeData m_collisionGeometryType(int value) {
        B3CollisionShapeData.nm_collisionGeometryType(this.address(), value);
        return this;
    }

    public B3CollisionShapeData m_dimensions(@NativeType(value="double[3]") DoubleBuffer value) {
        B3CollisionShapeData.nm_dimensions(this.address(), value);
        return this;
    }

    public B3CollisionShapeData m_dimensions(int index, double value) {
        B3CollisionShapeData.nm_dimensions(this.address(), index, value);
        return this;
    }

    public B3CollisionShapeData m_localCollisionFrame(@NativeType(value="double[7]") DoubleBuffer value) {
        B3CollisionShapeData.nm_localCollisionFrame(this.address(), value);
        return this;
    }

    public B3CollisionShapeData m_localCollisionFrame(int index, double value) {
        B3CollisionShapeData.nm_localCollisionFrame(this.address(), index, value);
        return this;
    }

    public B3CollisionShapeData m_meshAssetFileName(@NativeType(value="char[VISUAL_SHAPE_MAX_PATH_LEN]") ByteBuffer value) {
        B3CollisionShapeData.nm_meshAssetFileName(this.address(), value);
        return this;
    }

    public B3CollisionShapeData set(int m_objectUniqueId, int m_linkIndex, int m_collisionGeometryType, DoubleBuffer m_dimensions, DoubleBuffer m_localCollisionFrame, ByteBuffer m_meshAssetFileName) {
        this.m_objectUniqueId(m_objectUniqueId);
        this.m_linkIndex(m_linkIndex);
        this.m_collisionGeometryType(m_collisionGeometryType);
        this.m_dimensions(m_dimensions);
        this.m_localCollisionFrame(m_localCollisionFrame);
        this.m_meshAssetFileName(m_meshAssetFileName);
        return this;
    }

    public B3CollisionShapeData set(B3CollisionShapeData src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static B3CollisionShapeData malloc() {
        return (B3CollisionShapeData)B3CollisionShapeData.wrap(B3CollisionShapeData.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static B3CollisionShapeData calloc() {
        return (B3CollisionShapeData)B3CollisionShapeData.wrap(B3CollisionShapeData.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static B3CollisionShapeData create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (B3CollisionShapeData)B3CollisionShapeData.wrap(B3CollisionShapeData.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static B3CollisionShapeData create(long address) {
        return (B3CollisionShapeData)B3CollisionShapeData.wrap(B3CollisionShapeData.class, (long)address);
    }

    @Nullable
    public static B3CollisionShapeData createSafe(long address) {
        return address == 0L ? null : (B3CollisionShapeData)B3CollisionShapeData.wrap(B3CollisionShapeData.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)B3CollisionShapeData.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)B3CollisionShapeData.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)B3CollisionShapeData.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = B3CollisionShapeData.__create((int)capacity, (int)SIZEOF);
        return (Buffer)B3CollisionShapeData.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)B3CollisionShapeData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)B3CollisionShapeData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static B3CollisionShapeData mallocStack() {
        return B3CollisionShapeData.mallocStack(MemoryStack.stackGet());
    }

    public static B3CollisionShapeData callocStack() {
        return B3CollisionShapeData.callocStack(MemoryStack.stackGet());
    }

    public static B3CollisionShapeData mallocStack(MemoryStack stack) {
        return (B3CollisionShapeData)B3CollisionShapeData.wrap(B3CollisionShapeData.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static B3CollisionShapeData callocStack(MemoryStack stack) {
        return (B3CollisionShapeData)B3CollisionShapeData.wrap(B3CollisionShapeData.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return B3CollisionShapeData.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return B3CollisionShapeData.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3CollisionShapeData.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3CollisionShapeData.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nm_objectUniqueId(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_OBJECTUNIQUEID);
    }

    public static int nm_linkIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_LINKINDEX);
    }

    public static int nm_collisionGeometryType(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_COLLISIONGEOMETRYTYPE);
    }

    public static DoubleBuffer nm_dimensions(long struct) {
        return MemoryUtil.memDoubleBuffer((long)(struct + (long)M_DIMENSIONS), (int)3);
    }

    public static double nm_dimensions(long struct, int index) {
        return UNSAFE.getDouble(null, struct + (long)M_DIMENSIONS + Checks.check((int)index, (int)3) * 8L);
    }

    public static DoubleBuffer nm_localCollisionFrame(long struct) {
        return MemoryUtil.memDoubleBuffer((long)(struct + (long)M_LOCALCOLLISIONFRAME), (int)7);
    }

    public static double nm_localCollisionFrame(long struct, int index) {
        return UNSAFE.getDouble(null, struct + (long)M_LOCALCOLLISIONFRAME + Checks.check((int)index, (int)7) * 8L);
    }

    public static ByteBuffer nm_meshAssetFileName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)M_MESHASSETFILENAME), (int)1024);
    }

    public static String nm_meshAssetFileNameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)M_MESHASSETFILENAME));
    }

    public static void nm_objectUniqueId(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_OBJECTUNIQUEID, value);
    }

    public static void nm_linkIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_LINKINDEX, value);
    }

    public static void nm_collisionGeometryType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_COLLISIONGEOMETRYTYPE, value);
    }

    public static void nm_dimensions(long struct, DoubleBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((DoubleBuffer)value), (long)(struct + (long)M_DIMENSIONS), (long)(value.remaining() * 8));
    }

    public static void nm_dimensions(long struct, int index, double value) {
        UNSAFE.putDouble(null, struct + (long)M_DIMENSIONS + Checks.check((int)index, (int)3) * 8L, value);
    }

    public static void nm_localCollisionFrame(long struct, DoubleBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)7);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((DoubleBuffer)value), (long)(struct + (long)M_LOCALCOLLISIONFRAME), (long)(value.remaining() * 8));
    }

    public static void nm_localCollisionFrame(long struct, int index, double value) {
        UNSAFE.putDouble(null, struct + (long)M_LOCALCOLLISIONFRAME + Checks.check((int)index, (int)7) * 8L, value);
    }

    public static void nm_meshAssetFileName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)1024);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)M_MESHASSETFILENAME), (long)value.remaining());
    }

    static {
        Struct.Layout layout = B3CollisionShapeData.__struct((Struct.Member[])new Struct.Member[]{B3CollisionShapeData.__member((int)4), B3CollisionShapeData.__member((int)4), B3CollisionShapeData.__member((int)4), B3CollisionShapeData.__array((int)8, (int)3), B3CollisionShapeData.__array((int)8, (int)7), B3CollisionShapeData.__array((int)1, (int)1024)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_OBJECTUNIQUEID = layout.offsetof(0);
        M_LINKINDEX = layout.offsetof(1);
        M_COLLISIONGEOMETRYTYPE = layout.offsetof(2);
        M_DIMENSIONS = layout.offsetof(3);
        M_LOCALCOLLISIONFRAME = layout.offsetof(4);
        M_MESHASSETFILENAME = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<B3CollisionShapeData, Buffer>
    implements NativeResource {
        private static final B3CollisionShapeData ELEMENT_FACTORY = B3CollisionShapeData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected B3CollisionShapeData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int m_objectUniqueId() {
            return B3CollisionShapeData.nm_objectUniqueId(this.address());
        }

        public int m_linkIndex() {
            return B3CollisionShapeData.nm_linkIndex(this.address());
        }

        public int m_collisionGeometryType() {
            return B3CollisionShapeData.nm_collisionGeometryType(this.address());
        }

        @NativeType(value="double[3]")
        public DoubleBuffer m_dimensions() {
            return B3CollisionShapeData.nm_dimensions(this.address());
        }

        public double m_dimensions(int index) {
            return B3CollisionShapeData.nm_dimensions(this.address(), index);
        }

        @NativeType(value="double[7]")
        public DoubleBuffer m_localCollisionFrame() {
            return B3CollisionShapeData.nm_localCollisionFrame(this.address());
        }

        public double m_localCollisionFrame(int index) {
            return B3CollisionShapeData.nm_localCollisionFrame(this.address(), index);
        }

        @NativeType(value="char[VISUAL_SHAPE_MAX_PATH_LEN]")
        public ByteBuffer m_meshAssetFileName() {
            return B3CollisionShapeData.nm_meshAssetFileName(this.address());
        }

        @NativeType(value="char[VISUAL_SHAPE_MAX_PATH_LEN]")
        public String m_meshAssetFileNameString() {
            return B3CollisionShapeData.nm_meshAssetFileNameString(this.address());
        }

        public Buffer m_objectUniqueId(int value) {
            B3CollisionShapeData.nm_objectUniqueId(this.address(), value);
            return this;
        }

        public Buffer m_linkIndex(int value) {
            B3CollisionShapeData.nm_linkIndex(this.address(), value);
            return this;
        }

        public Buffer m_collisionGeometryType(int value) {
            B3CollisionShapeData.nm_collisionGeometryType(this.address(), value);
            return this;
        }

        public Buffer m_dimensions(@NativeType(value="double[3]") DoubleBuffer value) {
            B3CollisionShapeData.nm_dimensions(this.address(), value);
            return this;
        }

        public Buffer m_dimensions(int index, double value) {
            B3CollisionShapeData.nm_dimensions(this.address(), index, value);
            return this;
        }

        public Buffer m_localCollisionFrame(@NativeType(value="double[7]") DoubleBuffer value) {
            B3CollisionShapeData.nm_localCollisionFrame(this.address(), value);
            return this;
        }

        public Buffer m_localCollisionFrame(int index, double value) {
            B3CollisionShapeData.nm_localCollisionFrame(this.address(), index, value);
            return this;
        }

        public Buffer m_meshAssetFileName(@NativeType(value="char[VISUAL_SHAPE_MAX_PATH_LEN]") ByteBuffer value) {
            B3CollisionShapeData.nm_meshAssetFileName(this.address(), value);
            return this;
        }
    }
}

