/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkGeometryNV;

public class VkAccelerationStructureInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int TYPE;
    public static final int FLAGS;
    public static final int INSTANCECOUNT;
    public static final int GEOMETRYCOUNT;
    public static final int PGEOMETRIES;

    public VkAccelerationStructureInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAccelerationStructureInfoNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAccelerationStructureInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAccelerationStructureInfoNV.npNext(this.address());
    }

    @NativeType(value="VkAccelerationStructureTypeNV")
    public int type() {
        return VkAccelerationStructureInfoNV.ntype(this.address());
    }

    @NativeType(value="VkBuildAccelerationStructureFlagsNV")
    public int flags() {
        return VkAccelerationStructureInfoNV.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int instanceCount() {
        return VkAccelerationStructureInfoNV.ninstanceCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int geometryCount() {
        return VkAccelerationStructureInfoNV.ngeometryCount(this.address());
    }

    @Nullable
    @NativeType(value="VkGeometryNV const *")
    public VkGeometryNV.Buffer pGeometries() {
        return VkAccelerationStructureInfoNV.npGeometries(this.address());
    }

    public VkAccelerationStructureInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkAccelerationStructureInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInfoNV pNext(@NativeType(value="void const *") long value) {
        VkAccelerationStructureInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInfoNV type(@NativeType(value="VkAccelerationStructureTypeNV") int value) {
        VkAccelerationStructureInfoNV.ntype(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInfoNV flags(@NativeType(value="VkBuildAccelerationStructureFlagsNV") int value) {
        VkAccelerationStructureInfoNV.nflags(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInfoNV instanceCount(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureInfoNV.ninstanceCount(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInfoNV pGeometries(@Nullable @NativeType(value="VkGeometryNV const *") VkGeometryNV.Buffer value) {
        VkAccelerationStructureInfoNV.npGeometries(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInfoNV set(int sType, long pNext, int type, int flags, int instanceCount, @Nullable VkGeometryNV.Buffer pGeometries) {
        this.sType(sType);
        this.pNext(pNext);
        this.type(type);
        this.flags(flags);
        this.instanceCount(instanceCount);
        this.pGeometries(pGeometries);
        return this;
    }

    public VkAccelerationStructureInfoNV set(VkAccelerationStructureInfoNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAccelerationStructureInfoNV malloc() {
        return (VkAccelerationStructureInfoNV)VkAccelerationStructureInfoNV.wrap(VkAccelerationStructureInfoNV.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkAccelerationStructureInfoNV calloc() {
        return (VkAccelerationStructureInfoNV)VkAccelerationStructureInfoNV.wrap(VkAccelerationStructureInfoNV.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkAccelerationStructureInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkAccelerationStructureInfoNV)VkAccelerationStructureInfoNV.wrap(VkAccelerationStructureInfoNV.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkAccelerationStructureInfoNV create(long address) {
        return (VkAccelerationStructureInfoNV)VkAccelerationStructureInfoNV.wrap(VkAccelerationStructureInfoNV.class, (long)address);
    }

    @Nullable
    public static VkAccelerationStructureInfoNV createSafe(long address) {
        return address == 0L ? null : (VkAccelerationStructureInfoNV)VkAccelerationStructureInfoNV.wrap(VkAccelerationStructureInfoNV.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkAccelerationStructureInfoNV.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkAccelerationStructureInfoNV.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkAccelerationStructureInfoNV.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureInfoNV.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkAccelerationStructureInfoNV.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkAccelerationStructureInfoNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkAccelerationStructureInfoNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkAccelerationStructureInfoNV mallocStack() {
        return VkAccelerationStructureInfoNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkAccelerationStructureInfoNV callocStack() {
        return VkAccelerationStructureInfoNV.callocStack(MemoryStack.stackGet());
    }

    public static VkAccelerationStructureInfoNV mallocStack(MemoryStack stack) {
        return (VkAccelerationStructureInfoNV)VkAccelerationStructureInfoNV.wrap(VkAccelerationStructureInfoNV.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAccelerationStructureInfoNV callocStack(MemoryStack stack) {
        return (VkAccelerationStructureInfoNV)VkAccelerationStructureInfoNV.wrap(VkAccelerationStructureInfoNV.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkAccelerationStructureInfoNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkAccelerationStructureInfoNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkAccelerationStructureInfoNV.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkAccelerationStructureInfoNV.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int ninstanceCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)INSTANCECOUNT);
    }

    public static int ngeometryCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)GEOMETRYCOUNT);
    }

    @Nullable
    public static VkGeometryNV.Buffer npGeometries(long struct) {
        return VkGeometryNV.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PGEOMETRIES)), VkAccelerationStructureInfoNV.ngeometryCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ninstanceCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INSTANCECOUNT, value);
    }

    public static void ngeometryCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)GEOMETRYCOUNT, value);
    }

    public static void npGeometries(long struct, @Nullable VkGeometryNV.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PGEOMETRIES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkAccelerationStructureInfoNV.ngeometryCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkAccelerationStructureInfoNV.ngeometryCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PGEOMETRIES)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkAccelerationStructureInfoNV.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkAccelerationStructureInfoNV.__struct((Struct.Member[])new Struct.Member[]{VkAccelerationStructureInfoNV.__member((int)4), VkAccelerationStructureInfoNV.__member((int)POINTER_SIZE), VkAccelerationStructureInfoNV.__member((int)4), VkAccelerationStructureInfoNV.__member((int)4), VkAccelerationStructureInfoNV.__member((int)4), VkAccelerationStructureInfoNV.__member((int)4), VkAccelerationStructureInfoNV.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        TYPE = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        INSTANCECOUNT = layout.offsetof(4);
        GEOMETRYCOUNT = layout.offsetof(5);
        PGEOMETRIES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureInfoNV, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureInfoNV ELEMENT_FACTORY = VkAccelerationStructureInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkAccelerationStructureInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAccelerationStructureInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAccelerationStructureInfoNV.npNext(this.address());
        }

        @NativeType(value="VkAccelerationStructureTypeNV")
        public int type() {
            return VkAccelerationStructureInfoNV.ntype(this.address());
        }

        @NativeType(value="VkBuildAccelerationStructureFlagsNV")
        public int flags() {
            return VkAccelerationStructureInfoNV.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int instanceCount() {
            return VkAccelerationStructureInfoNV.ninstanceCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int geometryCount() {
            return VkAccelerationStructureInfoNV.ngeometryCount(this.address());
        }

        @Nullable
        @NativeType(value="VkGeometryNV const *")
        public VkGeometryNV.Buffer pGeometries() {
            return VkAccelerationStructureInfoNV.npGeometries(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAccelerationStructureInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAccelerationStructureInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="VkAccelerationStructureTypeNV") int value) {
            VkAccelerationStructureInfoNV.ntype(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkBuildAccelerationStructureFlagsNV") int value) {
            VkAccelerationStructureInfoNV.nflags(this.address(), value);
            return this;
        }

        public Buffer instanceCount(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureInfoNV.ninstanceCount(this.address(), value);
            return this;
        }

        public Buffer pGeometries(@Nullable @NativeType(value="VkGeometryNV const *") VkGeometryNV.Buffer value) {
            VkAccelerationStructureInfoNV.npGeometries(this.address(), value);
            return this;
        }
    }
}

