/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRect2D;

public class VkClearRect
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RECT;
    public static final int BASEARRAYLAYER;
    public static final int LAYERCOUNT;

    public VkClearRect(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkClearRect.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkRect2D rect() {
        return VkClearRect.nrect(this.address());
    }

    @NativeType(value="uint32_t")
    public int baseArrayLayer() {
        return VkClearRect.nbaseArrayLayer(this.address());
    }

    @NativeType(value="uint32_t")
    public int layerCount() {
        return VkClearRect.nlayerCount(this.address());
    }

    public VkClearRect rect(VkRect2D value) {
        VkClearRect.nrect(this.address(), value);
        return this;
    }

    public VkClearRect rect(Consumer<VkRect2D> consumer) {
        consumer.accept(this.rect());
        return this;
    }

    public VkClearRect baseArrayLayer(@NativeType(value="uint32_t") int value) {
        VkClearRect.nbaseArrayLayer(this.address(), value);
        return this;
    }

    public VkClearRect layerCount(@NativeType(value="uint32_t") int value) {
        VkClearRect.nlayerCount(this.address(), value);
        return this;
    }

    public VkClearRect set(VkRect2D rect, int baseArrayLayer, int layerCount) {
        this.rect(rect);
        this.baseArrayLayer(baseArrayLayer);
        this.layerCount(layerCount);
        return this;
    }

    public VkClearRect set(VkClearRect src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkClearRect malloc() {
        return (VkClearRect)VkClearRect.wrap(VkClearRect.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkClearRect calloc() {
        return (VkClearRect)VkClearRect.wrap(VkClearRect.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkClearRect create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkClearRect)VkClearRect.wrap(VkClearRect.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkClearRect create(long address) {
        return (VkClearRect)VkClearRect.wrap(VkClearRect.class, (long)address);
    }

    @Nullable
    public static VkClearRect createSafe(long address) {
        return address == 0L ? null : (VkClearRect)VkClearRect.wrap(VkClearRect.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkClearRect.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkClearRect.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkClearRect.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkClearRect.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkClearRect.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkClearRect.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkClearRect.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkClearRect mallocStack() {
        return VkClearRect.mallocStack(MemoryStack.stackGet());
    }

    public static VkClearRect callocStack() {
        return VkClearRect.callocStack(MemoryStack.stackGet());
    }

    public static VkClearRect mallocStack(MemoryStack stack) {
        return (VkClearRect)VkClearRect.wrap(VkClearRect.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkClearRect callocStack(MemoryStack stack) {
        return (VkClearRect)VkClearRect.wrap(VkClearRect.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkClearRect.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkClearRect.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkClearRect.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkClearRect.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static VkRect2D nrect(long struct) {
        return VkRect2D.create(struct + (long)RECT);
    }

    public static int nbaseArrayLayer(long struct) {
        return UNSAFE.getInt(null, struct + (long)BASEARRAYLAYER);
    }

    public static int nlayerCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYERCOUNT);
    }

    public static void nrect(long struct, VkRect2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RECT), (long)VkRect2D.SIZEOF);
    }

    public static void nbaseArrayLayer(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BASEARRAYLAYER, value);
    }

    public static void nlayerCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYERCOUNT, value);
    }

    static {
        Struct.Layout layout = VkClearRect.__struct((Struct.Member[])new Struct.Member[]{VkClearRect.__member((int)VkRect2D.SIZEOF, (int)VkRect2D.ALIGNOF), VkClearRect.__member((int)4), VkClearRect.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RECT = layout.offsetof(0);
        BASEARRAYLAYER = layout.offsetof(1);
        LAYERCOUNT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkClearRect, Buffer>
    implements NativeResource {
        private static final VkClearRect ELEMENT_FACTORY = VkClearRect.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkClearRect getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkRect2D rect() {
            return VkClearRect.nrect(this.address());
        }

        @NativeType(value="uint32_t")
        public int baseArrayLayer() {
            return VkClearRect.nbaseArrayLayer(this.address());
        }

        @NativeType(value="uint32_t")
        public int layerCount() {
            return VkClearRect.nlayerCount(this.address());
        }

        public Buffer rect(VkRect2D value) {
            VkClearRect.nrect(this.address(), value);
            return this;
        }

        public Buffer rect(Consumer<VkRect2D> consumer) {
            consumer.accept(this.rect());
            return this;
        }

        public Buffer baseArrayLayer(@NativeType(value="uint32_t") int value) {
            VkClearRect.nbaseArrayLayer(this.address(), value);
            return this;
        }

        public Buffer layerCount(@NativeType(value="uint32_t") int value) {
            VkClearRect.nlayerCount(this.address(), value);
            return this;
        }
    }
}

