"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearOldVersionCookieValue = clearOldVersionCookieValue;
exports.getSecurityCookieOptions = getSecurityCookieOptions;

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */
function getSecurityCookieOptions(config) {
  return {
    name: config.cookie.name,
    encryptionKey: config.cookie.password,
    validate: sessionStorage => {
      sessionStorage = sessionStorage;

      if (sessionStorage === undefined) {
        return {
          isValid: false,
          path: '/'
        };
      } // TODO: with setting redirect attributes to support OIDC and SAML,
      //       we need to do additonal cookie validatin in AuthenticationHandlers.
      // if SAML fields present


      if (sessionStorage.saml && sessionStorage.saml.requestId && sessionStorage.saml.nextUrl) {
        return {
          isValid: true,
          path: '/'
        };
      } // if OIDC fields present


      if (sessionStorage.oidc) {
        return {
          isValid: true,
          path: '/'
        };
      }

      if (sessionStorage.expiryTime === undefined || sessionStorage.expiryTime < Date.now()) {
        return {
          isValid: false,
          path: '/'
        };
      }

      return {
        isValid: true,
        path: '/'
      };
    },
    isSecure: config.cookie.secure,
    sameSite: config.cookie.isSameSite || undefined
  };
}

function clearOldVersionCookieValue(config) {
  if (config.cookie.secure) {
    return 'security_authentication=; Max-Age=0; Expires=Thu, 01 Jan 1970 00:00:00 GMT; Secure; HttpOnly; Path=/';
  } else {
    return 'security_authentication=; Max-Age=0; Expires=Thu, 01 Jan 1970 00:00:00 GMT; HttpOnly; Path=/';
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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