/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class KolmogorovSmirnovEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    private static final long serialVersionUID = 1L;

    public KolmogorovSmirnovEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (null == first || first instanceof List && ((List)first).stream().anyMatch(item -> null == item)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        if (null == second || second instanceof List && ((List)second).stream().anyMatch(item -> null == item)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
        }
        if (!(second instanceof List) || ((List)second).stream().anyMatch(item -> !(item instanceof Number))) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a List of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        KolmogorovSmirnovTest ks = new KolmogorovSmirnovTest();
        double[] data = ((List)second).stream().mapToDouble(item -> ((Number)item).doubleValue()).toArray();
        if (first instanceof RealDistribution) {
            RealDistribution realDistribution = (RealDistribution)first;
            Tuple tuple = new Tuple();
            tuple.put("p-value", ks.kolmogorovSmirnovTest(realDistribution, data));
            tuple.put("d-statistic", ks.kolmogorovSmirnovStatistic(realDistribution, data));
            return tuple;
        }
        if (first instanceof List && ((List)first).stream().noneMatch(item -> !(item instanceof Number))) {
            double[] data2 = ((List)first).stream().mapToDouble(item -> ((Number)item).doubleValue()).toArray();
            Tuple tuple = new Tuple();
            tuple.put("d-statistic", ks.kolmogorovSmirnovTest(data, data2));
            return tuple;
        }
        throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a RealDistribution or list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
    }
}

