/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.helper.DataConverter;
import org.traccar.model.Command;
import org.traccar.protocol.WatchProtocolDecoder;

public class WatchProtocolEncoder
extends StringProtocolEncoder
implements StringProtocolEncoder.ValueFormatter {
    private static Map<Byte, Byte> mapping = new HashMap<Byte, Byte>();

    public WatchProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    public String formatValue(String key, Object value) {
        if (key.equals("timezone")) {
            double offset = (double)TimeZone.getTimeZone((String)value).getRawOffset() / 3600000.0;
            DecimalFormat fmt = new DecimalFormat("+#.##;-#.##", DecimalFormatSymbols.getInstance(Locale.US));
            return fmt.format(offset);
        }
        if (key.equals("message")) {
            return DataConverter.printHex(value.toString().getBytes(StandardCharsets.UTF_16BE));
        }
        if (key.equals("enable")) {
            return (Boolean)value != false ? "1" : "0";
        }
        return null;
    }

    protected ByteBuf formatTextCommand(Channel channel, Command command, String format, String ... keys) {
        String content = this.formatCommand(command, format, this, keys);
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)content, (Charset)StandardCharsets.US_ASCII);
        return this.formatBinaryCommand(channel, command, "", buf);
    }

    protected ByteBuf formatBinaryCommand(Channel channel, Command command, String textPrefix, ByteBuf data) {
        WatchProtocolDecoder decoder;
        boolean hasIndex = false;
        String manufacturer = "CS";
        if (channel != null && (decoder = (WatchProtocolDecoder)channel.pipeline().get(WatchProtocolDecoder.class)) != null) {
            hasIndex = decoder.getHasIndex();
            manufacturer = decoder.getManufacturer();
            if (manufacturer.equals("3G")) {
                manufacturer = "SG";
            }
        }
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(91);
        buf.writeCharSequence((CharSequence)manufacturer, StandardCharsets.US_ASCII);
        buf.writeByte(42);
        buf.writeCharSequence((CharSequence)this.getUniqueId(command.getDeviceId()), StandardCharsets.US_ASCII);
        buf.writeByte(42);
        if (hasIndex) {
            buf.writeCharSequence((CharSequence)"0001", StandardCharsets.US_ASCII);
            buf.writeByte(42);
        }
        buf.writeCharSequence((CharSequence)String.format("%04x", data.readableBytes() + textPrefix.length()), StandardCharsets.US_ASCII);
        buf.writeByte(42);
        buf.writeCharSequence((CharSequence)textPrefix, StandardCharsets.US_ASCII);
        buf.writeBytes(data);
        buf.writeByte(93);
        return buf;
    }

    private ByteBuf getBinaryData(Command command) {
        byte[] data = DataConverter.parseHex(command.getString("data"));
        int encodedLength = data.length;
        for (byte b : data) {
            if (!mapping.containsKey(b)) continue;
            ++encodedLength;
        }
        int index = 0;
        byte[] encodedData = new byte[encodedLength];
        for (byte b : data) {
            Byte replacement = mapping.get(b);
            if (replacement != null) {
                encodedData[index] = 125;
                encodedData[++index] = replacement;
            } else {
                encodedData[index] = b;
            }
            ++index;
        }
        return Unpooled.copiedBuffer((byte[])encodedData);
    }

    @Override
    protected Object encodeCommand(Channel channel, Command command) {
        switch (command.getType()) {
            case "custom": {
                return this.formatTextCommand(channel, command, command.getString("data"), new String[0]);
            }
            case "positionSingle": {
                return this.formatTextCommand(channel, command, "CR", new String[0]);
            }
            case "sosNumber": {
                return this.formatTextCommand(channel, command, "SOS%s,%s", "index", "phone");
            }
            case "alarmSos": {
                return this.formatTextCommand(channel, command, "SOSSMS,%s", "enable");
            }
            case "alarmBattery": {
                return this.formatTextCommand(channel, command, "LOWBAT,%s", "enable");
            }
            case "rebootDevice": {
                return this.formatTextCommand(channel, command, "RESET", new String[0]);
            }
            case "powerOff": {
                return this.formatTextCommand(channel, command, "POWEROFF", new String[0]);
            }
            case "alarmRemove": {
                return this.formatTextCommand(channel, command, "REMOVE,%s", "enable");
            }
            case "silenceTime": {
                return this.formatTextCommand(channel, command, "SILENCETIME,%s", "data");
            }
            case "alarmClock": {
                return this.formatTextCommand(channel, command, "REMIND,%s", "data");
            }
            case "setPhonebook": {
                return this.formatTextCommand(channel, command, "PHB,%s", "data");
            }
            case "message": {
                return this.formatTextCommand(channel, command, "MESSAGE,%s", "message");
            }
            case "voiceMessage": {
                return this.formatBinaryCommand(channel, command, "TK,", this.getBinaryData(command));
            }
            case "positionPeriodic": {
                return this.formatTextCommand(channel, command, "UPLOAD,%s", "frequency");
            }
            case "setTimezone": {
                return this.formatTextCommand(channel, command, "LZ,%s,%s", "language", "timezone");
            }
            case "setIndicator": {
                return this.formatTextCommand(channel, command, "FLOWER,%s", "data");
            }
        }
        return null;
    }

    static {
        mapping.put((byte)125, (byte)1);
        mapping.put((byte)91, (byte)2);
        mapping.put((byte)93, (byte)3);
        mapping.put((byte)44, (byte)4);
        mapping.put((byte)42, (byte)5);
    }
}

