/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.schedule;

import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.database.NotificationManager;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.schedule.ScheduleTask;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Request;

public class TaskDeviceInactivityCheck
implements ScheduleTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskDeviceInactivityCheck.class);
    public static final String ATTRIBUTE_DEVICE_INACTIVITY_START = "deviceInactivityStart";
    public static final String ATTRIBUTE_DEVICE_INACTIVITY_PERIOD = "deviceInactivityPeriod";
    public static final String ATTRIBUTE_LAST_UPDATE = "lastUpdate";
    private static final long CHECK_PERIOD_MINUTES = 15L;
    private final Storage storage;
    private final NotificationManager notificationManager;

    @Inject
    public TaskDeviceInactivityCheck(Storage storage, NotificationManager notificationManager) {
        this.storage = storage;
        this.notificationManager = notificationManager;
    }

    @Override
    public void schedule(ScheduledExecutorService executor) {
        executor.scheduleAtFixedRate(this, 15L, 15L, TimeUnit.MINUTES);
    }

    @Override
    public void run() {
        long currentTime = System.currentTimeMillis();
        long checkPeriod = TimeUnit.MINUTES.toMillis(15L);
        HashMap<Event, Position> events = new HashMap<Event, Position>();
        try {
            for (Device device : this.storage.getObjects(Device.class, new Request(new Columns.All()))) {
                if (device.getLastUpdate() == null || !this.checkDevice(device, currentTime, checkPeriod)) continue;
                Event event = new Event("deviceInactive", device.getId());
                event.set(ATTRIBUTE_LAST_UPDATE, device.getLastUpdate().getTime());
                events.put(event, null);
            }
        }
        catch (StorageException e) {
            LOGGER.warn("Get devices error", (Throwable)e);
        }
        this.notificationManager.updateEvents(events);
    }

    private boolean checkDevice(Device device, long currentTime, long checkPeriod) {
        long timeThreshold;
        long deviceInactivityStart = device.getLong(ATTRIBUTE_DEVICE_INACTIVITY_START);
        if (deviceInactivityStart > 0L && currentTime >= (timeThreshold = device.getLastUpdate().getTime() + deviceInactivityStart)) {
            if (currentTime - checkPeriod < timeThreshold) {
                return true;
            }
            long deviceInactivityPeriod = device.getLong(ATTRIBUTE_DEVICE_INACTIVITY_PERIOD);
            if (deviceInactivityPeriod > 0L) {
                long count;
                return currentTime - checkPeriod < (timeThreshold += (count = (currentTime - timeThreshold - 1L) / deviceInactivityPeriod) * deviceInactivityPeriod);
            }
        }
        return false;
    }
}

