/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.web;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.servlets.DoSFilter;
import org.traccar.config.Config;
import org.traccar.config.Keys;

@Singleton
public class ThrottlingFilter
extends DoSFilter {
    @Inject
    private Config config;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (this.config.hasKey(Keys.WEB_MAX_REQUESTS_PER_SECOND)) {
            this.setMaxRequestsPerSec(this.config.getInteger(Keys.WEB_MAX_REQUESTS_PER_SECOND));
        }
    }

    protected String extractUserId(ServletRequest request) {
        HttpSession session = ((HttpServletRequest)request).getSession(false);
        if (session != null) {
            Object userId = session.getAttribute("userId");
            return userId != null ? userId.toString() : null;
        }
        return null;
    }
}

