"""Generated client library for gkehub version v1alpha."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.gkehub.v1alpha import gkehub_v1alpha_messages as messages


class GkehubV1alpha(base_api.BaseApiClient):
  """Generated client library for service gkehub version v1alpha."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://gkehub.googleapis.com/'
  MTLS_BASE_URL = 'https://gkehub.mtls.googleapis.com/'

  _PACKAGE = 'gkehub'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'GkehubV1alpha'
  _URL_VERSION = 'v1alpha'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new gkehub handle."""
    url = url or self.BASE_URL
    super(GkehubV1alpha, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.organizations_locations_fleets = self.OrganizationsLocationsFleetsService(self)
    self.organizations_locations = self.OrganizationsLocationsService(self)
    self.organizations = self.OrganizationsService(self)
    self.projects_locations_features = self.ProjectsLocationsFeaturesService(self)
    self.projects_locations_fleets = self.ProjectsLocationsFleetsService(self)
    self.projects_locations_memberships_namespacebindings = self.ProjectsLocationsMembershipsNamespacebindingsService(self)
    self.projects_locations_memberships = self.ProjectsLocationsMembershipsService(self)
    self.projects_locations_namespaces_rbacrolebindings = self.ProjectsLocationsNamespacesRbacrolebindingsService(self)
    self.projects_locations_namespaces = self.ProjectsLocationsNamespacesService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_workspaces = self.ProjectsLocationsWorkspacesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class OrganizationsLocationsFleetsService(base_api.BaseApiService):
    """Service class for the organizations_locations_fleets resource."""

    _NAME = 'organizations_locations_fleets'

    def __init__(self, client):
      super(GkehubV1alpha.OrganizationsLocationsFleetsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Returns all fleets within an organization or a project that the caller has access to.

      Args:
        request: (GkehubOrganizationsLocationsFleetsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFleetsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/organizations/{organizationsId}/locations/{locationsId}/fleets',
        http_method='GET',
        method_id='gkehub.organizations.locations.fleets.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/fleets',
        request_field='',
        request_type_name='GkehubOrganizationsLocationsFleetsListRequest',
        response_type_name='ListFleetsResponse',
        supports_download=False,
    )

  class OrganizationsLocationsService(base_api.BaseApiService):
    """Service class for the organizations_locations resource."""

    _NAME = 'organizations_locations'

    def __init__(self, client):
      super(GkehubV1alpha.OrganizationsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = 'organizations'

    def __init__(self, client):
      super(GkehubV1alpha.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsFeaturesService(base_api.BaseApiService):
    """Service class for the projects_locations_features resource."""

    _NAME = 'projects_locations_features'

    def __init__(self, client):
      super(GkehubV1alpha.ProjectsLocationsFeaturesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Adds a new Feature.

      Args:
        request: (GkehubProjectsLocationsFeaturesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/features',
        http_method='POST',
        method_id='gkehub.projects.locations.features.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['featureId', 'requestId'],
        relative_path='v1alpha/{+parent}/features',
        request_field='feature',
        request_type_name='GkehubProjectsLocationsFeaturesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Removes a Feature.

      Args:
        request: (GkehubProjectsLocationsFeaturesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/features/{featuresId}',
        http_method='DELETE',
        method_id='gkehub.projects.locations.features.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force', 'requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsFeaturesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Feature.

      Args:
        request: (GkehubProjectsLocationsFeaturesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Feature) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/features/{featuresId}',
        http_method='GET',
        method_id='gkehub.projects.locations.features.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsFeaturesGetRequest',
        response_type_name='Feature',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (GkehubProjectsLocationsFeaturesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/features/{featuresId}:getIamPolicy',
        http_method='GET',
        method_id='gkehub.projects.locations.features.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1alpha/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='GkehubProjectsLocationsFeaturesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Features in a given project and location.

      Args:
        request: (GkehubProjectsLocationsFeaturesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFeaturesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/features',
        http_method='GET',
        method_id='gkehub.projects.locations.features.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/features',
        request_field='',
        request_type_name='GkehubProjectsLocationsFeaturesListRequest',
        response_type_name='ListFeaturesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing Feature.

      Args:
        request: (GkehubProjectsLocationsFeaturesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/features/{featuresId}',
        http_method='PATCH',
        method_id='gkehub.projects.locations.features.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='feature',
        request_type_name='GkehubProjectsLocationsFeaturesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (GkehubProjectsLocationsFeaturesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/features/{featuresId}:setIamPolicy',
        http_method='POST',
        method_id='gkehub.projects.locations.features.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='GkehubProjectsLocationsFeaturesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (GkehubProjectsLocationsFeaturesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/features/{featuresId}:testIamPermissions',
        http_method='POST',
        method_id='gkehub.projects.locations.features.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='GkehubProjectsLocationsFeaturesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsFleetsService(base_api.BaseApiService):
    """Service class for the projects_locations_fleets resource."""

    _NAME = 'projects_locations_fleets'

    def __init__(self, client):
      super(GkehubV1alpha.ProjectsLocationsFleetsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a fleet.

      Args:
        request: (GkehubProjectsLocationsFleetsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/fleets',
        http_method='POST',
        method_id='gkehub.projects.locations.fleets.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha/{+parent}/fleets',
        request_field='fleet',
        request_type_name='GkehubProjectsLocationsFleetsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Removes a Fleet. There must be no memberships remaining in the Fleet.

      Args:
        request: (GkehubProjectsLocationsFleetsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/fleets/{fleetsId}',
        http_method='DELETE',
        method_id='gkehub.projects.locations.fleets.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsFleetsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the details of a fleet.

      Args:
        request: (GkehubProjectsLocationsFleetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Fleet) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/fleets/{fleetsId}',
        http_method='GET',
        method_id='gkehub.projects.locations.fleets.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsFleetsGetRequest',
        response_type_name='Fleet',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns all fleets within an organization or a project that the caller has access to.

      Args:
        request: (GkehubProjectsLocationsFleetsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFleetsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/fleets',
        http_method='GET',
        method_id='gkehub.projects.locations.fleets.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/fleets',
        request_field='',
        request_type_name='GkehubProjectsLocationsFleetsListRequest',
        response_type_name='ListFleetsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a fleet.

      Args:
        request: (GkehubProjectsLocationsFleetsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/fleets/{fleetsId}',
        http_method='PATCH',
        method_id='gkehub.projects.locations.fleets.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='fleet',
        request_type_name='GkehubProjectsLocationsFleetsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsMembershipsNamespacebindingsService(base_api.BaseApiService):
    """Service class for the projects_locations_memberships_namespacebindings resource."""

    _NAME = 'projects_locations_memberships_namespacebindings'

    def __init__(self, client):
      super(GkehubV1alpha.ProjectsLocationsMembershipsNamespacebindingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a NamespaceBinding.

      Args:
        request: (GkehubProjectsLocationsMembershipsNamespacebindingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}/namespacebindings',
        http_method='POST',
        method_id='gkehub.projects.locations.memberships.namespacebindings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['namespacebindingId'],
        relative_path='v1alpha/{+parent}/namespacebindings',
        request_field='namespaceBinding',
        request_type_name='GkehubProjectsLocationsMembershipsNamespacebindingsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a NamespaceBinding.

      Args:
        request: (GkehubProjectsLocationsMembershipsNamespacebindingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}/namespacebindings/{namespacebindingsId}',
        http_method='DELETE',
        method_id='gkehub.projects.locations.memberships.namespacebindings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsMembershipsNamespacebindingsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the details of a NamespaceBinding.

      Args:
        request: (GkehubProjectsLocationsMembershipsNamespacebindingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NamespaceBinding) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}/namespacebindings/{namespacebindingsId}',
        http_method='GET',
        method_id='gkehub.projects.locations.memberships.namespacebindings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsMembershipsNamespacebindingsGetRequest',
        response_type_name='NamespaceBinding',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists NamespaceBinding.

      Args:
        request: (GkehubProjectsLocationsMembershipsNamespacebindingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNamespaceBindingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}/namespacebindings',
        http_method='GET',
        method_id='gkehub.projects.locations.memberships.namespacebindings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/namespacebindings',
        request_field='',
        request_type_name='GkehubProjectsLocationsMembershipsNamespacebindingsListRequest',
        response_type_name='ListNamespaceBindingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a NamespaceBinding.

      Args:
        request: (GkehubProjectsLocationsMembershipsNamespacebindingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}/namespacebindings/{namespacebindingsId}',
        http_method='PATCH',
        method_id='gkehub.projects.locations.memberships.namespacebindings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='namespaceBinding',
        request_type_name='GkehubProjectsLocationsMembershipsNamespacebindingsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsMembershipsService(base_api.BaseApiService):
    """Service class for the projects_locations_memberships resource."""

    _NAME = 'projects_locations_memberships'

    def __init__(self, client):
      super(GkehubV1alpha.ProjectsLocationsMembershipsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Membership. **This is currently only supported for GKE clusters on Google Cloud**. To register other clusters, follow the instructions at https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster.

      Args:
        request: (GkehubProjectsLocationsMembershipsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships',
        http_method='POST',
        method_id='gkehub.projects.locations.memberships.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['membershipId', 'requestId'],
        relative_path='v1alpha/{+parent}/memberships',
        request_field='membership',
        request_type_name='GkehubProjectsLocationsMembershipsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Removes a Membership. **This is currently only supported for GKE clusters on Google Cloud**. To unregister other clusters, follow the instructions at https://cloud.google.com/anthos/multicluster-management/connect/unregistering-a-cluster.

      Args:
        request: (GkehubProjectsLocationsMembershipsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}',
        http_method='DELETE',
        method_id='gkehub.projects.locations.memberships.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsMembershipsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def GenerateConnectManifest(self, request, global_params=None):
      r"""Generates the manifest for deployment of the GKE connect agent. **This method is used internally by Google-provided libraries.** Most clients should not need to call this method directly.

      Args:
        request: (GkehubProjectsLocationsMembershipsGenerateConnectManifestRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GenerateConnectManifestResponse) The response message.
      """
      config = self.GetMethodConfig('GenerateConnectManifest')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateConnectManifest.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}:generateConnectManifest',
        http_method='GET',
        method_id='gkehub.projects.locations.memberships.generateConnectManifest',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['imagePullSecretContent', 'isUpgrade', 'namespace', 'proxy', 'registry', 'version'],
        relative_path='v1alpha/{+name}:generateConnectManifest',
        request_field='',
        request_type_name='GkehubProjectsLocationsMembershipsGenerateConnectManifestRequest',
        response_type_name='GenerateConnectManifestResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the details of a Membership.

      Args:
        request: (GkehubProjectsLocationsMembershipsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Membership) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}',
        http_method='GET',
        method_id='gkehub.projects.locations.memberships.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsMembershipsGetRequest',
        response_type_name='Membership',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (GkehubProjectsLocationsMembershipsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}:getIamPolicy',
        http_method='GET',
        method_id='gkehub.projects.locations.memberships.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1alpha/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='GkehubProjectsLocationsMembershipsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Memberships in a given project and location.

      Args:
        request: (GkehubProjectsLocationsMembershipsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMembershipsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships',
        http_method='GET',
        method_id='gkehub.projects.locations.memberships.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/memberships',
        request_field='',
        request_type_name='GkehubProjectsLocationsMembershipsListRequest',
        response_type_name='ListMembershipsResponse',
        supports_download=False,
    )

    def ListAdmin(self, request, global_params=None):
      r"""Lists Memberships of admin clusters in a given project and location. **This method is only used internally**.

      Args:
        request: (GkehubProjectsLocationsMembershipsListAdminRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAdminClusterMembershipsResponse) The response message.
      """
      config = self.GetMethodConfig('ListAdmin')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListAdmin.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships:listAdmin',
        http_method='GET',
        method_id='gkehub.projects.locations.memberships.listAdmin',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/memberships:listAdmin',
        request_field='',
        request_type_name='GkehubProjectsLocationsMembershipsListAdminRequest',
        response_type_name='ListAdminClusterMembershipsResponse',
        supports_download=False,
    )

    def ListNamespaces(self, request, global_params=None):
      r"""Lists fleet namespaces of a given membership.

      Args:
        request: (GkehubProjectsLocationsMembershipsListNamespacesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNamespacesForMembershipResponse) The response message.
      """
      config = self.GetMethodConfig('ListNamespaces')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListNamespaces.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}:listNamespaces',
        http_method='GET',
        method_id='gkehub.projects.locations.memberships.listNamespaces',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}:listNamespaces',
        request_field='',
        request_type_name='GkehubProjectsLocationsMembershipsListNamespacesRequest',
        response_type_name='ListNamespacesForMembershipResponse',
        supports_download=False,
    )

    def ListPermitted(self, request, global_params=None):
      r"""Lists Memberships that the user is permitted to access in IAM.

      Args:
        request: (GkehubProjectsLocationsMembershipsListPermittedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMembershipsResponse) The response message.
      """
      config = self.GetMethodConfig('ListPermitted')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListPermitted.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships:listPermitted',
        http_method='GET',
        method_id='gkehub.projects.locations.memberships.listPermitted',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/memberships:listPermitted',
        request_field='',
        request_type_name='GkehubProjectsLocationsMembershipsListPermittedRequest',
        response_type_name='ListMembershipsResponse',
        supports_download=False,
    )

    def ListWorkspaces(self, request, global_params=None):
      r"""Lists workspaces of a given membership.

      Args:
        request: (GkehubProjectsLocationsMembershipsListWorkspacesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListWorkspacesForMembershipResponse) The response message.
      """
      config = self.GetMethodConfig('ListWorkspaces')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListWorkspaces.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}:listWorkspaces',
        http_method='GET',
        method_id='gkehub.projects.locations.memberships.listWorkspaces',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}:listWorkspaces',
        request_field='',
        request_type_name='GkehubProjectsLocationsMembershipsListWorkspacesRequest',
        response_type_name='ListWorkspacesForMembershipResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing Membership.

      Args:
        request: (GkehubProjectsLocationsMembershipsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}',
        http_method='PATCH',
        method_id='gkehub.projects.locations.memberships.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='membership',
        request_type_name='GkehubProjectsLocationsMembershipsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (GkehubProjectsLocationsMembershipsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}:setIamPolicy',
        http_method='POST',
        method_id='gkehub.projects.locations.memberships.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='GkehubProjectsLocationsMembershipsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (GkehubProjectsLocationsMembershipsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}:testIamPermissions',
        http_method='POST',
        method_id='gkehub.projects.locations.memberships.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='GkehubProjectsLocationsMembershipsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

    def ValidateCreate(self, request, global_params=None):
      r"""ValidateCreateMembership is a preflight check for CreateMembership. It checks the following: 1. Caller has the required `gkehub.memberships.create` permission. 2. The membership_id is still available.

      Args:
        request: (GkehubProjectsLocationsMembershipsValidateCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ValidateCreateMembershipResponse) The response message.
      """
      config = self.GetMethodConfig('ValidateCreate')
      return self._RunMethod(
          config, request, global_params=global_params)

    ValidateCreate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/memberships:validateCreate',
        http_method='POST',
        method_id='gkehub.projects.locations.memberships.validateCreate',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha/{+parent}/memberships:validateCreate',
        request_field='validateCreateMembershipRequest',
        request_type_name='GkehubProjectsLocationsMembershipsValidateCreateRequest',
        response_type_name='ValidateCreateMembershipResponse',
        supports_download=False,
    )

  class ProjectsLocationsNamespacesRbacrolebindingsService(base_api.BaseApiService):
    """Service class for the projects_locations_namespaces_rbacrolebindings resource."""

    _NAME = 'projects_locations_namespaces_rbacrolebindings'

    def __init__(self, client):
      super(GkehubV1alpha.ProjectsLocationsNamespacesRbacrolebindingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a RBACRoleBinding.

      Args:
        request: (GkehubProjectsLocationsNamespacesRbacrolebindingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}/rbacrolebindings',
        http_method='POST',
        method_id='gkehub.projects.locations.namespaces.rbacrolebindings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['rbacrolebindingId'],
        relative_path='v1alpha/{+parent}/rbacrolebindings',
        request_field='rBACRoleBinding',
        request_type_name='GkehubProjectsLocationsNamespacesRbacrolebindingsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a RBACRoleBinding.

      Args:
        request: (GkehubProjectsLocationsNamespacesRbacrolebindingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}/rbacrolebindings/{rbacrolebindingsId}',
        http_method='DELETE',
        method_id='gkehub.projects.locations.namespaces.rbacrolebindings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsNamespacesRbacrolebindingsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the details of a RBACRoleBinding.

      Args:
        request: (GkehubProjectsLocationsNamespacesRbacrolebindingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RBACRoleBinding) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}/rbacrolebindings/{rbacrolebindingsId}',
        http_method='GET',
        method_id='gkehub.projects.locations.namespaces.rbacrolebindings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsNamespacesRbacrolebindingsGetRequest',
        response_type_name='RBACRoleBinding',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists RBACRoleBinding.

      Args:
        request: (GkehubProjectsLocationsNamespacesRbacrolebindingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRBACRoleBindingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}/rbacrolebindings',
        http_method='GET',
        method_id='gkehub.projects.locations.namespaces.rbacrolebindings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/rbacrolebindings',
        request_field='',
        request_type_name='GkehubProjectsLocationsNamespacesRbacrolebindingsListRequest',
        response_type_name='ListRBACRoleBindingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a RBACRoleBinding.

      Args:
        request: (GkehubProjectsLocationsNamespacesRbacrolebindingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}/rbacrolebindings/{rbacrolebindingsId}',
        http_method='PATCH',
        method_id='gkehub.projects.locations.namespaces.rbacrolebindings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='rBACRoleBinding',
        request_type_name='GkehubProjectsLocationsNamespacesRbacrolebindingsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsNamespacesService(base_api.BaseApiService):
    """Service class for the projects_locations_namespaces resource."""

    _NAME = 'projects_locations_namespaces'

    def __init__(self, client):
      super(GkehubV1alpha.ProjectsLocationsNamespacesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a fleet namespace.

      Args:
        request: (GkehubProjectsLocationsNamespacesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/namespaces',
        http_method='POST',
        method_id='gkehub.projects.locations.namespaces.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['namespaceId'],
        relative_path='v1alpha/{+parent}/namespaces',
        request_field='namespace',
        request_type_name='GkehubProjectsLocationsNamespacesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a fleet namespace.

      Args:
        request: (GkehubProjectsLocationsNamespacesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}',
        http_method='DELETE',
        method_id='gkehub.projects.locations.namespaces.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsNamespacesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the details of a fleet namespace.

      Args:
        request: (GkehubProjectsLocationsNamespacesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}',
        http_method='GET',
        method_id='gkehub.projects.locations.namespaces.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsNamespacesGetRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists fleet namespaces.

      Args:
        request: (GkehubProjectsLocationsNamespacesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNamespacesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/namespaces',
        http_method='GET',
        method_id='gkehub.projects.locations.namespaces.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/namespaces',
        request_field='',
        request_type_name='GkehubProjectsLocationsNamespacesListRequest',
        response_type_name='ListNamespacesResponse',
        supports_download=False,
    )

    def ListMemberships(self, request, global_params=None):
      r"""Lists Memberships that are bound to a Fleet Namespace.

      Args:
        request: (GkehubProjectsLocationsNamespacesListMembershipsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMembershipsForNamespaceResponse) The response message.
      """
      config = self.GetMethodConfig('ListMemberships')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListMemberships.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}:listMemberships',
        http_method='GET',
        method_id='gkehub.projects.locations.namespaces.listMemberships',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}:listMemberships',
        request_field='',
        request_type_name='GkehubProjectsLocationsNamespacesListMembershipsRequest',
        response_type_name='ListMembershipsForNamespaceResponse',
        supports_download=False,
    )

    def ListPermitted(self, request, global_params=None):
      r"""Lists fleet namespaces that the caller is permitted to access in IAM.

      Args:
        request: (GkehubProjectsLocationsNamespacesListPermittedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNamespacesResponse) The response message.
      """
      config = self.GetMethodConfig('ListPermitted')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListPermitted.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/namespaces:listPermitted',
        http_method='GET',
        method_id='gkehub.projects.locations.namespaces.listPermitted',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/namespaces:listPermitted',
        request_field='',
        request_type_name='GkehubProjectsLocationsNamespacesListPermittedRequest',
        response_type_name='ListNamespacesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a fleet namespace.

      Args:
        request: (GkehubProjectsLocationsNamespacesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}',
        http_method='PATCH',
        method_id='gkehub.projects.locations.namespaces.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='namespace',
        request_type_name='GkehubProjectsLocationsNamespacesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(GkehubV1alpha.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.

      Args:
        request: (GkehubProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='gkehub.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='GkehubProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (GkehubProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='gkehub.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (GkehubProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='gkehub.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to override the binding to use different resource name schemes, such as `users/*/operations`. To override the binding, API services can add a binding such as `"/v1/{name=users/*}/operations"` to their service configuration. For backwards compatibility, the default name includes the operations collection id, however overriding users must ensure the name binding is the parent resource, without the operations collection id.

      Args:
        request: (GkehubProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='gkehub.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}/operations',
        request_field='',
        request_type_name='GkehubProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsWorkspacesService(base_api.BaseApiService):
    """Service class for the projects_locations_workspaces resource."""

    _NAME = 'projects_locations_workspaces'

    def __init__(self, client):
      super(GkehubV1alpha.ProjectsLocationsWorkspacesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a Workspace.

      Args:
        request: (GkehubProjectsLocationsWorkspacesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/workspaces',
        http_method='POST',
        method_id='gkehub.projects.locations.workspaces.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['workspaceId'],
        relative_path='v1alpha/{+parent}/workspaces',
        request_field='workspace',
        request_type_name='GkehubProjectsLocationsWorkspacesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a Workspace.

      Args:
        request: (GkehubProjectsLocationsWorkspacesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/workspaces/{workspacesId}',
        http_method='DELETE',
        method_id='gkehub.projects.locations.workspaces.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsWorkspacesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the details of a Workspace.

      Args:
        request: (GkehubProjectsLocationsWorkspacesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Workspace) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/workspaces/{workspacesId}',
        http_method='GET',
        method_id='gkehub.projects.locations.workspaces.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsWorkspacesGetRequest',
        response_type_name='Workspace',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Workspaces.

      Args:
        request: (GkehubProjectsLocationsWorkspacesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListWorkspacesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/workspaces',
        http_method='GET',
        method_id='gkehub.projects.locations.workspaces.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/workspaces',
        request_field='',
        request_type_name='GkehubProjectsLocationsWorkspacesListRequest',
        response_type_name='ListWorkspacesResponse',
        supports_download=False,
    )

    def ListPermitted(self, request, global_params=None):
      r"""Lists workspaces that the caller is permitted to access in IAM.

      Args:
        request: (GkehubProjectsLocationsWorkspacesListPermittedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListWorkspacesResponse) The response message.
      """
      config = self.GetMethodConfig('ListPermitted')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListPermitted.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/workspaces:listPermitted',
        http_method='GET',
        method_id='gkehub.projects.locations.workspaces.listPermitted',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/workspaces:listPermitted',
        request_field='',
        request_type_name='GkehubProjectsLocationsWorkspacesListPermittedRequest',
        response_type_name='ListWorkspacesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a Workspace.

      Args:
        request: (GkehubProjectsLocationsWorkspacesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/workspaces/{workspacesId}',
        http_method='PATCH',
        method_id='gkehub.projects.locations.workspaces.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='workspace',
        request_type_name='GkehubProjectsLocationsWorkspacesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(GkehubV1alpha.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (GkehubProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='gkehub.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GkehubProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (GkehubProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations',
        http_method='GET',
        method_id='gkehub.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'includeUnrevealedLocations', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}/locations',
        request_field='',
        request_type_name='GkehubProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(GkehubV1alpha.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
