/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.base;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Set;
import org.apache.guacamole.auth.jdbc.JDBCEnvironment;
import org.apache.guacamole.auth.jdbc.base.EntityMapper;
import org.apache.guacamole.auth.jdbc.base.EntityModel;
import org.apache.guacamole.auth.jdbc.base.ModeledPermissions;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.guice.transactional.Transactional;

public class EntityService {
    @Inject
    private JDBCEnvironment environment;
    @Inject
    private EntityMapper entityMapper;
    @Inject
    private SqlSession sqlSession;

    @Transactional
    public Set<String> retrieveEffectiveGroups(ModeledPermissions<? extends EntityModel> entity, Collection<String> effectiveGroups) {
        boolean recursive = this.environment.isRecursiveQuerySupported(this.sqlSession);
        Set<String> identifiers = this.entityMapper.selectEffectiveGroupIdentifiers((EntityModel)entity.getModel(), effectiveGroups, recursive);
        if (!recursive && !identifiers.isEmpty()) {
            Set<String> previousIdentifiers;
            do {
                previousIdentifiers = identifiers;
            } while ((identifiers = this.entityMapper.selectEffectiveGroupIdentifiers((EntityModel)entity.getModel(), previousIdentifiers, false)).size() > previousIdentifiers.size());
        }
        return identifiers;
    }
}

