/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.sharing;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.AuthenticationProviderService;
import org.apache.guacamole.auth.jdbc.sharing.ConnectionSharingService;
import org.apache.guacamole.auth.jdbc.sharing.user.SharedAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.sharing.user.SharedUserContext;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;

public class SharedAuthenticationProviderService
implements AuthenticationProviderService {
    @Inject
    private Provider<SharedUserContext> sharedUserContextProvider;
    @Inject
    private ConnectionSharingService sharingService;

    @Override
    public AuthenticatedUser authenticateUser(AuthenticationProvider authenticationProvider, Credentials credentials) throws GuacamoleException {
        SharedAuthenticatedUser user = this.sharingService.retrieveSharedConnectionUser(authenticationProvider, credentials);
        if (user != null) {
            return user;
        }
        throw new GuacamoleInvalidCredentialsException("Invalid login", CredentialsInfo.USERNAME_PASSWORD);
    }

    public SharedUserContext getUserContext(AuthenticationProvider authenticationProvider, AuthenticatedUser authenticatedUser) throws GuacamoleException {
        SharedAuthenticatedUser sharedAuthenticatedUser = authenticatedUser instanceof SharedAuthenticatedUser ? (SharedAuthenticatedUser)authenticatedUser : new SharedAuthenticatedUser(authenticatedUser);
        SharedUserContext context = this.sharedUserContextProvider.get();
        context.init(authenticationProvider, sharedAuthenticatedUser);
        String shareKey = sharedAuthenticatedUser.getShareKey();
        if (shareKey != null) {
            context.registerShareKey(shareKey);
        }
        return context;
    }

    @Override
    public UserContext updateUserContext(AuthenticationProvider authenticationProvider, UserContext context, AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        String shareKey = this.sharingService.getShareKey(credentials);
        if (shareKey != null) {
            ((SharedUserContext)context).registerShareKey(shareKey);
        }
        return context;
    }
}

