/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.sso;

import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.binder.AnnotatedBindingBuilder;
import java.util.Arrays;
import java.util.Collections;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.sso.SSOAuthenticationProviderService;
import org.apache.guacamole.auth.sso.SSOResource;
import org.apache.guacamole.auth.sso.user.SSOAuthenticatedUser;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.environment.LocalEnvironment;
import org.apache.guacamole.net.auth.AbstractAuthenticationProvider;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.TokenInjectingUserContext;
import org.apache.guacamole.net.auth.UserContext;

public abstract class SSOAuthenticationProvider
extends AbstractAuthenticationProvider {
    private final Injector injector;

    public SSOAuthenticationProvider(Class<? extends SSOAuthenticationProviderService> authService, Class<? extends SSOResource> ssoResource, Module ... modules) {
        this(authService, ssoResource, Arrays.asList(modules));
    }

    public SSOAuthenticationProvider(final Class<? extends SSOAuthenticationProviderService> authService, final Class<? extends SSOResource> ssoResource, Iterable<? extends Module> modules) {
        this.injector = Guice.createInjector(Iterables.concat(Collections.singletonList(new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(AuthenticationProvider.class).toInstance((AuthenticationProvider)SSOAuthenticationProvider.this);
                this.bind(Environment.class).toInstance((Environment)LocalEnvironment.getInstance());
                this.bind(SSOAuthenticationProviderService.class).to(authService);
                AnnotatedBindingBuilder<SSOResource> resourceBinding = this.bind(SSOResource.class);
                if (ssoResource != SSOResource.class) {
                    resourceBinding.to(ssoResource);
                }
            }
        }), modules));
    }

    protected final Injector getInjector() {
        return this.injector;
    }

    public AuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        SSOAuthenticationProviderService authProviderService = this.injector.getInstance(SSOAuthenticationProviderService.class);
        return authProviderService.authenticateUser(credentials);
    }

    public UserContext decorate(UserContext context, AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        if (authenticatedUser.getAuthenticationProvider() != this) {
            return context;
        }
        return new TokenInjectingUserContext(context, ((SSOAuthenticatedUser)authenticatedUser).getTokens());
    }

    public SSOResource getResource() {
        return this.getInjector().getInstance(SSOResource.class);
    }

    public void shutdown() {
        this.injector.getInstance(SSOAuthenticationProviderService.class).shutdown();
    }
}

