/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.action.SendToBackAction;

public class BringToFrontAction
extends AbstractSelectedAction {
    public static String ID = "edit.bringToFront";

    public BringToFrontAction(DrawingEditor drawingEditor) {
        super(drawingEditor);
        this.labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final DrawingView drawingView = this.getView();
        final LinkedList<Figure> linkedList = new LinkedList<Figure>(drawingView.getSelectedFigures());
        BringToFrontAction.bringToFront(drawingView, linkedList);
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return BringToFrontAction.this.labels.getTextProperty(ID);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                BringToFrontAction.bringToFront(drawingView, linkedList);
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                SendToBackAction.sendToBack(drawingView, linkedList);
            }
        });
    }

    public static void bringToFront(DrawingView drawingView, Collection<Figure> collection) {
        Drawing drawing = drawingView.getDrawing();
        for (Figure figure : drawing.sort(collection)) {
            drawing.bringToFront(figure);
        }
    }
}

