/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.version.VersionConstraint;

public class UnsolvableVersionConflictException
extends RepositoryException {
    private final transient Collection<String> versions;
    private final transient Collection<? extends List<? extends DependencyNode>> paths;

    public UnsolvableVersionConflictException(Collection<? extends List<? extends DependencyNode>> paths) {
        super("Could not resolve version conflict among " + UnsolvableVersionConflictException.toPaths(paths));
        if (paths == null) {
            this.paths = Collections.emptyList();
            this.versions = Collections.emptyList();
        } else {
            this.paths = paths;
            this.versions = new LinkedHashSet<String>();
            for (List<? extends DependencyNode> list : paths) {
                VersionConstraint constraint = list.get(list.size() - 1).getVersionConstraint();
                if (constraint == null || constraint.getRange() == null) continue;
                this.versions.add(constraint.toString());
            }
        }
    }

    private static String toPaths(Collection<? extends List<? extends DependencyNode>> paths) {
        String result = "";
        if (paths != null) {
            LinkedHashSet<String> strings = new LinkedHashSet<String>();
            for (List<? extends DependencyNode> list : paths) {
                strings.add(UnsolvableVersionConflictException.toPath(list));
            }
            result = ((Object)strings).toString();
        }
        return result;
    }

    private static String toPath(List<? extends DependencyNode> path2) {
        StringBuilder buffer2 = new StringBuilder(256);
        Iterator<? extends DependencyNode> it = path2.iterator();
        while (it.hasNext()) {
            DependencyNode node2 = it.next();
            if (node2.getDependency() == null) continue;
            Artifact artifact = node2.getDependency().getArtifact();
            buffer2.append(artifact.getGroupId());
            buffer2.append(':').append(artifact.getArtifactId());
            buffer2.append(':').append(artifact.getExtension());
            if (artifact.getClassifier().length() > 0) {
                buffer2.append(':').append(artifact.getClassifier());
            }
            buffer2.append(':').append(node2.getVersionConstraint());
            if (!it.hasNext()) continue;
            buffer2.append(" -> ");
        }
        return buffer2.toString();
    }

    public Collection<? extends List<? extends DependencyNode>> getPaths() {
        return this.paths;
    }

    public Collection<String> getVersions() {
        return this.versions;
    }
}

