/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.CacheableInvocation;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.PrecomputedTransformationResult;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationNode;
import org.gradle.api.internal.artifacts.transform.TransformationNodeRegistry;
import org.gradle.api.internal.artifacts.transform.TransformationOperation;
import org.gradle.api.internal.artifacts.transform.TransformationResult;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public class TransformingAsyncArtifactListener
implements ResolvedArtifactSet.AsyncArtifactListener {
    private final Map<ComponentArtifactIdentifier, TransformationResult> artifactResults;
    private final ExecutionGraphDependenciesResolver dependenciesResolver;
    private final TransformationNodeRegistry transformationNodeRegistry;
    private final BuildOperationQueue<RunnableBuildOperation> actions;
    private final Transformation transformation;

    public TransformingAsyncArtifactListener(Transformation transformation, BuildOperationQueue<RunnableBuildOperation> actions, Map<ComponentArtifactIdentifier, TransformationResult> artifactResults, ExecutionGraphDependenciesResolver dependenciesResolver, TransformationNodeRegistry transformationNodeRegistry) {
        this.artifactResults = artifactResults;
        this.actions = actions;
        this.transformation = transformation;
        this.dependenciesResolver = dependenciesResolver;
        this.transformationNodeRegistry = transformationNodeRegistry;
    }

    @Override
    public void artifactAvailable(ResolvableArtifact artifact) {
        ComponentArtifactIdentifier artifactId = artifact.getId();
        Optional<TransformationNode> node = this.transformationNodeRegistry.getIfExecuted(artifactId, this.transformation);
        if (node.isPresent()) {
            this.artifactResults.put(artifactId, new PrecomputedTransformationResult(node.get().getTransformedSubject()));
        } else {
            File file = artifact.getFile();
            TransformationSubject initialSubject = TransformationSubject.initial(artifactId, file);
            TransformationResult result = this.createTransformationResult(initialSubject);
            this.artifactResults.put(artifactId, result);
        }
    }

    @Override
    public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
        return FileCollectionStructureVisitor.VisitType.Visit;
    }

    @Override
    public boolean requireArtifactFiles() {
        return true;
    }

    private TransformationResult createTransformationResult(TransformationSubject initialSubject) {
        CacheableInvocation<TransformationSubject> invocation = this.transformation.createInvocation(initialSubject, this.dependenciesResolver, null);
        return invocation.getCachedResult().map(PrecomputedTransformationResult::new).orElseGet(() -> {
            TransformationOperation operation = new TransformationOperation(invocation, "Transform " + initialSubject.getDisplayName() + " with " + this.transformation.getDisplayName());
            this.actions.add((BuildOperation)operation);
            return operation;
        });
    }
}

