/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.tasks;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Buildable;
import org.gradle.api.DefaultTask;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.metadata.GradleModuleMetadataWriter;
import org.gradle.api.publish.internal.metadata.ModuleMetadataSpec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Cast;
import org.gradle.internal.Try;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.serialization.Cached;
import org.gradle.internal.serialization.Transient;

public class GenerateModuleMetadata
extends DefaultTask {
    private final Transient<Property<Publication>> publication;
    private final Transient<ListProperty<Publication>> publications;
    private final RegularFileProperty outputFile;
    private final FileCollection variantFiles;
    private final Cached<InputState> inputState = Cached.of(this::computeInputState);

    public GenerateModuleMetadata() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.publication = Transient.of((Object)objectFactory.property(Publication.class));
        this.publications = Transient.of((Object)objectFactory.listProperty(Publication.class));
        this.outputFile = objectFactory.fileProperty();
        this.variantFiles = this.getFileCollectionFactory().create((MinimalFileSet)new VariantFiles());
        this.getOutputs().upToDateWhen(Specs.satisfyNone());
        this.setOnlyIf(SerializableLambdas.spec((SerializableLambdas.SerializableSpec & Serializable)task -> this.hasAttachedComponent()));
    }

    @Internal
    public Property<Publication> getPublication() {
        return (Property)this.publication.get();
    }

    @Internal
    public ListProperty<Publication> getPublications() {
        return (ListProperty)this.publications.get();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    FileCollection getArtifacts() {
        return this.variantFiles;
    }

    @Inject
    protected FileCollectionFactory getFileCollectionFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected BuildInvocationScopeId getBuildInvocationScopeId() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ProjectDependencyPublicationResolver getProjectDependencyPublicationResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ChecksumService getChecksumService() {
        throw new UnsupportedOperationException();
    }

    @OutputFile
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    @TaskAction
    void run() {
        InputState inputState = this.inputState();
        if (!(inputState instanceof InputState.Ready)) {
            throw new IllegalStateException(inputState.toString());
        }
        this.writeModuleMetadata((ModuleMetadataSpec)((InputState.Ready)inputState).moduleMetadataSpec.get());
    }

    private void writeModuleMetadata(ModuleMetadataSpec moduleMetadataSpec) {
        try (BufferedWriter writer = this.bufferedWriterFor(((RegularFile)this.outputFile.get()).getAsFile());){
            this.moduleMetadataWriter().writeTo(writer, moduleMetadataSpec);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not generate metadata file " + this.outputFile.get(), (Throwable)e);
        }
    }

    private BufferedWriter bufferedWriterFor(File file) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
    }

    private GradleModuleMetadataWriter moduleMetadataWriter() {
        return new GradleModuleMetadataWriter(this.getBuildInvocationScopeId(), this.getProjectDependencyPublicationResolver(), this.getChecksumService());
    }

    private boolean hasAttachedComponent() {
        InputState inputState = this.inputState();
        if (inputState instanceof InputState.ComponentMissing) {
            String publicationName = ((InputState.ComponentMissing)inputState).publicationName;
            this.getLogger().warn(publicationName + " isn't attached to a component. Gradle metadata only supports publications with software components (e.g. from component.java)");
            return false;
        }
        return true;
    }

    private InputState computeInputState() {
        return this.component() == null ? new InputState.ComponentMissing(this.publicationName()) : new InputState.Ready(this.moduleMetadataSpec());
    }

    private Try<ModuleMetadataSpec> moduleMetadataSpec() {
        return Try.ofFailable(this::computeModuleMetadataSpec);
    }

    private ModuleMetadataSpec computeModuleMetadataSpec() {
        return this.moduleMetadataWriter().moduleMetadataSpecFor(this.publication(), this.publications());
    }

    private InputState inputState() {
        return (InputState)this.inputState.get();
    }

    private String publicationName() {
        return this.publication().getDisplayName().toString();
    }

    private SoftwareComponentInternal component() {
        return this.publication().getComponent();
    }

    private PublicationInternal<?> publication() {
        return (PublicationInternal)Cast.uncheckedNonnullCast((Object)((Property)this.publication.get()).get());
    }

    private List<PublicationInternal<?>> publications() {
        return (List)Cast.uncheckedCast((Object)((ListProperty)this.publications.get()).get());
    }

    private class VariantFiles
    implements MinimalFileSet,
    Buildable {
        private VariantFiles() {
        }

        @Nonnull
        public String getDisplayName() {
            return "files of " + GenerateModuleMetadata.this.getPath();
        }

        @Nonnull
        public TaskDependency getBuildDependencies() {
            DefaultTaskDependency dependency = new DefaultTaskDependency();
            SoftwareComponentInternal component = GenerateModuleMetadata.this.component();
            if (component != null) {
                this.forEachArtifactOf(component, (Action<PublishArtifact>)((Action)xva$0 -> dependency.add(new Object[]{xva$0})));
            }
            return dependency;
        }

        @Nonnull
        public Set<File> getFiles() {
            SoftwareComponentInternal component = GenerateModuleMetadata.this.component();
            return component == null ? ImmutableSet.of() : this.filesOf(component);
        }

        private Set<File> filesOf(SoftwareComponentInternal component) {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            this.forEachArtifactOf(component, (Action<PublishArtifact>)((Action)artifact -> files.add(artifact.getFile())));
            return files;
        }

        private void forEachArtifactOf(SoftwareComponentInternal component, Action<PublishArtifact> action) {
            for (UsageContext usageContext : component.getUsages()) {
                for (PublishArtifact publishArtifact : usageContext.getArtifacts()) {
                    action.execute((Object)publishArtifact);
                }
            }
        }
    }

    static class InputState {
        InputState() {
        }

        static class ComponentMissing
        extends InputState {
            final String publicationName;

            public ComponentMissing(String publicationName) {
                this.publicationName = publicationName;
            }
        }

        static class Ready
        extends InputState {
            final Try<ModuleMetadataSpec> moduleMetadataSpec;

            public Ready(Try<ModuleMetadataSpec> moduleMetadataSpec) {
                this.moduleMetadataSpec = moduleMetadataSpec;
            }
        }
    }
}

