/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.activity;

import com.intellij.compiler.server.BuildManagerListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.Version;
import de.plushnikov.intellij.plugin.activity.LombokBuildManagerListener;
import de.plushnikov.intellij.plugin.activity.LombokPluginDisposable;
import de.plushnikov.intellij.plugin.settings.ProjectSettings;
import de.plushnikov.intellij.plugin.util.LombokLibraryUtil;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public class LombokProjectValidatorActivity
implements StartupActivity.DumbAware {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            LombokProjectValidatorActivity.$$$reportNull$$$0(0);
        }
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(BuildManagerListener.TOPIC, (Object)new LombokBuildManagerListener());
        if (ProjectSettings.isEnabled(project, "LombokPluginIS_LOMBOK_VERSION_CHECK_Enabled", false)) {
            ReadAction.nonBlocking(() -> {
                String lombokVersion;
                if (project.isDisposed()) {
                    return null;
                }
                boolean hasLombokLibrary = LombokLibraryUtil.hasLombokLibrary(project);
                if (hasLombokLibrary && StringUtil.isNotEmpty((String)(lombokVersion = LombokLibraryUtil.getLombokVersionCached(project))) && Version.isLessThan(lombokVersion, "1.18.22")) {
                    return LombokProjectValidatorActivity.getNotificationGroup().createNotification(LombokBundle.message("config.warn.dependency.outdated.title", new Object[0]), LombokBundle.message("config.warn.dependency.outdated.message", project.getName(), lombokVersion, "1.18.22"), NotificationType.WARNING);
                }
                return null;
            }).expireWith(LombokPluginDisposable.getInstance(project)).coalesceBy(new Object[]{project, LombokProjectValidatorActivity.class}).finishOnUiThread(ModalityState.NON_MODAL, notification -> {
                if (notification != null) {
                    notification.setListener(NotificationListener.URL_OPENING_LISTENER).notify(project);
                    Disposer.register((Disposable)LombokPluginDisposable.getInstance(project), () -> ((Notification)notification).expire());
                }
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    @NotNull
    private static NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Lombok plugin");
        if (notificationGroup == null) {
            LombokProjectValidatorActivity.$$$reportNull$$$0(1);
        }
        return notificationGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/activity/LombokProjectValidatorActivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/activity/LombokProjectValidatorActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

