/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.fieldnameconstants;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFieldNameConstantsProcessor
extends AbstractClassProcessor {
    private static final String FIELD_NAME_CONSTANTS_INCLUDE = "lombok.experimental.FieldNameConstants.Include";
    private static final String FIELD_NAME_CONSTANTS_EXCLUDE = "lombok.experimental.FieldNameConstants.Exclude";

    AbstractFieldNameConstantsProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass) {
        if (supportedClass == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(0);
        }
        if (supportedAnnotationClass == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(1);
        }
        super(supportedClass, supportedAnnotationClass);
    }

    @Override
    protected boolean supportAnnotationVariant(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(2);
        }
        return null != psiAnnotation.findAttributeValue("asEnum");
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(3);
        }
        if (psiClass == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(5);
        }
        return this.validateAnnotationOnRightType(psiClass, builder) && LombokProcessorUtil.isLevelVisible(psiAnnotation);
    }

    private boolean validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiClass == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(7);
        }
        if (psiClass.isAnnotationType() || psiClass.isInterface()) {
            builder.addError(LombokBundle.message("inspection.message.field.name.constants.only.supported.on.class.or.enum", new Object[0]));
            return false;
        }
        return true;
    }

    @NotNull
    Collection<PsiField> filterFields(@NotNull PsiClass psiClass, PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(8);
        }
        ArrayList<PsiField> psiFields = new ArrayList<PsiField>();
        boolean onlyExplicitlyIncluded = PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, "onlyExplicitlyIncluded", false);
        for (PsiField psiField : PsiClassUtil.collectClassFieldsIntern(psiClass)) {
            boolean useField = true;
            PsiModifierList modifierList = psiField.getModifierList();
            if (null != modifierList) {
                useField = !modifierList.hasModifierProperty("static");
                useField &= !modifierList.hasModifierProperty("transient");
            }
            useField &= !psiField.getName().startsWith("$");
            useField &= !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiField, FIELD_NAME_CONSTANTS_EXCLUDE);
            if (onlyExplicitlyIncluded) {
                useField = PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiField, FIELD_NAME_CONSTANTS_INCLUDE);
            }
            if (!useField) continue;
            psiFields.add(psiField);
        }
        ArrayList<PsiField> arrayList = psiFields;
        if (arrayList == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(10);
        }
        Collection<PsiAnnotation> result = super.collectProcessedAnnotations(psiClass);
        this.addFieldsAnnotation(result, psiClass, FIELD_NAME_CONSTANTS_INCLUDE, FIELD_NAME_CONSTANTS_EXCLUDE);
        Collection<PsiAnnotation> collection = result;
        if (collection == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        PsiClass containingClass;
        if (psiField == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(12);
        }
        if (psiAnnotation == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(13);
        }
        if (null != (containingClass = psiField.getContainingClass()) && PsiClassUtil.getNames(this.filterFields(containingClass, psiAnnotation)).contains(psiField.getName())) {
            return LombokPsiElementUsage.USAGE;
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedAnnotationClass";
                break;
            }
            case 2: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/fieldnameconstants/AbstractFieldNameConstantsProcessor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/fieldnameconstants/AbstractFieldNameConstantsProcessor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFields";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supportAnnotationVariant";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterFields";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

