/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J$\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001d\u001a\u00020\bH\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/GrChangeModifiersFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "modifiersToRemove", "", "", "modifierToInsert", "textRepresentation", "removeModifierUnderCaret", "", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Z)V", "getModifierToInsert", "()Ljava/lang/String;", "modifiersToRemoveSet", "", "getModifiersToRemoveSet", "()Ljava/util/Set;", "getRemoveModifierUnderCaret", "()Z", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "startInWriteAction", "intellij.groovy.psi"})
public final class GrChangeModifiersFix
implements IntentionAction {
    @NotNull
    private final Set<String> modifiersToRemoveSet;
    private final List<String> modifiersToRemove;
    @Nullable
    private final String modifierToInsert;
    private final String textRepresentation;
    private final boolean removeModifierUnderCaret;

    @NotNull
    public final Set<String> getModifiersToRemoveSet() {
        return this.modifiersToRemoveSet;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getText() {
        return this.textRepresentation;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("intention.family.name.replace.modifiers", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GroovyBundle.message(\"in\u2026.name.replace.modifiers\")");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null) {
            return false;
        }
        return file != null;
        {
        }
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        block15: {
            PsiModifierListOwner owner;
            block17: {
                block16: {
                    PsiElement[] psiElementArray;
                    String elementUnderCaretRepresentation;
                    block14: {
                        block13: {
                            PsiElement elementUnderCaret;
                            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                            if (editor == null) {
                                return;
                            }
                            if (file == null) {
                                return;
                            }
                            CaretModel caretModel = editor.getCaretModel();
                            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                            PsiElement psiElement = file.findElementAt(caretModel.getOffset());
                            if (psiElement == null) {
                                return;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"file.findElementAt(edito\u2026etModel.offset) ?: return");
                            PsiElement $this$parentOfType$iv = elementUnderCaret = psiElement;
                            boolean withSelf$iv = false;
                            boolean $i$f$parentOfType = false;
                            PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiModifierListOwner.class, (boolean)true);
                            if (psiModifierListOwner == null) {
                                return;
                            }
                            owner = psiModifierListOwner;
                            elementUnderCaretRepresentation = elementUnderCaret.getText();
                            psiElementArray = owner.getModifierList();
                            if (psiElementArray == null) break block13;
                            PsiElement[] $this$castSafelyTo$iv = psiElementArray;
                            boolean $i$f$castSafelyTo = false;
                            PsiElement[] psiElementArray2 = $this$castSafelyTo$iv;
                            if (!($this$castSafelyTo$iv instanceof GrModifierList)) {
                                psiElementArray2 = null;
                            }
                            if ((psiElementArray = (PsiElement[])psiElementArray2) != null && (psiElementArray = psiElementArray.getModifiers()) != null) break block14;
                        }
                        return;
                    }
                    PsiElement[] modifiers = psiElementArray;
                    boolean hasRequiredModifier = false;
                    for (PsiElement modifier : modifiers) {
                        String modifierRepresentation;
                        String string;
                        if (modifier instanceof PsiAnnotation) {
                            string = ((PsiAnnotation)modifier).getQualifiedName();
                        } else {
                            PsiElement psiElement = modifier;
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"modifier");
                            string = modifierRepresentation = psiElement.getText();
                        }
                        if (Intrinsics.areEqual((Object)modifierRepresentation, (Object)this.modifierToInsert)) {
                            hasRequiredModifier = true;
                        }
                        if (!this.removeModifierUnderCaret && Intrinsics.areEqual((Object)modifierRepresentation, (Object)elementUnderCaretRepresentation) || !CollectionsKt.contains((Iterable)this.modifiersToRemove, (Object)modifierRepresentation)) continue;
                        modifier.delete();
                    }
                    if (hasRequiredModifier || this.modifierToInsert == null) break block15;
                    Intrinsics.checkNotNullExpressionValue((Object)GrModifier.GROOVY_MODIFIERS, (String)"GrModifier.GROOVY_MODIFIERS");
                    if (ArraysKt.contains((Object[])GrModifier.GROOVY_MODIFIERS, (Object)this.modifierToInsert)) break block16;
                    Intrinsics.checkNotNullExpressionValue((Object)PsiModifier.MODIFIERS, (String)"PsiModifier.MODIFIERS");
                    if (!ArraysKt.contains((Object[])PsiModifier.MODIFIERS, (Object)this.modifierToInsert)) break block17;
                }
                PsiModifierList psiModifierList = owner.getModifierList();
                if (psiModifierList == null) break block15;
                psiModifierList.setModifierProperty(this.modifierToInsert, true);
                break block15;
            }
            PsiModifierList psiModifierList = owner.getModifierList();
            if (psiModifierList == null) break block15;
            psiModifierList.addAnnotation(this.modifierToInsert);
        }
    }

    @Nullable
    public final String getModifierToInsert() {
        return this.modifierToInsert;
    }

    public final boolean getRemoveModifierUnderCaret() {
        return this.removeModifierUnderCaret;
    }

    public GrChangeModifiersFix(@NotNull List<String> modifiersToRemove, @Nullable String modifierToInsert, @Nls @NotNull String textRepresentation, boolean removeModifierUnderCaret) {
        Intrinsics.checkNotNullParameter(modifiersToRemove, (String)"modifiersToRemove");
        Intrinsics.checkNotNullParameter((Object)textRepresentation, (String)"textRepresentation");
        this.modifiersToRemove = modifiersToRemove;
        this.modifierToInsert = modifierToInsert;
        this.textRepresentation = textRepresentation;
        this.removeModifierUnderCaret = removeModifierUnderCaret;
        this.modifiersToRemoveSet = CollectionsKt.toSet((Iterable)this.modifiersToRemove);
    }

    public /* synthetic */ GrChangeModifiersFix(List list, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(list, string, string2, bl);
    }
}

