/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.codeInsight.JavaTargetElementEvaluator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.GrPropertyForCompletion;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.DefaultConstructor;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrRenameableLightElement;
import org.jetbrains.plugins.groovy.lang.resolve.CollapsingKt;

public class GroovyTargetElementEvaluator
extends JavaTargetElementEvaluator {
    public static final Key<Object> NAVIGATION_ELEMENT_IS_NOT_TARGET = Key.create((String)"GroovyTargetElementEvaluator.DONT_FOLLOW_NAVIGATION_ELEMENT");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PsiElement getElementByReference(@NotNull PsiReference ref, int flags) {
        PsiElement sourceElement;
        if (ref == null) {
            GroovyTargetElementEvaluator.$$$reportNull$$$0(0);
        }
        if ((sourceElement = ref.getElement()) instanceof GrCodeReferenceElement) {
            GrNewExpression newExpr;
            PsiElement parent2 = sourceElement.getParent();
            if (parent2 instanceof GrNewExpression) {
                newExpr = (GrNewExpression)parent2;
            } else {
                if (!(parent2 instanceof GrAnonymousClassDefinition)) return null;
                PsiElement grandParent = parent2.getParent();
                if (!(grandParent instanceof GrNewExpression)) return null;
                newExpr = (GrNewExpression)grandParent;
            }
            PsiMethod constructor = newExpr.resolveMethod();
            if (constructor instanceof DefaultConstructor) {
                return constructor.getContainingClass();
            }
            GrArgumentList argumentList = newExpr.getArgumentList();
            if (constructor == null || argumentList == null || !PsiImplUtil.hasNamedArguments(argumentList) || PsiImplUtil.hasExpressionArguments(argumentList) || !constructor.getParameterList().isEmpty()) return constructor;
            return constructor.getContainingClass();
        }
        if (!(sourceElement instanceof GrReferenceExpression)) return null;
        PsiElement resolved = ((GrReferenceExpression)sourceElement).resolve();
        if (!(resolved instanceof GrGdkMethod) && resolved instanceof GrRenameableLightElement) return resolved;
        return GroovyTargetElementEvaluator.correctSearchTargets(resolved);
    }

    @Nullable
    public static PsiElement correctSearchTargets(@Nullable PsiElement target) {
        PsiMethod mirror;
        if (target instanceof ClsMethodImpl && (mirror = ((ClsMethodImpl)target).getSourceMirrorMethod()) != null) {
            return mirror.getNavigationElement();
        }
        if (target != null && !(target instanceof GrAccessorMethod) && target.getUserData(NAVIGATION_ELEMENT_IS_NOT_TARGET) == null) {
            if (target instanceof PsiMirrorElement) {
                return ((PsiMirrorElement)target).getPrototype();
            }
            return target.getNavigationElement();
        }
        return target;
    }

    @Nullable
    public Collection<PsiElement> getTargetCandidates(@NotNull PsiReference reference) {
        Object[] results;
        GrReferenceExpression referenceExpression;
        if (reference == null) {
            GroovyTargetElementEvaluator.$$$reportNull$$$0(1);
        }
        if (reference instanceof GrReferenceExpression && (referenceExpression = (GrReferenceExpression)reference).hasMemberPointer() && (results = referenceExpression.multiResolve(false)).length > 0) {
            return CollapsingKt.collapseReflectedMethods(ContainerUtil.mapNotNull((Object[])results, it -> it.getElement()));
        }
        return super.getTargetCandidates(reference);
    }

    @Nullable
    public PsiElement adjustTargetElement(Editor editor, int offset, int flags, @NotNull PsiElement targetElement) {
        if (targetElement == null) {
            GroovyTargetElementEvaluator.$$$reportNull$$$0(2);
        }
        if (targetElement instanceof GrPropertyForCompletion) {
            return ((GrPropertyForCompletion)targetElement).getOriginalAccessor();
        }
        return super.adjustTargetElement(editor, offset, flags, targetElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyTargetElementEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementByReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetCandidates";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustTargetElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

