/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.impl.ConstantExpressionEvaluator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

public class GroovyConstantExpressionEvaluator
implements ConstantExpressionEvaluator {
    @Nullable
    public static Object evaluate(@Nullable GrExpression expression) {
        PsiElement resolved;
        GrExpression operand = PsiUtilKt.skipParenthesesDownOrNull(expression);
        if (operand instanceof GrLiteral) {
            return ((GrLiteral)operand).getValue();
        }
        if (operand instanceof GrUnaryExpression) {
            Object evaluatedOperand = GroovyConstantExpressionEvaluator.evaluate(((GrUnaryExpression)operand).getOperand());
            if (((GrUnaryExpression)operand).getOperationTokenType() == GroovyElementTypes.T_MINUS && evaluatedOperand instanceof Number) {
                if (evaluatedOperand instanceof Integer) {
                    return -((Integer)evaluatedOperand).intValue();
                }
                if (evaluatedOperand instanceof Byte) {
                    return (int)(-((Byte)evaluatedOperand).byteValue());
                }
                if (evaluatedOperand instanceof Short) {
                    return (int)(-((Short)evaluatedOperand).shortValue());
                }
                if (evaluatedOperand instanceof Long) {
                    return -((Long)evaluatedOperand).longValue();
                }
                if (evaluatedOperand instanceof Double) {
                    return -((Double)evaluatedOperand).doubleValue();
                }
                if (evaluatedOperand instanceof Float) {
                    return Float.valueOf(-((Float)evaluatedOperand).floatValue());
                }
            }
        }
        if (expression instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)expression).resolve()) instanceof PsiField) {
            return ((PsiField)resolved).computeConstantValue();
        }
        return null;
    }

    @ApiStatus.Internal
    public static Object evaluateNoResolve(@Nullable GrExpression expression) {
        GrExpression operand = PsiUtilKt.skipParenthesesDownOrNull(expression);
        if (operand instanceof GrLiteral) {
            return ((GrLiteral)operand).getValue();
        }
        return null;
    }

    @Nullable
    public Object computeConstantExpression(PsiElement expression, boolean throwExceptionOnOverflow) {
        if (!(expression instanceof GrExpression)) {
            return null;
        }
        return GroovyConstantExpressionEvaluator.evaluate((GrExpression)expression);
    }

    @Nullable
    public Object computeExpression(PsiElement expression, boolean throwExceptionOnOverflow, @Nullable PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        if (!(expression instanceof GrExpression)) {
            return null;
        }
        return GroovyConstantExpressionEvaluator.evaluate((GrExpression)expression);
    }
}

