/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public abstract class BuilderAnnotationContributor
implements AstTransformationSupport {
    @NlsSafe
    public static final String BUILDER_PACKAGE = "groovy.transform.builder";
    @NlsSafe
    public static final String BUILDER_FQN = "groovy.transform.builder.Builder";
    @NonNls
    public static final String ORIGIN_INFO = "via @Builder";
    @NlsSafe
    public static final String STRATEGY_ATTRIBUTE = "builderStrategy";

    @Contract(value="null, _ -> false")
    public static boolean isApplicable(@Nullable PsiAnnotation annotation, @NotNull String strategy) {
        if (strategy == null) {
            BuilderAnnotationContributor.$$$reportNull$$$0(0);
        }
        if (annotation == null) {
            return false;
        }
        PsiClass aClass = GrAnnotationUtil.inferClassAttribute(annotation, STRATEGY_ATTRIBUTE);
        if (aClass == null) {
            return false;
        }
        return StringUtil.getQualifiedName((String)BUILDER_PACKAGE, (String)strategy).equals(aClass.getQualifiedName());
    }

    public static PsiField[] getFields(@NotNull TransformationContext context, boolean includeSuper) {
        if (context == null) {
            BuilderAnnotationContributor.$$$reportNull$$$0(1);
        }
        return BuilderAnnotationContributor.filterFields(includeSuper ? context.getAllFields(false) : context.getFields(), context);
    }

    public static PsiField[] getFields(@NotNull GrTypeDefinition clazz, boolean includeSuper, @NotNull TransformationContext context) {
        if (clazz == null) {
            BuilderAnnotationContributor.$$$reportNull$$$0(2);
        }
        if (context == null) {
            BuilderAnnotationContributor.$$$reportNull$$$0(3);
        }
        return BuilderAnnotationContributor.filterFields(includeSuper ? Arrays.asList(GrClassImplUtil.getAllFields(clazz, false)) : Arrays.asList(clazz.getFields()), context);
    }

    private static PsiField[] filterFields(Collection<? extends PsiField> collectedFields, @NotNull TransformationContext context) {
        if (context == null) {
            BuilderAnnotationContributor.$$$reportNull$$$0(4);
        }
        return (PsiField[])collectedFields.stream().filter(field -> {
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList instanceof GrModifierList) {
                return !context.hasModifierProperty((GrModifierList)modifierList, "static");
            }
            return true;
        }).filter(field -> {
            PsiClass aClass = field.getContainingClass();
            if (aClass == null || aClass.getQualifiedName() == null) {
                return false;
            }
            String name = aClass.getQualifiedName();
            return !name.equals("groovy.lang.GroovyObjectSupport") && !name.equals("groovy.lang.GroovyObject");
        }).toArray(PsiField[]::new);
    }

    public static boolean isIncludeSuperProperties(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            BuilderAnnotationContributor.$$$reportNull$$$0(5);
        }
        return PsiUtil.getAnnoAttributeValue(annotation, "includeSuperProperties", false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/BuilderAnnotationContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "filterFields";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isIncludeSuperProperties";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

