/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.ExpectedType;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GrConstraintFormula;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.TypeConstraint;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/TypePositionConstraint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GrConstraintFormula;", "expectedType", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/ExpectedType;", "rightType", "Lcom/intellij/psi/PsiType;", "context", "Lcom/intellij/psi/PsiElement;", "(Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/ExpectedType;Lcom/intellij/psi/PsiType;Lcom/intellij/psi/PsiElement;)V", "reduce", "", "session", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "constraints", "", "Lcom/intellij/psi/impl/source/resolve/graphInference/constraints/ConstraintFormula;", "intellij.groovy.psi"})
public final class TypePositionConstraint
extends GrConstraintFormula {
    private final ExpectedType expectedType;
    private final PsiType rightType;
    private final PsiElement context;

    @Override
    public boolean reduce(@NotNull GroovyInferenceSession session, @NotNull List<? super ConstraintFormula> constraints) {
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        if (this.rightType != null) {
            ExtensionPointName<GrTypeConverter> extensionPointName = GrTypeConverter.EP_NAME;
            Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"GrTypeConverter.EP_NAME");
            for (GrTypeConverter extension : extensionPointName.getExtensionList()) {
                Collection<ConstraintFormula> reduced;
                if (!extension.isApplicableTo(this.expectedType.getPosition()) || (reduced = extension.reduceTypeConstraint(this.expectedType.getType(), this.rightType, this.expectedType.getPosition(), this.context)) == null) continue;
                Collection collection = constraints;
                CollectionsKt.addAll((Collection)collection, (Iterable)reduced);
                return true;
            }
        }
        Collection collection = constraints;
        TypeConstraint typeConstraint = new TypeConstraint(this.expectedType.getType(), this.rightType, this.context);
        collection.add(typeConstraint);
        return true;
    }

    public TypePositionConstraint(@NotNull ExpectedType expectedType, @Nullable PsiType rightType, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.expectedType = expectedType;
        this.rightType = rightType;
        this.context = context;
    }
}

