/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract.closure;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import it.unimi.dsi.fastutil.ints.IntList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParameterListOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractInfoHelperBase;
import org.jetbrains.plugins.groovy.refactoring.extract.closure.ExtractClosureProcessorBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.IntroduceParameterInfo;

public class ExtractClosureHelperImpl
extends ExtractInfoHelperBase
implements GrIntroduceParameterSettings {
    private final GrParameterListOwner myOwner;
    private final PsiElement myToSearchFor;
    private final String myName;
    private final boolean myFinal;
    private final IntList myToRemove;
    private final boolean myGenerateDelegate;
    private final int myReplaceFieldsWithGetters;
    private final boolean myForceReturn;
    private final boolean myReplaceAllOccurrences;
    private PsiType myType = null;
    private final boolean myForceDef;

    public ExtractClosureHelperImpl(IntroduceParameterInfo info, String name, boolean declareFinal, IntList toRemove, boolean generateDelegate, int replaceFieldsWithGetters, boolean forceReturn, boolean replaceAllOccurrences, boolean forceDef) {
        super(info);
        this.myForceReturn = forceReturn;
        this.myReplaceAllOccurrences = replaceAllOccurrences;
        this.myForceDef = forceDef;
        this.myOwner = info.getToReplaceIn();
        this.myToSearchFor = info.getToSearchFor();
        this.myName = name;
        this.myFinal = declareFinal;
        this.myToRemove = toRemove;
        this.myGenerateDelegate = generateDelegate;
        this.myReplaceFieldsWithGetters = replaceFieldsWithGetters;
    }

    @Override
    @NotNull
    public GrParameterListOwner getToReplaceIn() {
        GrParameterListOwner grParameterListOwner = this.myOwner;
        if (grParameterListOwner == null) {
            ExtractClosureHelperImpl.$$$reportNull$$$0(0);
        }
        return grParameterListOwner;
    }

    @Override
    public PsiElement getToSearchFor() {
        return this.myToSearchFor;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean declareFinal() {
        return this.myFinal;
    }

    @Override
    public IntList parametersToRemove() {
        return this.myToRemove;
    }

    @Override
    public int replaceFieldsWithGetters() {
        return this.myReplaceFieldsWithGetters;
    }

    @Override
    public boolean removeLocalVariable() {
        return false;
    }

    @Override
    public boolean replaceAllOccurrences() {
        return this.myReplaceAllOccurrences;
    }

    @Override
    public PsiType getSelectedType() {
        if (this.myForceDef) {
            return null;
        }
        if (this.myType == null) {
            PsiType[] parameters2;
            GrClosableBlock closure = ExtractClosureProcessorBase.generateClosure(this);
            PsiType type2 = closure.getType();
            if (type2 instanceof PsiClassType && (parameters2 = ((PsiClassType)type2).getParameters()).length == 1 && parameters2[0] != null && parameters2[0].equalsToText("java.lang.Void")) {
                type2 = ((PsiClassType)type2).rawType();
            }
            this.myType = type2;
        }
        return this.myType;
    }

    @Override
    public boolean generateDelegate() {
        return this.myGenerateDelegate;
    }

    @Override
    public boolean isForceReturn() {
        return this.myForceReturn;
    }

    @Override
    @Nullable
    public GrVariable getVar() {
        return null;
    }

    @Override
    public GrExpression getExpression() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureHelperImpl", "getToReplaceIn"));
    }
}

