/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.util.containers.MultiMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public class RenameGroovyScriptProcessor
extends RenamePsiFileProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenameGroovyScriptProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof GroovyFile && ((GroovyFile)element).isScript() && GroovyScriptUtil.isPlainGroovyScript((GroovyFile)element);
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        String scriptName;
        PsiClass script;
        if (element == null) {
            RenameGroovyScriptProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            RenameGroovyScriptProcessor.$$$reportNull$$$0(2);
        }
        if (allRenames == null) {
            RenameGroovyScriptProcessor.$$$reportNull$$$0(3);
        }
        if (element instanceof GroovyFile && (script = ((GroovyFile)element).getScriptClass()) != null && script.isValid() && StringUtil.isJavaIdentifier((String)(scriptName = FileUtilRt.getNameWithoutExtension((String)newName)))) {
            allRenames.put((PsiElement)script, scriptName);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        String scriptName;
        if (element == null) {
            RenameGroovyScriptProcessor.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            RenameGroovyScriptProcessor.$$$reportNull$$$0(5);
        }
        if (conflicts == null) {
            RenameGroovyScriptProcessor.$$$reportNull$$$0(6);
        }
        if (!StringUtil.isJavaIdentifier((String)(scriptName = FileUtilRt.getNameWithoutExtension((String)newName)))) {
            PsiClass script = ((GroovyFile)element).getScriptClass();
            conflicts.putValue((Object)script, (Object)GroovyRefactoringBundle.message("cannot.rename.script.class.to.0", script.getName(), scriptName));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/rename/RenameGroovyScriptProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingNameConflicts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

