/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.Comparator;
import java.util.List;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyFacetUtil;
import org.jetbrains.plugins.groovy.util.GroovySelectModuleStep;
import org.jetbrains.plugins.groovy.util.RightTextCellRenderer;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aD\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\n\u001a8\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\nH\u0002\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b\u001a\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b\u001a>\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00142\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"GROOVY_LAST_MODULE", "", "createSelectModulePopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "project", "Lcom/intellij/openapi/project/Project;", "modules", "", "Lcom/intellij/openapi/module/Module;", "version", "Lkotlin/Function1;", "consumer", "", "createSelectModulePopupStep", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "hasAcceptableModuleType", "", "module", "hasJavaSdk", "selectModule", "Lcom/intellij/util/Function;", "Lcom/intellij/util/Consumer;", "intellij.groovy"})
@JvmName(name="ModuleChooserUtil")
public final class ModuleChooserUtil {
    private static final String GROOVY_LAST_MODULE = "Groovy.Last.Module.Chosen";

    public static final void selectModule(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function<Module, String> version, @NotNull Consumer<Module> consumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter(version, (String)"version");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Module module = (Module)CollectionsKt.singleOrNull(modules);
        if (module != null) {
            Module module2;
            Module it = module2 = module;
            boolean bl = false;
            consumer.consume((Object)it);
            return;
        }
        ModuleChooserUtil.createSelectModulePopup(project, modules, (Function1<? super Module, String>)((Function1)new Function1<Module, String>(version){

            public final String invoke(Module p1) {
                return (String)((Function)this.receiver).fun((Object)p1);
            }
        }), (Function1<? super Module, Unit>)((Function1)new Function1<Module, Unit>(consumer){

            public final void invoke(Module p1) {
                ((Consumer)this.receiver).consume((Object)p1);
            }
        })).showCenteredInCurrentWindow(project);
    }

    @NotNull
    public static final ListPopup createSelectModulePopup(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function1<? super Module, String> version, @NotNull Function1<? super Module, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter(version, (String)"version");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterable iterable = modules;
        ModulesAlphaComparator modulesAlphaComparator = ModulesAlphaComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)modulesAlphaComparator, (String)"ModulesAlphaComparator.INSTANCE");
        ListPopupStep<Module> step2 = ModuleChooserUtil.createSelectModulePopupStep(project, CollectionsKt.sortedWith((Iterable)iterable, (Comparator)((Comparator)modulesAlphaComparator)), consumer);
        return (ListPopup)new ListPopupImpl(version, project, step2, project, step2){
            final /* synthetic */ Function1 $version;
            final /* synthetic */ Project $project;
            final /* synthetic */ ListPopupStep $step;

            @NotNull
            protected RightTextCellRenderer getListElementRenderer() {
                ListCellRenderer listCellRenderer = super.getListElementRenderer();
                Intrinsics.checkNotNullExpressionValue((Object)listCellRenderer, (String)"super.getListElementRenderer()");
                return new RightTextCellRenderer<T>(listCellRenderer, this.$version);
            }
            {
                this.$version = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$step = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final ListPopupStep<Module> createSelectModulePopupStep(Project project, List<? extends Module> modules, Function1<? super Module, Unit> consumer) {
        GroovySelectModuleStep step2;
        block3: {
            int n;
            GroovySelectModuleStep groovySelectModuleStep;
            block2: {
                void $this$indexOfFirst$iv;
                String string;
                PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
                step2 = new GroovySelectModuleStep(modules, (Function1<? super Module, Unit>)((Function1)new Function1<Module, Unit>(propertiesComponent, consumer){
                    final /* synthetic */ PropertiesComponent $propertiesComponent;
                    final /* synthetic */ Function1 $consumer;

                    public final void invoke(@NotNull Module it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$propertiesComponent.setValue("Groovy.Last.Module.Chosen", it.getName());
                        this.$consumer.invoke((Object)it);
                    }
                    {
                        this.$propertiesComponent = propertiesComponent;
                        this.$consumer = function1;
                        super(1);
                    }
                }));
                String string2 = propertiesComponent.getValue(GROOVY_LAST_MODULE);
                if (string2 == null) break block3;
                String lastModuleName = string = string2;
                boolean bl = false;
                List<? extends Module> list = modules;
                groovySelectModuleStep = step2;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    Module it = (Module)item$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)lastModuleName)) {
                        n = index$iv;
                        break block2;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int n2 = n;
            groovySelectModuleStep.setDefaultOptionIndex(n2);
        }
        return (ListPopupStep)step2;
    }

    public static final boolean hasJavaSdk(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        Sdk sdk = moduleRootManager.getSdk();
        return (sdk != null ? sdk.getSdkType() : null) instanceof JavaSdkType;
    }

    public static final boolean hasAcceptableModuleType(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return GroovyFacetUtil.isAcceptableModuleType(ModuleType.get((Module)module));
    }
}

