/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.generic.TemplateVariable;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageTemplateVariablesDialog
extends DialogWrapper {
    private final TemplateVariablesTable myTemplateVariableTable;

    protected ManageTemplateVariablesDialog(@NotNull Component parent) {
        if (parent == null) {
            ManageTemplateVariablesDialog.$$$reportNull$$$0(0);
        }
        super(parent, true);
        this.myTemplateVariableTable = new TemplateVariablesTable();
        this.setTitle(TaskBundle.message((String)"dialog.title.template.variables", (Object[])new Object[0]));
        this.init();
    }

    public void setTemplateVariables(List<TemplateVariable> list) {
        this.myTemplateVariableTable.setValues(list);
    }

    public List<TemplateVariable> getTemplateVariables() {
        return this.myTemplateVariableTable.getTemplateVariables();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myTemplateVariableTable.getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/tasks/generic/ManageTemplateVariablesDialog", "<init>"));
    }

    private static class TemplateVariablesTable
    extends ListTableWithButtons<TemplateVariable> {
        TemplateVariablesTable() {
            this.getTableView().getEmptyText().setText(TaskBundle.message((String)"status.text.no.variables", (Object[])new Object[0]));
        }

        protected ListTableModel createListModel() {
            ListTableWithButtons.ElementsColumnInfoBase<TemplateVariable> name = new ListTableWithButtons.ElementsColumnInfoBase<TemplateVariable>(TaskBundle.message((String)"column.name.name", (Object[])new Object[0])){

                @NotNull
                protected String getDescription(TemplateVariable templateVariable) {
                    String string = templateVariable.getDescription();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @NotNull
                public String valueOf(TemplateVariable templateVariable) {
                    String string = templateVariable.getName();
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                public boolean isCellEditable(TemplateVariable templateVariable) {
                    return !templateVariable.isReadOnly();
                }

                public void setValue(TemplateVariable templateVariable, String s) {
                    if (s.equals(this.valueOf(templateVariable))) {
                        return;
                    }
                    templateVariable.setName(s);
                    this.setModified();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/tasks/generic/ManageTemplateVariablesDialog$TemplateVariablesTable$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getDescription";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "valueOf";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            ListTableWithButtons.ElementsColumnInfoBase<TemplateVariable> value = new ListTableWithButtons.ElementsColumnInfoBase<TemplateVariable>(TaskBundle.message((String)"column.name.value", (Object[])new Object[0])){

                @NotNull
                public String valueOf(TemplateVariable templateVariable) {
                    String string = templateVariable.getValue();
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public boolean isCellEditable(TemplateVariable templateVariable) {
                    return !templateVariable.isReadOnly();
                }

                public void setValue(TemplateVariable templateVariable, String s) {
                    templateVariable.setValue(s);
                    this.setModified();
                }

                public TableCellRenderer getRenderer(TemplateVariable variable) {
                    if (variable.isHidden()) {
                        return new TableCellRenderer(){

                            @Override
                            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                return new JPasswordField(value.toString());
                            }
                        };
                    }
                    return super.getRenderer((Object)variable);
                }

                @Nullable
                public TableCellEditor getEditor(final TemplateVariable variable) {
                    if (variable.isHidden()) {
                        return new AbstractTableCellEditor(){
                            private JPasswordField myPasswordField;

                            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                                this.myPasswordField = new JPasswordField(variable.getValue());
                                return this.myPasswordField;
                            }

                            public Object getCellEditorValue() {
                                return this.myPasswordField.getText();
                            }
                        };
                    }
                    return super.getEditor((Object)variable);
                }

                @NotNull
                protected String getDescription(TemplateVariable templateVariable) {
                    String string = templateVariable.getDescription();
                    if (string == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/tasks/generic/ManageTemplateVariablesDialog$TemplateVariablesTable$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "valueOf";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getDescription";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            ColumnInfo<TemplateVariable, Boolean> isShownOnFirstTab = new ColumnInfo<TemplateVariable, Boolean>(TaskBundle.message((String)"column.name.show.on.first.tab", (Object[])new Object[0])){

                @NotNull
                public Boolean valueOf(TemplateVariable o) {
                    Boolean bl = o.isShownOnFirstTab();
                    if (bl == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return bl;
                }

                public void setValue(TemplateVariable variable, Boolean value) {
                    variable.setShownOnFirstTab(value);
                    this.setModified();
                }

                public Class getColumnClass() {
                    return Boolean.class;
                }

                public boolean isCellEditable(TemplateVariable variable) {
                    return !variable.isReadOnly();
                }

                @NotNull
                public String getTooltipText() {
                    String string = TaskBundle.message((String)"tooltip.whether.this.template.variable.will.be.shown.in.general.tab", (Object[])new Object[0]);
                    if (string == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/tasks/generic/ManageTemplateVariablesDialog$TemplateVariablesTable$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "valueOf";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getTooltipText";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            ColumnInfo<TemplateVariable, Boolean> isHidden = new ColumnInfo<TemplateVariable, Boolean>(TaskBundle.message((String)"column.name.hide", (Object[])new Object[0])){

                @NotNull
                public Boolean valueOf(TemplateVariable o) {
                    Boolean bl = o.isHidden();
                    if (bl == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return bl;
                }

                public void setValue(TemplateVariable variable, Boolean value) {
                    variable.setHidden(value);
                    this.setModified();
                    this.refreshValues();
                }

                public Class getColumnClass() {
                    return Boolean.class;
                }

                public boolean isCellEditable(TemplateVariable variable) {
                    return !variable.isReadOnly();
                }

                @NotNull
                public String getTooltipText() {
                    String string = TaskBundle.message((String)"tooltip.whether.this.template.variable.will.be.hidden.like.password.field", (Object[])new Object[0]);
                    if (string == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/tasks/generic/ManageTemplateVariablesDialog$TemplateVariablesTable$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "valueOf";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getTooltipText";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            return new ListTableModel(new ColumnInfo[]{name, value, isShownOnFirstTab, isHidden});
        }

        protected TemplateVariable createElement() {
            return new TemplateVariable("", "");
        }

        protected boolean isEmpty(TemplateVariable element) {
            return StringUtil.isEmpty((String)element.getName()) && StringUtil.isEmpty((String)element.getValue());
        }

        protected TemplateVariable cloneElement(TemplateVariable variable) {
            return variable.clone();
        }

        protected boolean canDeleteElement(TemplateVariable selection) {
            return true;
        }

        public List<TemplateVariable> getTemplateVariables() {
            return this.getElements();
        }
    }
}

