/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl.httpclient;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.util.Producer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntPredicate;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class TaskResponseUtil {
    public static final Logger LOG = Logger.getInstance(TaskResponseUtil.class);
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    private TaskResponseUtil() {
    }

    public static Reader getResponseContentAsReader(@NotNull HttpResponse response) throws IOException {
        org.apache.http.Header header;
        if (response == null) {
            TaskResponseUtil.$$$reportNull$$$0(0);
        }
        Charset charset = (header = response.getEntity().getContentEncoding()) == null ? DEFAULT_CHARSET : Charset.forName(header.getValue());
        return new InputStreamReader(response.getEntity().getContent(), charset);
    }

    public static String getResponseContentAsString(@NotNull HttpResponse response) throws IOException {
        if (response == null) {
            TaskResponseUtil.$$$reportNull$$$0(1);
        }
        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)DEFAULT_CHARSET);
    }

    public static String getResponseContentAsString(@NotNull HttpMethod response) throws IOException {
        Header header;
        if (response == null) {
            TaskResponseUtil.$$$reportNull$$$0(2);
        }
        if ((header = response.getResponseHeader("Content-Type")) != null && header.getValue().contains("charset")) {
            return StringUtil.notNullize((String)response.getResponseBodyAsString());
        }
        InputStream stream = response.getResponseBodyAsStream();
        if (stream == null) {
            return "";
        }
        try (InputStreamReader reader = new InputStreamReader(stream, DEFAULT_CHARSET);){
            String string = StreamUtil.readText((Reader)reader);
            return string;
        }
    }

    public static Reader getResponseContentAsReader(@NotNull HttpMethod response) throws IOException {
        if (response == null) {
            TaskResponseUtil.$$$reportNull$$$0(3);
        }
        InputStream stream = response.getResponseBodyAsStream();
        String charsetName = null;
        Header header = response.getResponseHeader("Content-Type");
        if (header != null) {
            for (HeaderElement part : header.getElements()) {
                NameValuePair pair = part.getParameterByName("charset");
                if (pair == null) continue;
                charsetName = pair.getValue();
            }
        }
        return charsetName != null ? new InputStreamReader(stream, charsetName) : new InputStreamReader(stream, DEFAULT_CHARSET);
    }

    @NotNull
    public static String messageForStatusCode(int statusCode) {
        if (statusCode == 401) {
            String string = TaskBundle.message((String)"failure.login", (Object[])new Object[0]);
            if (string == null) {
                TaskResponseUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (statusCode == 403) {
            String string = TaskBundle.message((String)"failure.permissions", (Object[])new Object[0]);
            if (string == null) {
                TaskResponseUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = TaskBundle.message((String)"failure.http.error", (Object[])new Object[]{statusCode, HttpStatus.getStatusText((int)statusCode)});
        if (string == null) {
            TaskResponseUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static void prettyFormatResponseToLog(@NotNull Logger logger, @NotNull HttpMethod response) {
        if (logger == null) {
            TaskResponseUtil.$$$reportNull$$$0(7);
        }
        if (response == null) {
            TaskResponseUtil.$$$reportNull$$$0(8);
        }
        if (logger.isDebugEnabled() && response.hasBeenUsed()) {
            try {
                String contentType;
                String content = TaskResponseUtil.getResponseContentAsString(response);
                Header header = response.getRequestHeader("Content-Type");
                String string = contentType = header == null ? "text/plain" : StringUtil.toLowerCase((String)header.getElements()[0].getName());
                if (contentType.contains("xml")) {
                    TaskUtil.prettyFormatXmlToLog((Logger)logger, (String)content);
                } else if (contentType.contains("json")) {
                    TaskUtil.prettyFormatJsonToLog((Logger)logger, (String)content);
                } else {
                    logger.debug(content);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static void prettyFormatResponseToLog(@NotNull Logger logger, @NotNull HttpResponse response) {
        if (logger == null) {
            TaskResponseUtil.$$$reportNull$$$0(9);
        }
        if (response == null) {
            TaskResponseUtil.$$$reportNull$$$0(10);
        }
        if (logger.isDebugEnabled()) {
            try {
                String contentType;
                String content = TaskResponseUtil.getResponseContentAsString(response);
                org.apache.http.Header header = response.getEntity().getContentType();
                String string = contentType = header == null ? "text/plain" : StringUtil.toLowerCase((String)header.getElements()[0].getName());
                if (contentType.contains("xml")) {
                    TaskUtil.prettyFormatXmlToLog((Logger)logger, (String)content);
                } else if (contentType.contains("json")) {
                    TaskUtil.prettyFormatJsonToLog((Logger)logger, (String)content);
                } else {
                    logger.debug(content);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static boolean isSuccessful(int statusCode) {
        return statusCode / 100 == 2;
    }

    public static boolean isClientError(int statusCode) {
        return statusCode / 100 == 4;
    }

    public static boolean isServerError(int statusCode) {
        return statusCode / 100 == 5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/impl/httpclient/TaskResponseUtil";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/impl/httpclient/TaskResponseUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "messageForStatusCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResponseContentAsReader";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResponseContentAsString";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prettyFormatResponseToLog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class GsonMultipleObjectsDeserializer<T>
    extends GsonResponseHandler<List<T>> {
        public GsonMultipleObjectsDeserializer(Gson gson, TypeToken<List<T>> typeToken) {
            this(gson, typeToken, false);
        }

        public GsonMultipleObjectsDeserializer(@NotNull Gson gson, @NotNull TypeToken<List<T>> token, boolean ignoreNotFound) {
            if (gson == null) {
                GsonMultipleObjectsDeserializer.$$$reportNull$$$0(0);
            }
            if (token == null) {
                GsonMultipleObjectsDeserializer.$$$reportNull$$$0(1);
            }
            super(JsonResponseHandlerBuilder.fromGson(gson).ignoredCode(code -> ignoreNotFound && code == 404), s -> (List)gson.fromJson(s, token.getType()), r -> (List)gson.fromJson(r, token.getType()), () -> Collections.emptyList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gson";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "token";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tasks/impl/httpclient/TaskResponseUtil$GsonMultipleObjectsDeserializer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class GsonSingleObjectDeserializer<T>
    extends GsonResponseHandler<T> {
        public GsonSingleObjectDeserializer(@NotNull Gson gson, @NotNull Class<T> cls) {
            if (gson == null) {
                GsonSingleObjectDeserializer.$$$reportNull$$$0(0);
            }
            if (cls == null) {
                GsonSingleObjectDeserializer.$$$reportNull$$$0(1);
            }
            this(gson, cls, false);
        }

        public GsonSingleObjectDeserializer(@NotNull Gson gson, @NotNull Class<T> cls, boolean ignoreNotFound) {
            if (gson == null) {
                GsonSingleObjectDeserializer.$$$reportNull$$$0(2);
            }
            if (cls == null) {
                GsonSingleObjectDeserializer.$$$reportNull$$$0(3);
            }
            super(JsonResponseHandlerBuilder.fromGson(gson).ignoredCode(code -> ignoreNotFound && code == 404), s -> gson.fromJson(s, cls), r -> gson.fromJson(r, cls), () -> null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gson";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cls";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tasks/impl/httpclient/TaskResponseUtil$GsonSingleObjectDeserializer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GsonResponseHandler<T>
    implements ResponseHandler<T> {
        private final JsonResponseHandlerBuilder myBuilder;
        private final Function<String, T> myFromString;
        private final Function<Reader, T> myFromReader;
        private final Producer<T> myFallbackValue;

        private GsonResponseHandler(@NotNull JsonResponseHandlerBuilder builder, @NotNull Function<String, T> fromString, @NotNull Function<Reader, T> fromReader, @NotNull Producer<T> fallbackValue) {
            if (builder == null) {
                GsonResponseHandler.$$$reportNull$$$0(0);
            }
            if (fromString == null) {
                GsonResponseHandler.$$$reportNull$$$0(1);
            }
            if (fromReader == null) {
                GsonResponseHandler.$$$reportNull$$$0(2);
            }
            if (fallbackValue == null) {
                GsonResponseHandler.$$$reportNull$$$0(3);
            }
            this.myBuilder = builder;
            this.myFromString = fromString;
            this.myFromReader = fromReader;
            this.myFallbackValue = fallbackValue;
        }

        public T handleResponse(HttpResponse response) throws IOException {
            int statusCode = response.getStatusLine().getStatusCode();
            if (!this.myBuilder.mySuccessChecker.test(statusCode)) {
                RequestFailedException exception;
                if (this.myBuilder.myIgnoreChecker.test(statusCode)) {
                    return (T)this.myFallbackValue.produce();
                }
                if (this.myBuilder.myErrorExtractor != null && (exception = this.myBuilder.myErrorExtractor.apply(response)) != null) {
                    throw exception;
                }
                throw RequestFailedException.forStatusCode((int)statusCode, (String)TaskResponseUtil.messageForStatusCode(statusCode));
            }
            try {
                if (LOG.isDebugEnabled()) {
                    String content = TaskResponseUtil.getResponseContentAsString(response);
                    TaskUtil.prettyFormatJsonToLog((Logger)LOG, (String)content);
                    return this.myFromString.apply(content);
                }
                return this.myFromReader.apply(TaskResponseUtil.getResponseContentAsReader(response));
            }
            catch (JsonSyntaxException e) {
                LOG.warn("Malformed server response", (Throwable)e);
                return (T)this.myFallbackValue.produce();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fromString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fromReader";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fallbackValue";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tasks/impl/httpclient/TaskResponseUtil$GsonResponseHandler";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static class JsonResponseHandlerBuilder {
        private final Gson myGson;
        private IntPredicate mySuccessChecker;
        private IntPredicate myIgnoreChecker;
        private Function<HttpResponse, ? extends RequestFailedException> myErrorExtractor;

        private JsonResponseHandlerBuilder(@NotNull Gson gson) {
            if (gson == null) {
                JsonResponseHandlerBuilder.$$$reportNull$$$0(0);
            }
            this.mySuccessChecker = code -> code / 100 == 2;
            this.myIgnoreChecker = code -> false;
            this.myGson = gson;
        }

        @NotNull
        public static JsonResponseHandlerBuilder fromGson(@NotNull Gson gson) {
            if (gson == null) {
                JsonResponseHandlerBuilder.$$$reportNull$$$0(1);
            }
            return new JsonResponseHandlerBuilder(gson);
        }

        @NotNull
        public JsonResponseHandlerBuilder successCode(@NotNull IntPredicate predicate) {
            if (predicate == null) {
                JsonResponseHandlerBuilder.$$$reportNull$$$0(2);
            }
            this.mySuccessChecker = predicate;
            JsonResponseHandlerBuilder jsonResponseHandlerBuilder = this;
            if (jsonResponseHandlerBuilder == null) {
                JsonResponseHandlerBuilder.$$$reportNull$$$0(3);
            }
            return jsonResponseHandlerBuilder;
        }

        @NotNull
        public JsonResponseHandlerBuilder ignoredCode(@NotNull IntPredicate predicate) {
            if (predicate == null) {
                JsonResponseHandlerBuilder.$$$reportNull$$$0(4);
            }
            this.myIgnoreChecker = predicate;
            JsonResponseHandlerBuilder jsonResponseHandlerBuilder = this;
            if (jsonResponseHandlerBuilder == null) {
                JsonResponseHandlerBuilder.$$$reportNull$$$0(5);
            }
            return jsonResponseHandlerBuilder;
        }

        @NotNull
        public JsonResponseHandlerBuilder errorHandler(@NotNull Function<HttpResponse, ? extends RequestFailedException> handler) {
            if (handler == null) {
                JsonResponseHandlerBuilder.$$$reportNull$$$0(6);
            }
            this.myErrorExtractor = handler;
            JsonResponseHandlerBuilder jsonResponseHandlerBuilder = this;
            if (jsonResponseHandlerBuilder == null) {
                JsonResponseHandlerBuilder.$$$reportNull$$$0(7);
            }
            return jsonResponseHandlerBuilder;
        }

        @NotNull
        public <T> ResponseHandler<T> toSingleObject(@NotNull Class<T> cls) {
            if (cls == null) {
                JsonResponseHandlerBuilder.$$$reportNull$$$0(8);
            }
            return new GsonResponseHandler<Object>(this, s -> this.myGson.fromJson(s, cls), r -> this.myGson.fromJson(r, cls), () -> null);
        }

        @NotNull
        public <T> ResponseHandler<List<T>> toMultipleObjects(@NotNull TypeToken<List<T>> typeToken) {
            if (typeToken == null) {
                JsonResponseHandlerBuilder.$$$reportNull$$$0(9);
            }
            return new GsonResponseHandler<List<T>>(this, s -> (List)this.myGson.fromJson(s, typeToken.getType()), r -> (List)this.myGson.fromJson(r, typeToken.getType()), () -> Collections.emptyList());
        }

        @NotNull
        public ResponseHandler<Void> toNothing() {
            return new GsonResponseHandler<Void>(this, s -> null, r -> null, () -> null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gson";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/impl/httpclient/TaskResponseUtil$JsonResponseHandlerBuilder";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cls";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeToken";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/impl/httpclient/TaskResponseUtil$JsonResponseHandlerBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "successCode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ignoredCode";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "errorHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fromGson";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "successCode";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "ignoredCode";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "errorHandler";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "toSingleObject";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "toMultipleObjects";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

