/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.IntellijInternalApi;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.project.DefaultLibraryDependencyCandidate;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.KlibLibraryDependencyCandidate;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.klib.AbstractKlibLibraryInfo;
import org.jetbrains.kotlin.platform.TargetPlatform;

@IntellijInternalApi
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/LibraryDependencyCandidate;", "", "()V", "libraries", "", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryInfo;", "getLibraries", "()Ljava/util/List;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "Companion", "Lorg/jetbrains/kotlin/idea/caches/project/DefaultLibraryDependencyCandidate;", "Lorg/jetbrains/kotlin/idea/caches/project/KlibLibraryDependencyCandidate;", "kotlin.core"})
public abstract class LibraryDependencyCandidate {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract TargetPlatform getPlatform();

    @NotNull
    public abstract List<LibraryInfo> getLibraries();

    private LibraryDependencyCandidate() {
    }

    public /* synthetic */ LibraryDependencyCandidate(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/LibraryDependencyCandidate$Companion;", "", "()V", "fromLibraryOrNull", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryDependencyCandidate;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "kotlin.core"})
    public static final class Companion {
        @Nullable
        public final LibraryDependencyCandidate fromLibraryOrNull(@NotNull Project project2, @NotNull Library library2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
            List<LibraryInfo> libraryInfos = IdeaModuleInfosKt.createLibraryInfo(project2, library2);
            LibraryInfo libraryInfo = (LibraryInfo)CollectionsKt.firstOrNull(libraryInfos);
            if (libraryInfo == null) {
                return null;
            }
            LibraryInfo libraryInfo2 = libraryInfo;
            if (libraryInfo2 instanceof AbstractKlibLibraryInfo) {
                return new KlibLibraryDependencyCandidate(libraryInfo2.getPlatform(), libraryInfos, ((AbstractKlibLibraryInfo)libraryInfo2).getUniqueName(), ((AbstractKlibLibraryInfo)libraryInfo2).isInterop());
            }
            return new DefaultLibraryDependencyCandidate(libraryInfo2.getPlatform(), libraryInfos);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

