/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesModificationTracker;
import org.jetbrains.kotlin.idea.core.script.configuration.DefaultScriptingSupport;
import org.jetbrains.kotlin.idea.core.script.configuration.ScriptingSupport;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.ScriptChangesNotifier;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.UtilsKt;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsBuilder;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsCache;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsUpdater;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0016J\b\u0010%\u001a\u00020#H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001e\u001a\u00020(H\u0016J\n\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0010\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u001e\u001a\u00020-J\u001e\u0010.\u001a\u0004\u0018\u00010'2\u0006\u0010/\u001a\u00020\u001f2\n\b\u0002\u00100\u001a\u0004\u0018\u00010(H\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00142\u0006\u0010\u001e\u001a\u00020(H\u0016J\u0010\u00102\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u00103\u001a\u0004\u0018\u00010*2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u00104\u001a\u0002052\u0006\u0010\u001e\u001a\u00020(H\u0016J\u0010\u00106\u001a\u0002052\u0006\u0010\u001e\u001a\u00020(H\u0016J\b\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020-J\b\u0010<\u001a\u000208H\u0016J\u000e\u0010=\u001a\u0002082\u0006\u0010\u001e\u001a\u00020\u001fR\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\u000f\u001a.\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0015\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0014\u00a2\u0006\u0002\b\u00130\u0010\u00a2\u0006\u0002\b\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "Lorg/jetbrains/kotlin/idea/core/script/ScriptConfigurationManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "classpathRoots", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "getClasspathRoots", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "default", "Lorg/jetbrains/kotlin/idea/core/script/configuration/DefaultScriptingSupport;", "getDefault", "()Lorg/jetbrains/kotlin/idea/core/script/configuration/DefaultScriptingSupport;", "notifier", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptChangesNotifier;", "plugins", "", "Lorg/jetbrains/kotlin/idea/core/script/configuration/ScriptingSupport;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "getPlugins", "()Ljava/util/List;", "getProject", "()Lcom/intellij/openapi/project/Project;", "updater", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsUpdater;", "getUpdater", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsUpdater;", "getActualClasspathRoots", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAllScriptDependenciesSources", "", "getAllScriptDependenciesSourcesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getAllScriptsDependenciesClassFiles", "getAllScriptsDependenciesClassFilesScope", "getConfiguration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "Lorg/jetbrains/kotlin/psi/KtFile;", "getFirstScriptsSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getLightScriptInfo", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$LightScriptInfo;", "", "getOrLoadConfiguration", "virtualFile", "preloadedKtFile", "getScriptClasspath", "getScriptDependenciesClassFilesScope", "getScriptSdk", "hasConfiguration", "", "isConfigurationLoadingInProgress", "loadPlugins", "", "tryGetScriptDefinitionFast", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "locationId", "updateScriptDefinitionReferences", "updateScriptDependenciesIfNeeded", "kotlin.core"})
public final class CompositeScriptConfigurationManager
implements ScriptConfigurationManager {
    private final ScriptChangesNotifier notifier;
    @NotNull
    private final DefaultScriptingSupport default;
    @NotNull
    private final ScriptClassRootsUpdater updater;
    @NotNull
    private final Project project;

    private final ScriptClassRootsCache getClasspathRoots() {
        return this.updater.getClasspathRoots();
    }

    private final List<ScriptingSupport> getPlugins() {
        ExtensionPoint extensionPoint = ScriptingSupport.Companion.getEPN().getPoint((AreaInstance)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)extensionPoint, (String)"ScriptingSupport.EPN.getPoint(project)");
        List list2 = extensionPoint.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ScriptingSupport.EPN.get\u2026nt(project).extensionList");
        return list2;
    }

    @NotNull
    public final DefaultScriptingSupport getDefault() {
        return this.default;
    }

    @NotNull
    public final ScriptClassRootsUpdater getUpdater() {
        return this.updater;
    }

    @Override
    public void loadPlugins() {
        this.getPlugins();
    }

    public final void updateScriptDependenciesIfNeeded(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.notifier.updateScriptDependenciesIfNeeded$kotlin_core(file2);
    }

    @Nullable
    public final ScriptDefinition tryGetScriptDefinitionFast(@NotNull String locationId) {
        Intrinsics.checkNotNullParameter((Object)locationId, (String)"locationId");
        ScriptClassRootsCache.LightScriptInfo lightScriptInfo = this.getClasspathRoots().getLightScriptInfo(locationId);
        return lightScriptInfo != null ? lightScriptInfo.getDefinition() : null;
    }

    private final ScriptCompilationConfigurationWrapper getOrLoadConfiguration(VirtualFile virtualFile2, KtFile preloadedKtFile) {
        ScriptCompilationConfigurationWrapper scriptConfiguration = this.getClasspathRoots().getScriptConfiguration(virtualFile2);
        if (scriptConfiguration != null) {
            return scriptConfiguration;
        }
        if (!OutsidersPsiFileSupport.isOutsiderFile((VirtualFile)virtualFile2)) {
            Object v0;
            block6: {
                Iterable $this$firstOrNull$iv = this.getPlugins();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ScriptingSupport it = (ScriptingSupport)element$iv;
                    boolean bl = false;
                    if (!it.isApplicable(virtualFile2)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            ScriptingSupport plugin = v0;
            if (plugin != null) {
                ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper;
                ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper2 = plugin.getConfigurationImmediately(virtualFile2);
                if (scriptCompilationConfigurationWrapper2 != null) {
                    ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper3;
                    ScriptCompilationConfigurationWrapper it = scriptCompilationConfigurationWrapper3 = scriptCompilationConfigurationWrapper2;
                    boolean bl = false;
                    this.updater.addConfiguration(virtualFile2, it);
                    scriptCompilationConfigurationWrapper = scriptCompilationConfigurationWrapper3;
                } else {
                    scriptCompilationConfigurationWrapper = null;
                }
                return scriptCompilationConfigurationWrapper;
            }
        }
        return this.default.getOrLoadConfiguration(virtualFile2, preloadedKtFile);
    }

    static /* synthetic */ ScriptCompilationConfigurationWrapper getOrLoadConfiguration$default(CompositeScriptConfigurationManager compositeScriptConfigurationManager, VirtualFile virtualFile2, KtFile ktFile, int n, Object object) {
        if ((n & 2) != 0) {
            ktFile = null;
        }
        return compositeScriptConfigurationManager.getOrLoadConfiguration(virtualFile2, ktFile);
    }

    @Override
    @Nullable
    public ScriptCompilationConfigurationWrapper getConfiguration(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PsiFile psiFile2 = file2.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file.originalFile");
        VirtualFile virtualFile2 = psiFile2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.originalFile.virtualFile");
        return this.getOrLoadConfiguration(virtualFile2, file2);
    }

    @Override
    public boolean hasConfiguration(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ScriptClassRootsCache scriptClassRootsCache = this.getClasspathRoots();
        PsiFile psiFile2 = file2.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file.originalFile");
        VirtualFile virtualFile2 = psiFile2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.originalFile.virtualFile");
        return scriptClassRootsCache.contains(virtualFile2);
    }

    @Override
    public boolean isConfigurationLoadingInProgress(@NotNull KtFile file2) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Iterable $this$firstOrNull$iv = this.getPlugins();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ScriptingSupport it = (ScriptingSupport)element$iv;
                boolean bl = false;
                PsiFile psiFile2 = file2.getOriginalFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file.originalFile");
                VirtualFile virtualFile2 = psiFile2.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.originalFile.virtualFile");
                if (!it.isApplicable(virtualFile2)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        ScriptingSupport scriptingSupport = v2;
        return scriptingSupport != null ? scriptingSupport.isConfigurationLoadingInProgress(file2) : this.default.isConfigurationLoadingInProgress(file2);
    }

    @Nullable
    public final ScriptClassRootsCache.LightScriptInfo getLightScriptInfo(@NotNull String file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getClasspathRoots().getLightScriptInfo(file2);
    }

    @Override
    public void updateScriptDefinitionReferences() {
        ScriptDependenciesModificationTracker.Companion.getInstance(this.project).incModificationCount();
        this.default.updateScriptDefinitionsReferences();
        if (this.getClasspathRoots().getCustomDefinitionsUsed()) {
            this.updater.invalidateAndCommit();
        }
    }

    private final ScriptClassRootsCache getActualClasspathRoots(VirtualFile file2) {
        try {
            this.getOrLoadConfiguration(file2, null);
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return this.getClasspathRoots();
    }

    @Override
    @Nullable
    public Sdk getScriptSdk(@NotNull VirtualFile file2) {
        Sdk sdk2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (ScratchUtil.isScratch((VirtualFile)file2)) {
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
            sdk2 = projectRootManager.getProjectSdk();
        } else {
            sdk2 = this.getActualClasspathRoots(file2).getScriptSdk(file2);
        }
        return sdk2;
    }

    @Override
    @Nullable
    public Sdk getFirstScriptsSdk() {
        return this.getClasspathRoots().getFirstScriptSdk();
    }

    @Override
    @NotNull
    public GlobalSearchScope getScriptDependenciesClassFilesScope(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getClasspathRoots().getScriptDependenciesClassFilesScope(file2);
    }

    @Override
    @NotNull
    public GlobalSearchScope getAllScriptsDependenciesClassFilesScope() {
        return this.getClasspathRoots().getAllDependenciesClassFilesScope();
    }

    @Override
    @NotNull
    public GlobalSearchScope getAllScriptDependenciesSourcesScope() {
        return this.getClasspathRoots().getAllDependenciesSourcesScope();
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getAllScriptsDependenciesClassFiles() {
        return this.getClasspathRoots().getAllDependenciesClassFiles();
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getAllScriptDependenciesSources() {
        return this.getClasspathRoots().getAllDependenciesSources();
    }

    @Override
    @Deprecated(message="Use getScriptClasspath(KtFile) instead")
    @NotNull
    public List<VirtualFile> getScriptClasspath(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtFile ktFile = UtilsKt.getKtFile$default(this.project, file2, null, 2, null);
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile ktFile2 = ktFile;
        return this.getScriptClasspath(ktFile2);
    }

    @Override
    @NotNull
    public List<VirtualFile> getScriptClasspath(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = this.getConfiguration(file2);
        List list2 = scriptCompilationConfigurationWrapper != null ? scriptCompilationConfigurationWrapper.getDependenciesClassPath() : null;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return ScriptConfigurationManager.Companion.toVfsRoots(list3);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public CompositeScriptConfigurationManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.notifier = new ScriptChangesNotifier(this.project);
        this.default = new DefaultScriptingSupport(this);
        this.updater = new ScriptClassRootsUpdater(this, this.project, this){
            final /* synthetic */ CompositeScriptConfigurationManager this$0;

            public void gatherRoots(@NotNull ScriptClassRootsBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                this.this$0.getDefault().collectConfigurations(builder);
                Iterable $this$forEach$iv = CompositeScriptConfigurationManager.access$getPlugins$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ScriptingSupport it = (ScriptingSupport)element$iv;
                    boolean bl = false;
                    it.collectConfigurations(builder);
                }
            }

            public void afterUpdate() {
                Iterable $this$forEach$iv = CompositeScriptConfigurationManager.access$getPlugins$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ScriptingSupport it = (ScriptingSupport)element$iv;
                    boolean bl = false;
                    it.afterUpdate();
                }
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2);
            }
        };
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)KotlinPluginDisposable.Companion.getInstance(this.project));
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.conne\u2026ble.getInstance(project))");
        MessageBusConnection connection = messageBusConnection;
        Topic topic = ProjectTopics.PROJECT_ROOTS;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"ProjectTopics.PROJECT_ROOTS");
        connection.subscribe(topic, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.isCausedByFileTypesChange()) {
                    return;
                }
                ScriptClassRootsUpdater.checkInvalidSdks$kotlin_core$default(this.getUpdater(), null, 1, null);
            }
        });
        Topic topic2 = ProjectJdkTable.JDK_TABLE_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"JDK_TABLE_TOPIC");
        connection.subscribe(topic2, (Object)new ProjectJdkTable.Listener(){

            public void jdkAdded(@NotNull Sdk jdk) {
                Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
                ScriptClassRootsUpdater.checkInvalidSdks$kotlin_core$default(this.getUpdater(), null, 1, null);
            }

            public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
                Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
                Intrinsics.checkNotNullParameter((Object)previousName, (String)"previousName");
                ScriptClassRootsUpdater.checkInvalidSdks$kotlin_core$default(this.getUpdater(), null, 1, null);
            }

            public void jdkRemoved(@NotNull Sdk jdk) {
                Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
                this.getUpdater().checkInvalidSdks$kotlin_core(jdk);
            }
        });
    }

    public static final /* synthetic */ List access$getPlugins$p(CompositeScriptConfigurationManager $this) {
        return $this.getPlugins();
    }
}

