/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror;

import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.BaseExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.DefaultExecutionContext;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0010\u0011B\u0011\b\u0004\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J3\u0010\b\u001a\u0004\u0018\u00018\u00002\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u000fR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator;", "T", "", "method", "Lcom/sun/jdi/Method;", "(Lcom/sun/jdi/Method;)V", "getMethod", "()Lcom/sun/jdi/Method;", "value", "Lcom/sun/jdi/ObjectReference;", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;", "values", "", "Lcom/sun/jdi/Value;", "(Lcom/sun/jdi/ObjectReference;Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;[Lcom/sun/jdi/Value;)Ljava/lang/Object;", "DefaultMethodEvaluator", "MirrorMethodEvaluator", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator$DefaultMethodEvaluator;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator$MirrorMethodEvaluator;", "kotlin.jvm-debugger.coroutines"})
public abstract class MethodEvaluator<T> {
    @Nullable
    private final Method method;

    @Nullable
    public final T value(@Nullable ObjectReference value2, @NotNull DefaultExecutionContext context2, Value ... values2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        Method method = this.method;
        if (method != null) {
            Object object;
            Method method2;
            Method it = method2 = method;
            boolean bl = false;
            if (this.method.isStatic()) {
                List args = value2 != null ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)value2), (Iterable)ArraysKt.toList((Object[])values2)) : ArraysKt.toList((Object[])values2);
                ReferenceType referenceType = this.method.declaringType();
                if (referenceType == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.ClassType");
                }
                object = context2.invokeMethod((ClassType)referenceType, this.method, (List<? extends Value>)args);
            } else if (value2 != null) {
                object = BaseExecutionContext.invokeMethod$default(context2, value2, this.method, ArraysKt.toList((Object[])values2), 0, 8, null);
            } else {
                throw (Throwable)new IllegalArgumentException("Exception while calling method " + this.method.signature() + " with an empty value.");
            }
            return (T)object;
        }
        return null;
    }

    @Nullable
    public final Method getMethod() {
        return this.method;
    }

    private MethodEvaluator(Method method) {
        this.method = method;
    }

    public /* synthetic */ MethodEvaluator(Method method, DefaultConstructorMarker $constructor_marker) {
        this(method);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator$DefaultMethodEvaluator;", "T", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator;", "method", "Lcom/sun/jdi/Method;", "(Lcom/sun/jdi/Method;)V", "kotlin.jvm-debugger.coroutines"})
    public static final class DefaultMethodEvaluator<T>
    extends MethodEvaluator<T> {
        public DefaultMethodEvaluator(@Nullable Method method) {
            super(method, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\fJ1\u0010\r\u001a\u0004\u0018\u00018\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014\u00a2\u0006\u0002\u0010\u0015R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator$MirrorMethodEvaluator;", "T", "F", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator;", "method", "Lcom/sun/jdi/Method;", "mirrorProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorProvider;", "(Lcom/sun/jdi/Method;Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorProvider;)V", "isCompatible", "", "value", "(Ljava/lang/Object;)Z", "mirror", "ref", "Lcom/sun/jdi/ObjectReference;", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;", "values", "", "Lcom/sun/jdi/Value;", "(Lcom/sun/jdi/ObjectReference;Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;[Lcom/sun/jdi/Value;)Ljava/lang/Object;", "kotlin.jvm-debugger.coroutines"})
    public static final class MirrorMethodEvaluator<T, F>
    extends MethodEvaluator<T> {
        private final MirrorProvider<T, F> mirrorProvider;

        @Nullable
        public final F mirror(@NotNull ObjectReference ref2, @NotNull DefaultExecutionContext context2, Value ... values2) {
            Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            return this.mirrorProvider.mirror(this.value(ref2, context2, Arrays.copyOf(values2, values2.length)), context2);
        }

        public final boolean isCompatible(T value2) {
            return this.mirrorProvider.isCompatible(value2);
        }

        public MirrorMethodEvaluator(@Nullable Method method, @NotNull MirrorProvider<T, F> mirrorProvider) {
            Intrinsics.checkNotNullParameter(mirrorProvider, (String)"mirrorProvider");
            super(method, null);
            this.mirrorProvider = mirrorProvider;
        }
    }
}

