/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.util.InlineAnalysisUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisClassReceiver;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"analyzeCalls", "", "fragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "localFunctions", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "gatherProjectFilesDependedOnByFragment", "", "kotlin.jvm-debugger.evaluation"})
public final class FragmentProjectFileDependencyCollectorKt {
    @NotNull
    public static final Set<KtFile> gatherProjectFilesDependedOnByFragment(@NotNull KtCodeFragment fragment, @NotNull BindingContext bindingContext2) {
        Pair<BindingContext, List<KtFile>> pair;
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        ResolutionFacade resolutionFacade2 = KotlinEvaluatorBuilderKt.getResolutionFacadeForCodeFragment(fragment);
        Set result2 = new LinkedHashSet();
        Pair<BindingContext, List<KtFile>> $dstr$_u24__u24$files = pair = InlineAnalysisUtilsKt.analyzeInlinedFunctions(resolutionFacade2, (KtFile)fragment, false, bindingContext2);
        boolean bl = false;
        List files2 = (List)$dstr$_u24__u24$files.component2();
        for (KtFile file2 : files2) {
            result2.add(file2);
        }
        FragmentProjectFileDependencyCollectorKt.analyzeCalls(fragment, bindingContext2, result2);
        return result2;
    }

    private static final void analyzeCalls(KtCodeFragment fragment, BindingContext bindingContext2, Set<KtFile> localFunctions) {
        Project project2 = fragment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"fragment.project");
        Project project3 = project2;
        fragment.accept((PsiElementVisitor)new KtTreeVisitorVoid(bindingContext2, project3, localFunctions){
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ Project $project;
            final /* synthetic */ Set $localFunctions;

            public void visitExpression(@NotNull KtExpression expression2) {
                CallableDescriptor descriptor2;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitExpression(expression2);
                Call call = (Call)this.$bindingContext.get((ReadOnlySlice)BindingContext.CALL, (Object)expression2);
                if (call == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)call, (String)"bindingContext.get(Bindi\u2026LL, expression) ?: return");
                Call call2 = call;
                ResolvedCall resolvedCall2 = (ResolvedCall)this.$bindingContext.get((ReadOnlySlice)BindingContext.RESOLVED_CALL, (Object)call2);
                if (resolvedCall2 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)resolvedCall2, (String)"bindingContext.get(Bindi\u2026VED_CALL, call) ?: return");
                ResolvedCall resolvedCall3 = resolvedCall2;
                CallableDescriptor callableDescriptor = descriptor2 = resolvedCall3.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"descriptor");
                if (Intrinsics.areEqual((Object)callableDescriptor.getVisibility(), (Object)DescriptorVisibilities.LOCAL)) {
                    PsiElement psiElement2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.$project, (DeclarationDescriptor)descriptor2);
                    if (psiElement2 == null) {
                        return;
                    }
                    PsiElement declaration2 = psiElement2;
                    PsiFile psiFile2 = declaration2.getContainingFile();
                    if (psiFile2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    this.$localFunctions.add((KtFile)psiFile2);
                } else {
                    ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getDispatchReceiverParameter();
                    if (Intrinsics.areEqual((Object)(receiverParameterDescriptor != null ? receiverParameterDescriptor.getVisibility() : null), (Object)DescriptorVisibilities.LOCAL)) {
                        ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor2.getDispatchReceiverParameter();
                        Object object = receiverParameterDescriptor2 != null ? receiverParameterDescriptor2.getValue() : null;
                        if (!(object instanceof ThisClassReceiver)) {
                            object = null;
                        }
                        ThisClassReceiver thisClassReceiver = (ThisClassReceiver)object;
                        if (thisClassReceiver == null) {
                            return;
                        }
                        ThisClassReceiver thisReceiver = thisClassReceiver;
                        PsiElement psiElement3 = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)((DeclarationDescriptor)thisReceiver.getClassDescriptor()));
                        if (psiElement3 == null) {
                            return;
                        }
                        PsiElement declaration3 = psiElement3;
                        PsiFile psiFile3 = declaration3.getContainingFile();
                        if (!(psiFile3 instanceof KtFile)) {
                            psiFile3 = null;
                        }
                        KtFile ktFile = (KtFile)psiFile3;
                        if (ktFile == null) {
                            return;
                        }
                        this.$localFunctions.add(ktFile);
                    }
                }
            }
            {
                this.$bindingContext = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$localFunctions = $captured_local_variable$2;
            }
        });
    }
}

