/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.variables;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.idea.debugger.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.TypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.evaluate.BaseExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelPropertyDescriptorProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverterKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.VariableFinder;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.VariableFinder$WhenMappings;
import org.jetbrains.kotlin.idea.debugger.stackFrame.InlineStackFrameProxyImpl;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 S2\u00020\u0001:\u0005STUVWB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001eH\u0002J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\"\u001a\u0004\u0018\u00010\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\n\u0010%\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020'H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010'2\u0006\u0010*\u001a\u00020+H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010'2\u0006\u0010*\u001a\u00020+H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\u00152\u0006\u0010.\u001a\u00020/H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u000201H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u000203H\u0002J\u0012\u00104\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u000205H\u0002J\u0012\u00106\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u000207H\u0002J4\u00108\u001a\u0004\u0018\u00010\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020;0:H\u0002J<\u00108\u001a\u0004\u0018\u00010\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020=2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020;0:H\u0002J(\u00108\u001a\u0004\u0018\u00010\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/H\u0002J\u0012\u0010>\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020?H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020AH\u0002J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CH\u0002J\u001c\u0010E\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010F\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010G\u001a\u00020;2\u0006\u0010.\u001a\u00020/H\u0002J\b\u0010H\u001a\u00020;H\u0002J\n\u0010I\u001a\u0004\u0018\u00010'H\u0002J \u0010J\u001a\b\u0012\u0004\u0012\u00020D0C*\b\u0012\u0004\u0012\u00020K0\u00112\u0006\u0010\u0002\u001a\u00020LH\u0002J\u0018\u0010J\u001a\b\u0012\u0004\u0012\u00020D0C*\b\u0012\u0004\u0012\u00020$0\u0011H\u0002J \u0010J\u001a\b\u0012\u0004\u0012\u00020D0C*\b\u0012\u0004\u0012\u00020M0\u00112\u0006\u0010N\u001a\u00020'H\u0002J\u0016\u0010O\u001a\u00020;*\u00020\u001c2\b\u0010P\u001a\u0004\u0018\u00010QH\u0002J\u0016\u0010R\u001a\u0004\u0018\u00010\u0015*\u00020D2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006X"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;)V", "getContext", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "evaluatorValueConverter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter;", "getEvaluatorValueConverter", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "mutableRefWrappers", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$RefWrapper;", "refWrappers", "", "getRefWrappers", "()Ljava/util/List;", "find", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "parameter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "findCapturedVariable", "kind", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "parentFactory", "Lkotlin/Function0;", "Lcom/sun/jdi/Value;", "parent", "findCapturedVariableInContainingThis", "findCapturedVariableInReceiver", "variables", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "findCoroutineContext", "findCoroutineContextForContinuation", "Lcom/sun/jdi/ObjectReference;", "continuation", "findCoroutineContextForLambda", "method", "Lcom/sun/jdi/Method;", "findCoroutineContextForMethod", "findDebugLabel", "name", "", "findDispatchThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$OuterClassThis;", "findExtensionThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ExtensionThis;", "findFieldVariable", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$FieldVar;", "findLocalFunction", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$LocalFunction;", "findLocalVariable", "namePredicate", "Lkotlin/Function1;", "", "inlineDepth", "", "findOrdinary", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$Ordinary;", "findUnlabeledThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$UnlabeledThis;", "getCoroutineStackFrameNamedEntities", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity;", "getUnwrapDelegate", "rawValue", "isCapturedReceiverFieldName", "isInsideDefaultImpls", "thisObject", "namedEntitySequence", "Lcom/intellij/debugger/engine/JavaValue;", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "Lcom/sun/jdi/Field;", "owner", "typeMatches", "actualType", "Lcom/sun/jdi/Type;", "unwrapAndCheck", "Companion", "NamedEntity", "RefWrapper", "Result", "VariableKind", "kotlin.jvm-debugger.evaluation"})
public final class VariableFinder {
    private final StackFrameProxyImpl frameProxy;
    @NotNull
    private final EvaluatorValueConverter evaluatorValueConverter;
    private final List<RefWrapper> mutableRefWrappers;
    @NotNull
    private final ExecutionContext context;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final EvaluatorValueConverter getEvaluatorValueConverter() {
        return this.evaluatorValueConverter;
    }

    @NotNull
    public final List<RefWrapper> getRefWrappers() {
        return this.mutableRefWrappers;
    }

    @Nullable
    public final Result find(@NotNull CodeFragmentParameter parameter, @NotNull Type asmType) {
        Result result2;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
        switch (VariableFinder$WhenMappings.$EnumSwitchMapping$0[parameter.getKind().ordinal()]) {
            case 1: {
                result2 = this.findOrdinary(new VariableKind.Ordinary(parameter.getName(), asmType, false));
                break;
            }
            case 2: {
                result2 = this.findOrdinary(new VariableKind.Ordinary(parameter.getName(), asmType, true));
                break;
            }
            case 3: {
                ObjectReference objectReference = this.thisObject();
                if (objectReference != null) {
                    ObjectReference objectReference2;
                    ObjectReference it = objectReference2 = objectReference;
                    boolean bl = false;
                    result2 = new Result(it);
                    break;
                }
                result2 = null;
                break;
            }
            case 4: {
                result2 = this.findExtensionThis(new VariableKind.ExtensionThis(parameter.getName(), asmType));
                break;
            }
            case 5: {
                result2 = this.findLocalFunction(new VariableKind.LocalFunction(parameter.getName(), asmType));
                break;
            }
            case 6: {
                result2 = this.findDispatchThis(new VariableKind.OuterClassThis(asmType));
                break;
            }
            case 7: {
                result2 = this.findCoroutineContext();
                break;
            }
            case 8: {
                result2 = this.findFieldVariable(new VariableKind.FieldVar(parameter.getName(), asmType));
                break;
            }
            case 9: {
                result2 = this.findDebugLabel(parameter.getName());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return result2;
    }

    private final Result findOrdinary(VariableKind.Ordinary kind2) {
        List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        Result result2 = this.findLocalVariable(variables, (VariableKind)kind2, kind2.getName());
        if (result2 != null) {
            Result result3;
            Result it = result3 = result2;
            boolean bl = false;
            return it;
        }
        Result result4 = this.findCapturedVariableInReceiver(variables, kind2);
        if (result4 != null) {
            Result result5;
            Result it = result5 = result4;
            boolean bl = false;
            return it;
        }
        return this.findCapturedVariableInContainingThis(kind2);
    }

    private final Result findFieldVariable(VariableKind.FieldVar kind2) {
        ObjectReference thisObject = this.thisObject();
        if (thisObject != null) {
            Field field = thisObject.referenceType().fieldByName(kind2.getFieldName());
            if (field == null) {
                return null;
            }
            Field field2 = field;
            return new Result(thisObject.getValue(field2));
        }
        Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)this.frameProxy);
        if (comparable == null || (comparable = comparable.declaringType()) == null) {
            return null;
        }
        Comparable<Location> containingType = comparable;
        Field field = containingType.fieldByName(kind2.getFieldName());
        if (field == null) {
            return null;
        }
        Field field3 = field;
        return new Result(containingType.getValue(field3));
    }

    private final Result findLocalFunction(VariableKind.LocalFunction kind2) {
        List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        String newConventionName = "$fun$" + kind2.getName();
        Result result2 = this.findLocalVariable(variables, (VariableKind)kind2, newConventionName);
        if (result2 != null) {
            Result result3;
            Result it = result3 = result2;
            boolean bl = false;
            return it;
        }
        Result result4 = this.findLocalVariable(variables, (VariableKind)kind2, kind2.getName() + "$");
        if (result4 != null) {
            Result result5;
            Result it = result5 = result4;
            boolean bl = false;
            return it;
        }
        Result result6 = this.findCapturedVariableInReceiver(variables, kind2);
        if (result6 != null) {
            Result result7;
            Result it = result7 = result6;
            boolean bl = false;
            return it;
        }
        return this.findCapturedVariableInContainingThis(kind2);
    }

    private final Result findCapturedVariableInContainingThis(VariableKind kind2) {
        if (this.frameProxy instanceof CoroutineStackFrameProxyImpl && ((CoroutineStackFrameProxyImpl)this.frameProxy).isCoroutineScopeAvailable()) {
            Result result2 = this.findCapturedVariable(kind2, this.frameProxy.thisObject());
            if (result2 != null) {
                Result result3;
                Result it = result3 = result2;
                boolean bl = false;
                return it;
            }
            return this.findCapturedVariable(kind2, ((CoroutineStackFrameProxyImpl)this.frameProxy).getContinuation());
        }
        ObjectReference objectReference = this.thisObject();
        if (objectReference == null) {
            return null;
        }
        ObjectReference containingThis = objectReference;
        return this.findCapturedVariable(kind2, containingThis);
    }

    private final Result findExtensionThis(VariableKind.ExtensionThis kind2) {
        List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        Function1 namePredicate2 = (Function1)new Function1<String, Boolean>(kind2){
            final /* synthetic */ VariableKind.ExtensionThis $kind;

            public final boolean invoke(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return Intrinsics.areEqual((Object)name2, (Object)this.$kind.getParameterName()) || StringsKt.startsWith$default((String)name2, (String)(this.$kind.getParameterName() + "$"), (boolean)false, (int)2, null);
            }
            {
                this.$kind = extensionThis;
                super(1);
            }
        };
        Result result2 = this.findLocalVariable(variables, (VariableKind)kind2, (Function1<? super String, Boolean>)namePredicate2);
        if (result2 != null) {
            Result result3;
            Result it = result3 = result2;
            boolean bl = false;
            return it;
        }
        Result result4 = this.findCapturedVariableInReceiver(variables, kind2);
        if (result4 != null) {
            Result result5;
            Result it = result5 = result4;
            boolean bl = false;
            return it;
        }
        Result result6 = this.findCapturedVariableInContainingThis(kind2);
        if (result6 != null) {
            Result result7;
            Result it = result7 = result6;
            boolean bl = false;
            return it;
        }
        if (VariableFinder.Companion.getUSE_UNSAFE_FALLBACK()) {
            Result result8 = this.findUnlabeledThis(new VariableKind.UnlabeledThis(kind2.getAsmType()));
            if (result8 != null) {
                Result result9;
                Result it = result9 = result8;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    private final Result findDispatchThis(VariableKind.OuterClassThis kind2) {
        int inlineDepth;
        List<LocalVariableProxyImpl> variables;
        Result result2 = this.findCapturedVariableInContainingThis(kind2);
        if (result2 != null) {
            Result result3;
            Result it = result3 = result2;
            boolean bl = false;
            return it;
        }
        if (this.isInsideDefaultImpls()) {
            variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
            Result result4 = this.findLocalVariable(variables, (VariableKind)kind2, "$this");
            if (result4 != null) {
                Result it;
                Result it2 = it = result4;
                boolean bl = false;
                return it2;
            }
        }
        if ((inlineDepth = InlineUtilsKt.getInlineDepth(variables = SafeUtilKt.safeVisibleVariables(this.frameProxy))) > 0) {
            Result result5 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables), (Function1)((Function1)new Function1<NamedEntity, Boolean>(this, inlineDepth, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ int $inlineDepth;
                final /* synthetic */ VariableKind.OuterClassThis $kind;

                public final boolean invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    CharSequence charSequence = it.getName();
                    Regex regex = InlineUtilsKt.getINLINED_THIS_REGEX();
                    return regex.matches(charSequence) && InlineUtilsKt.getInlineDepth(it.getName()) == this.$inlineDepth && VariableFinder.access$typeMatches(this.this$0, this.$kind, it.getType());
                }
                {
                    this.this$0 = variableFinder;
                    this.$inlineDepth = n;
                    this.$kind = outerClassThis;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind.OuterClassThis $kind;

                @Nullable
                public final Result invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return VariableFinder.access$unwrapAndCheck(this.this$0, it, this.$kind);
                }
                {
                    this.this$0 = variableFinder;
                    this.$kind = outerClassThis;
                    super(1);
                }
            })));
            if (result5 != null) {
                Result result6;
                Result it = result6 = result5;
                boolean bl = false;
                return it;
            }
        }
        if (VariableFinder.Companion.getUSE_UNSAFE_FALLBACK()) {
            Result result7 = this.findUnlabeledThis(new VariableKind.UnlabeledThis(kind2.getAsmType()));
            if (result7 != null) {
                Result result8;
                Result it = result8 = result7;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Result findDebugLabel(String name2) {
        Map<? extends Value, ValueMarkup> markupMap = DebugLabelPropertyDescriptorProvider.Companion.getMarkupMap(this.context.getDebugProcess());
        Object object = markupMap;
        Iterator<Map.Entry<? extends Value, ValueMarkup>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void value2;
            Map.Entry<? extends Value, ValueMarkup> entry;
            Map.Entry<? extends Value, ValueMarkup> entry2 = entry = iterator.next();
            object = entry2.getKey();
            entry2 = entry;
            ValueMarkup markup = entry2.getValue();
            if (!Intrinsics.areEqual((Object)markup.getText(), (Object)name2)) continue;
            return new Result((Value)value2);
        }
        return null;
    }

    private final Result findUnlabeledThis(VariableKind.UnlabeledThis kind2) {
        List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        Result result2 = this.findCapturedVariableInReceiver(variables, kind2);
        if (result2 != null) {
            Result result3;
            Result it = result3 = result2;
            boolean bl = false;
            return it;
        }
        return this.findCapturedVariableInContainingThis(kind2);
    }

    private final Result findLocalVariable(List<? extends LocalVariableProxyImpl> variables, VariableKind kind2, String name2) {
        return this.findLocalVariable(variables, kind2, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(name2){
            final /* synthetic */ String $name;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$name);
            }
            {
                this.$name = string;
                super(1);
            }
        }));
    }

    private final Result findLocalVariable(List<? extends LocalVariableProxyImpl> variables, VariableKind kind2, Function1<? super String, Boolean> namePredicate2) {
        Result result2;
        StackFrameProxyImpl $this$safeAs$iv = this.frameProxy;
        boolean $i$f$safeAs = false;
        StackFrameProxyImpl stackFrameProxyImpl = $this$safeAs$iv;
        if (!(stackFrameProxyImpl instanceof InlineStackFrameProxyImpl)) {
            stackFrameProxyImpl = null;
        }
        InlineStackFrameProxyImpl inlineStackFrameProxyImpl = (InlineStackFrameProxyImpl)stackFrameProxyImpl;
        int inlineDepth = inlineStackFrameProxyImpl != null ? inlineStackFrameProxyImpl.getInlineDepth() : InlineUtilsKt.getInlineDepth(variables);
        Result result3 = this.findLocalVariable(variables, kind2, inlineDepth, namePredicate2);
        if (result3 != null) {
            Result it = result2 = result3;
            boolean bl = false;
            return it;
        }
        if (inlineDepth > 0 && VariableFinder.Companion.getUSE_UNSAFE_FALLBACK()) {
            Result result4 = this.findLocalVariable(variables, kind2, 0, namePredicate2);
            if (result4 != null) {
                Result it = result2 = result4;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    private final Result findLocalVariable(List<? extends LocalVariableProxyImpl> variables, VariableKind kind2, int inlineDepth, Function1<? super String, Boolean> namePredicate2) {
        Function1 actualPredicate = null;
        actualPredicate = inlineDepth > 0 ? (Function1)new Function1<String, Boolean>(inlineDepth, namePredicate2){
            final /* synthetic */ int $inlineDepth;
            final /* synthetic */ Function1 $namePredicate;

            public final boolean invoke(@NotNull String name2) {
                int endIndex;
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                int depth2 = 0;
                int suffixLen = "$iv".length();
                for (endIndex = name2.length(); endIndex >= suffixLen; endIndex -= suffixLen) {
                    String string = name2;
                    int n = endIndex - suffixLen;
                    String string2 = string.substring(n, endIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    if (Intrinsics.areEqual((Object)string2, (Object)"$iv") ^ true) break;
                    ++depth2;
                }
                return (Boolean)this.$namePredicate.invoke((Object)StringsKt.take((String)name2, (int)endIndex)) != false && InlineUtilsKt.getInlineDepth(name2) == this.$inlineDepth;
            }
            {
                this.$inlineDepth = n;
                this.$namePredicate = function1;
                super(1);
            }
        } : namePredicate2;
        Sequence namedEntities = SequencesKt.plus(this.namedEntitySequence(variables), this.getCoroutineStackFrameNamedEntities());
        for (NamedEntity item : namedEntities) {
            if (!((Boolean)actualPredicate.invoke((Object)item.getName())).booleanValue() || !this.typeMatches(kind2, item.getType())) continue;
            Value rawValue = item.getValue();
            Result result2 = this.evaluatorValueConverter.coerce(this.getUnwrapDelegate(kind2, rawValue), kind2.getAsmType());
            if (result2 == null) {
                continue;
            }
            Result result3 = result2;
            if (!EvaluatorValueConverterKt.isRefType(rawValue) && EvaluatorValueConverterKt.isRefType(result3.getValue())) {
                Collection collection = this.mutableRefWrappers;
                RefWrapper refWrapper = new RefWrapper(item.getName(), result3.getValue());
                collection.add(refWrapper);
            }
            return result3;
        }
        return null;
    }

    private final Sequence<NamedEntity> getCoroutineStackFrameNamedEntities() {
        return this.frameProxy instanceof CoroutineStackFrameProxyImpl ? this.namedEntitySequence(((CoroutineStackFrameProxyImpl)this.frameProxy).getSpilledVariables(), this.context.getEvaluationContext()) : SequencesKt.emptySequence();
    }

    private final boolean isInsideDefaultImpls() {
        Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)this.frameProxy);
        if (comparable == null || (comparable = comparable.declaringType()) == null) {
            return false;
        }
        Comparable<Location> declaringType = comparable;
        String string = declaringType.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"declaringType.name()");
        return StringsKt.endsWith$default((String)string, (String)"$DefaultImpls", (boolean)false, (int)2, null);
    }

    private final Result findCoroutineContext() {
        Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)this.frameProxy);
        if (comparable == null || (comparable = SafeUtilKt.safeMethod(comparable)) == null) {
            return null;
        }
        Comparable<Location> method = comparable;
        ObjectReference objectReference = this.findCoroutineContextForLambda((Method)method);
        if (objectReference == null) {
            objectReference = this.findCoroutineContextForMethod((Method)method);
        }
        if (objectReference == null) {
            return null;
        }
        ObjectReference result2 = objectReference;
        return new Result(result2);
    }

    private final ObjectReference findCoroutineContextForLambda(Method method) {
        boolean bl;
        ObjectReference continuation2;
        block6: {
            if (Intrinsics.areEqual((Object)method.name(), (Object)"invokeSuspend") ^ true || Intrinsics.areEqual((Object)method.signature(), (Object)"(Ljava/lang/Object;)Ljava/lang/Object;") ^ true || !(this.frameProxy instanceof CoroutineStackFrameProxyImpl)) {
                return null;
            }
            ObjectReference objectReference = ((CoroutineStackFrameProxyImpl)this.frameProxy).getContinuation();
            if (objectReference == null) {
                return null;
            }
            continuation2 = objectReference;
            ReferenceType continuationType = continuation2.referenceType();
            Iterable $this$none$iv = CoroutineUtilsKt.getSUSPEND_LAMBDA_CLASSES();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    ReferenceType referenceType = continuationType;
                    Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"continuationType");
                    if (!TypeUtilsKt.isSubtype((com.sun.jdi.Type)referenceType, it)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        return this.findCoroutineContextForContinuation(continuation2);
    }

    private final ObjectReference findCoroutineContextForMethod(Method method) {
        String string = method.signature();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.signature()");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)(CoroutineUtilsKt.getCONTINUATION_TYPE().getDescriptor() + ")"), (boolean)false, (int)2, null)) {
            return null;
        }
        LocalVariableProxyImpl localVariableProxyImpl = SafeUtilKt.safeVisibleVariableByName(this.frameProxy, "$continuation");
        if (localVariableProxyImpl == null) {
            localVariableProxyImpl = SafeUtilKt.safeVisibleVariableByName(this.frameProxy, "$completion");
        }
        if (localVariableProxyImpl == null) {
            return null;
        }
        LocalVariableProxyImpl continuationVariable = localVariableProxyImpl;
        Value value2 = this.frameProxy.getValue(continuationVariable);
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        ObjectReference objectReference = (ObjectReference)value2;
        if (objectReference == null) {
            return null;
        }
        ObjectReference continuation2 = objectReference;
        return this.findCoroutineContextForContinuation(continuation2);
    }

    private final ObjectReference findCoroutineContextForContinuation(ObjectReference continuation2) {
        Object object;
        block9: {
            block8: {
                Object v2;
                block7: {
                    ReferenceType referenceType = continuation2.referenceType();
                    if (!(referenceType instanceof ClassType)) {
                        referenceType = null;
                    }
                    if ((object = (ClassType)referenceType) == null || (object = object.allInterfaces()) == null) break block8;
                    Iterable $this$firstOrNull$iv = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        InterfaceType it = (InterfaceType)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)Continuation.class.getName())) continue;
                        v2 = element$iv;
                        break block7;
                    }
                    v2 = null;
                }
                if ((object = (InterfaceType)v2) != null) break block9;
            }
            return null;
        }
        Object continuationType = object;
        List<Method> list2 = continuationType.methodsByName("getContext", "()Lkotlin/coroutines/CoroutineContext;");
        Intrinsics.checkNotNullExpressionValue(list2, (String)"continuationType\n       \u2026tines/CoroutineContext;\")");
        Method method = (Method)CollectionsKt.firstOrNull(list2);
        if (method == null) {
            return null;
        }
        Method getContextMethod = method;
        Value value2 = BaseExecutionContext.invokeMethod$default(this.context, continuation2, getContextMethod, CollectionsKt.emptyList(), 0, 8, null);
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        return (ObjectReference)value2;
    }

    private final Result findCapturedVariableInReceiver(List<? extends LocalVariableProxyImpl> variables, VariableKind kind2) {
        findCapturedVariableInReceiver.1 $fun$isReceiverOrPassedThis$1 = findCapturedVariableInReceiver.1.INSTANCE;
        if (kind2 instanceof VariableKind.ExtensionThis) {
            Result result2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables), (Function1)((Function1)new Function1<NamedEntity, Boolean>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind $kind;

                public final boolean invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$kind.capturedNameMatches(it.getName()) && VariableFinder.access$typeMatches(this.this$0, this.$kind, it.getType());
                }
                {
                    this.this$0 = variableFinder;
                    this.$kind = variableKind;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind $kind;

                @Nullable
                public final Result invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return VariableFinder.access$unwrapAndCheck(this.this$0, it, this.$kind);
                }
                {
                    this.this$0 = variableFinder;
                    this.$kind = variableKind;
                    super(1);
                }
            })));
            if (result2 != null) {
                Result result3;
                Result it = result3 = result2;
                boolean bl = false;
                return it;
            }
        }
        return (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables), (Function1)findCapturedVariableInReceiver.5.INSTANCE), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
            final /* synthetic */ VariableFinder this$0;
            final /* synthetic */ VariableKind $kind;

            @Nullable
            public final Result invoke(@NotNull NamedEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return VariableFinder.access$findCapturedVariable(this.this$0, this.$kind, it.getValue());
            }
            {
                this.this$0 = variableFinder;
                this.$kind = variableKind;
                super(1);
            }
        })));
    }

    private final Result findCapturedVariable(VariableKind kind2, Function0<? extends Value> parentFactory) {
        Value parent2 = this.getUnwrapDelegate(kind2, (Value)parentFactory.invoke());
        return this.findCapturedVariable(kind2, parent2);
    }

    private final Result findCapturedVariable(VariableKind kind2, Value parent2) {
        Object object;
        boolean acceptsParentValue;
        boolean bl = acceptsParentValue = kind2 instanceof VariableKind.UnlabeledThis || kind2 instanceof VariableKind.OuterClassThis;
        if (parent2 != null && acceptsParentValue && this.typeMatches(kind2, parent2.type())) {
            return new Result(parent2);
        }
        Value value2 = parent2;
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        if ((object = (ObjectReference)value2) == null || (object = object.referenceType()) == null || (object = object.fields()) == null) {
            return null;
        }
        Object fields2 = object;
        if (!(kind2 instanceof VariableKind.OuterClassThis)) {
            Result result2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence((List<? extends Field>)fields2, (ObjectReference)parent2), (Function1)((Function1)new Function1<NamedEntity, Boolean>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind $kind;

                public final boolean invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$kind.capturedNameMatches(it.getName()) && VariableFinder.access$typeMatches(this.this$0, this.$kind, it.getType());
                }
                {
                    this.this$0 = variableFinder;
                    this.$kind = variableKind;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind $kind;

                @Nullable
                public final Result invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return VariableFinder.access$unwrapAndCheck(this.this$0, it, this.$kind);
                }
                {
                    this.this$0 = variableFinder;
                    this.$kind = variableKind;
                    super(1);
                }
            })));
            if (result2 != null) {
                Result result3;
                Result it = result3 = result2;
                boolean bl2 = false;
                return it;
            }
            Result result4 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence((List<? extends Field>)fields2, (ObjectReference)parent2), (Function1)((Function1)new Function1<NamedEntity, Boolean>(this){
                final /* synthetic */ VariableFinder this$0;

                public final boolean invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return VariableFinder.access$isCapturedReceiverFieldName(this.this$0, it.getName());
                }
                {
                    this.this$0 = variableFinder;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind $kind;

                @Nullable
                public final Result invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return VariableFinder.access$findCapturedVariable(this.this$0, this.$kind, it.getValue());
                }
                {
                    this.this$0 = variableFinder;
                    this.$kind = variableKind;
                    super(1);
                }
            })));
            if (result4 != null) {
                Result result5;
                Result it = result5 = result4;
                boolean bl3 = false;
                return it;
            }
        }
        Result result6 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence((List<? extends Field>)fields2, (ObjectReference)parent2), (Function1)findCapturedVariable.7.INSTANCE), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
            final /* synthetic */ VariableFinder this$0;
            final /* synthetic */ VariableKind $kind;

            @Nullable
            public final Result invoke(@NotNull NamedEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return VariableFinder.access$findCapturedVariable(this.this$0, this.$kind, it.getValue());
            }
            {
                this.this$0 = variableFinder;
                this.$kind = variableKind;
                super(1);
            }
        })));
        if (result6 != null) {
            Result result7;
            Result it = result7 = result6;
            boolean bl4 = false;
            return it;
        }
        return null;
    }

    private final Value getUnwrapDelegate(VariableKind kind2, Value rawValue) {
        if (!(kind2 instanceof VariableKind.Ordinary) || !((VariableKind.Ordinary)kind2).isDelegated()) {
            return rawValue;
        }
        Value value2 = rawValue;
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        ObjectReference objectReference = (ObjectReference)value2;
        if (objectReference == null) {
            return rawValue;
        }
        ObjectReference delegateValue = objectReference;
        List<Method> list2 = delegateValue.referenceType().methodsByName("getValue", "()Ljava/lang/Object;");
        Intrinsics.checkNotNullExpressionValue(list2, (String)"delegateValue.referenceT\u2026, \"()Ljava/lang/Object;\")");
        Method method = (Method)CollectionsKt.firstOrNull(list2);
        if (method == null) {
            return rawValue;
        }
        Method getValueMethod = method;
        return BaseExecutionContext.invokeMethod$default(this.context, delegateValue, getValueMethod, CollectionsKt.emptyList(), 0, 8, null);
    }

    private final boolean isCapturedReceiverFieldName(String name2) {
        String string = AsmUtil.getCapturedFieldName((String)"this_");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCapturedFieldName(AsmUtil.LABELED_THIS_FIELD)");
        return StringsKt.startsWith$default((String)name2, (String)string, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name2, (Object)"receiver$0");
    }

    private final boolean typeMatches(VariableKind $this$typeMatches, com.sun.jdi.Type actualType) {
        if ($this$typeMatches instanceof VariableKind.Ordinary && ((VariableKind.Ordinary)$this$typeMatches).isDelegated()) {
            return true;
        }
        return this.evaluatorValueConverter.typeMatches($this$typeMatches.getAsmType(), actualType);
    }

    private final Result unwrapAndCheck(NamedEntity $this$unwrapAndCheck, VariableKind kind2) {
        return this.evaluatorValueConverter.coerce(this.getUnwrapDelegate(kind2, $this$unwrapAndCheck.getValue()), kind2.getAsmType());
    }

    private final Sequence<NamedEntity> namedEntitySequence(List<? extends Field> $this$namedEntitySequence, ObjectReference owner) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$namedEntitySequence), (Function1)((Function1)new Function1<Field, NamedEntity>(owner){
            final /* synthetic */ ObjectReference $owner;

            @NotNull
            public final NamedEntity invoke(@NotNull Field it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return NamedEntity.Companion.of(it, this.$owner);
            }
            {
                this.$owner = objectReference;
                super(1);
            }
        }));
    }

    private final Sequence<NamedEntity> namedEntitySequence(List<? extends LocalVariableProxyImpl> $this$namedEntitySequence) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$namedEntitySequence), (Function1)((Function1)new Function1<LocalVariableProxyImpl, NamedEntity>(this){
            final /* synthetic */ VariableFinder this$0;

            @NotNull
            public final NamedEntity invoke(@NotNull LocalVariableProxyImpl it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return NamedEntity.Companion.of(it, VariableFinder.access$getFrameProxy$p(this.this$0));
            }
            {
                this.this$0 = variableFinder;
                super(1);
            }
        }));
    }

    private final Sequence<NamedEntity> namedEntitySequence(List<? extends JavaValue> $this$namedEntitySequence, EvaluationContextImpl context2) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$namedEntitySequence), (Function1)((Function1)new Function1<JavaValue, NamedEntity>(context2){
            final /* synthetic */ EvaluationContextImpl $context;

            @NotNull
            public final NamedEntity invoke(@NotNull JavaValue it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return NamedEntity.Companion.of(it, this.$context);
            }
            {
                this.$context = evaluationContextImpl;
                super(1);
            }
        }));
    }

    private final ObjectReference thisObject() {
        ObjectReference thisObjectFromEvaluation;
        Value value2 = this.context.getEvaluationContext().computeThisObject();
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        if ((thisObjectFromEvaluation = (ObjectReference)value2) != null) {
            return thisObjectFromEvaluation;
        }
        return this.frameProxy.thisObject();
    }

    @NotNull
    public final ExecutionContext getContext() {
        return this.context;
    }

    public VariableFinder(@NotNull ExecutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.frameProxy = this.context.getFrameProxy();
        this.evaluatorValueConverter = new EvaluatorValueConverter(this.context);
        this.mutableRefWrappers = new ArrayList();
    }

    public static final /* synthetic */ boolean access$typeMatches(VariableFinder $this, VariableKind $this$access_u24typeMatches, com.sun.jdi.Type actualType) {
        return $this.typeMatches($this$access_u24typeMatches, actualType);
    }

    public static final /* synthetic */ Result access$unwrapAndCheck(VariableFinder $this, NamedEntity $this$access_u24unwrapAndCheck, VariableKind kind2) {
        return $this.unwrapAndCheck($this$access_u24unwrapAndCheck, kind2);
    }

    public static final /* synthetic */ Result access$findCapturedVariable(VariableFinder $this, VariableKind kind2, Value parent2) {
        return $this.findCapturedVariable(kind2, parent2);
    }

    public static final /* synthetic */ boolean access$isCapturedReceiverFieldName(VariableFinder $this, String name2) {
        return $this.isCapturedReceiverFieldName(name2);
    }

    public static final /* synthetic */ StackFrameProxyImpl access$getFrameProxy$p(VariableFinder $this) {
        return $this.frameProxy;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$RefWrapper;", "", "localVariableName", "", "wrapper", "Lcom/sun/jdi/Value;", "(Ljava/lang/String;Lcom/sun/jdi/Value;)V", "getLocalVariableName", "()Ljava/lang/String;", "getWrapper", "()Lcom/sun/jdi/Value;", "kotlin.jvm-debugger.evaluation"})
    public static final class RefWrapper {
        @NotNull
        private final String localVariableName;
        @Nullable
        private final Value wrapper;

        @NotNull
        public final String getLocalVariableName() {
            return this.localVariableName;
        }

        @Nullable
        public final Value getWrapper() {
            return this.wrapper;
        }

        public RefWrapper(@NotNull String localVariableName, @Nullable Value wrapper) {
            Intrinsics.checkNotNullParameter((Object)localVariableName, (String)"localVariableName");
            this.localVariableName = localVariableName;
            this.wrapper = wrapper;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0006\u000b\f\r\u000e\u000f\u0010B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0006\u0011\u0012\u0013\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "getAsmType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "capturedNameMatches", "", "name", "", "ExtensionThis", "FieldVar", "LocalFunction", "Ordinary", "OuterClassThis", "UnlabeledThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$Ordinary;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$LocalFunction;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$UnlabeledThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$OuterClassThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$FieldVar;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ExtensionThis;", "kotlin.jvm-debugger.evaluation"})
    public static abstract class VariableKind {
        @NotNull
        private final Type asmType;

        public abstract boolean capturedNameMatches(@NotNull String var1);

        @NotNull
        public final Type getAsmType() {
            return this.asmType;
        }

        private VariableKind(Type asmType) {
            this.asmType = asmType;
        }

        public /* synthetic */ VariableKind(Type asmType, DefaultConstructorMarker $constructor_marker) {
            this(asmType);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$Ordinary;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "name", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "isDelegated", "", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;Z)V", "capturedNameRegex", "Lkotlin/text/Regex;", "()Z", "getName", "()Ljava/lang/String;", "capturedNameMatches", "kotlin.jvm-debugger.evaluation"})
        public static final class Ordinary
        extends VariableKind {
            private final Regex capturedNameRegex;
            @NotNull
            private final String name;
            private final boolean isDelegated;

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return this.capturedNameRegex.matches((CharSequence)name2);
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public final boolean isDelegated() {
                return this.isDelegated;
            }

            public Ordinary(@NotNull String name2, @NotNull Type asmType, boolean isDelegated) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.name = name2;
                this.isDelegated = isDelegated;
                String string = AsmUtil.getCapturedFieldName((String)this.name);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCapturedFieldName(this.name)");
                this.capturedNameRegex = Companion.getCapturedVariableNameRegex(string);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$LocalFunction;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "name", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getName", "()Ljava/lang/String;", "capturedNameMatches", "", "kotlin.jvm-debugger.evaluation"})
        public static final class LocalFunction
        extends VariableKind {
            @NotNull
            private final String name;

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return Intrinsics.areEqual((Object)name2, (Object)("$" + name2));
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public LocalFunction(@NotNull String name2, @NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.name = name2;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$UnlabeledThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "capturedNameMatches", "", "name", "", "kotlin.jvm-debugger.evaluation"})
        public static final class UnlabeledThis
        extends VariableKind {
            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                if (Intrinsics.areEqual((Object)name2, (Object)"receiver$0")) return true;
                String string = AsmUtil.getCapturedFieldName((String)"this_");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCapturedFieldName(AsmUtil.LABELED_THIS_FIELD)");
                if (!StringsKt.startsWith$default((String)name2, (String)string, (boolean)false, (int)2, null)) return false;
                return true;
            }

            public UnlabeledThis(@NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$OuterClassThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "capturedNameMatches", "", "name", "", "kotlin.jvm-debugger.evaluation"})
        public static final class OuterClassThis
        extends VariableKind {
            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return false;
            }

            public OuterClassThis(@NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$FieldVar;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "fieldName", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getFieldName", "()Ljava/lang/String;", "capturedNameMatches", "", "name", "kotlin.jvm-debugger.evaluation"})
        public static final class FieldVar
        extends VariableKind {
            @NotNull
            private final String fieldName;

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return false;
            }

            @NotNull
            public final String getFieldName() {
                return this.fieldName;
            }

            public FieldVar(@NotNull String fieldName, @NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.fieldName = fieldName;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ExtensionThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "label", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;)V", "capturedNameRegex", "Lkotlin/text/Regex;", "fieldName", "getFieldName", "()Ljava/lang/String;", "getLabel", "parameterName", "getParameterName", "capturedNameMatches", "", "name", "kotlin.jvm-debugger.evaluation"})
        public static final class ExtensionThis
        extends VariableKind {
            @NotNull
            private final String parameterName;
            @NotNull
            private final String fieldName;
            private final Regex capturedNameRegex;
            @NotNull
            private final String label;

            @NotNull
            public final String getParameterName() {
                return this.parameterName;
            }

            @NotNull
            public final String getFieldName() {
                return this.fieldName;
            }

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return this.capturedNameRegex.matches((CharSequence)name2);
            }

            @NotNull
            public final String getLabel() {
                return this.label;
            }

            public ExtensionThis(@NotNull String label2, @NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.label = label2;
                String string = AsmUtil.getLabeledThisName((String)this.label, (String)"$this$", (String)"$receiver");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLabeledThisName(label\u2026.RECEIVER_PARAMETER_NAME)");
                this.parameterName = string;
                String string2 = AsmUtil.getLabeledThisName((String)this.label, (String)AsmUtil.getCapturedFieldName((String)"this_"), (String)"receiver$0");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLabeledThisName(label\u2026.CAPTURED_RECEIVER_FIELD)");
                this.fieldName = string2;
                this.capturedNameRegex = Companion.getCapturedVariableNameRegex(this.fieldName);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "", "value", "Lcom/sun/jdi/Value;", "(Lcom/sun/jdi/Value;)V", "getValue", "()Lcom/sun/jdi/Value;", "kotlin.jvm-debugger.evaluation"})
    public static final class Result {
        @Nullable
        private final Value value;

        @Nullable
        public final Value getValue() {
            return this.value;
        }

        public Result(@Nullable Value value2) {
            this.value = value2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\u0002\u0010\tR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity;", "", "name", "", "lazyType", "Lkotlin/Lazy;", "Lcom/sun/jdi/Type;", "lazyValue", "Lcom/sun/jdi/Value;", "(Ljava/lang/String;Lkotlin/Lazy;Lkotlin/Lazy;)V", "getLazyType", "()Lkotlin/Lazy;", "getLazyValue", "getName", "()Ljava/lang/String;", "type", "getType", "()Lcom/sun/jdi/Type;", "value", "getValue", "()Lcom/sun/jdi/Value;", "Companion", "kotlin.jvm-debugger.evaluation"})
    private static final class NamedEntity {
        @NotNull
        private final String name;
        @NotNull
        private final Lazy<com.sun.jdi.Type> lazyType;
        @NotNull
        private final Lazy<Value> lazyValue;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Nullable
        public final com.sun.jdi.Type getType() {
            return (com.sun.jdi.Type)this.lazyType.getValue();
        }

        @Nullable
        public final Value getValue() {
            return (Value)this.lazyValue.getValue();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Lazy<com.sun.jdi.Type> getLazyType() {
            return this.lazyType;
        }

        @NotNull
        public final Lazy<Value> getLazyValue() {
            return this.lazyValue;
        }

        public NamedEntity(@NotNull String name2, @NotNull Lazy<? extends com.sun.jdi.Type> lazyType, @NotNull Lazy<? extends Value> lazyValue) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(lazyType, (String)"lazyType");
            Intrinsics.checkNotNullParameter(lazyValue, (String)"lazyValue");
            this.name = name2;
            this.lazyType = lazyType;
            this.lazyValue = lazyValue;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity$Companion;", "", "()V", "of", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity;", "variable", "Lcom/intellij/debugger/engine/JavaValue;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "field", "Lcom/sun/jdi/Field;", "owner", "Lcom/sun/jdi/ObjectReference;", "kotlin.jvm-debugger.evaluation"})
        public static final class Companion {
            @NotNull
            public final NamedEntity of(@NotNull Field field, @NotNull ObjectReference owner) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Lazy type2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<com.sun.jdi.Type>(field){
                    final /* synthetic */ Field $field;

                    @Nullable
                    public final com.sun.jdi.Type invoke() {
                        return SafeUtilKt.safeType(this.$field);
                    }
                    {
                        this.$field = field;
                        super(0);
                    }
                }));
                Lazy value2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<Value>(owner, field){
                    final /* synthetic */ ObjectReference $owner;
                    final /* synthetic */ Field $field;

                    public final Value invoke() {
                        return this.$owner.getValue(this.$field);
                    }
                    {
                        this.$owner = objectReference;
                        this.$field = field;
                        super(0);
                    }
                }));
                String string = field.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name()");
                return new NamedEntity(string, (Lazy<? extends com.sun.jdi.Type>)type2, (Lazy<? extends Value>)value2);
            }

            @NotNull
            public final NamedEntity of(@NotNull LocalVariableProxyImpl variable2, @NotNull StackFrameProxyImpl frameProxy) {
                Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
                Lazy type2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<com.sun.jdi.Type>(variable2){
                    final /* synthetic */ LocalVariableProxyImpl $variable;

                    @Nullable
                    public final com.sun.jdi.Type invoke() {
                        return SafeUtilKt.safeType(this.$variable);
                    }
                    {
                        this.$variable = localVariableProxyImpl;
                        super(0);
                    }
                }));
                Lazy value2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<Value>(frameProxy, variable2){
                    final /* synthetic */ StackFrameProxyImpl $frameProxy;
                    final /* synthetic */ LocalVariableProxyImpl $variable;

                    public final Value invoke() {
                        return this.$frameProxy.getValue(this.$variable);
                    }
                    {
                        this.$frameProxy = stackFrameProxyImpl;
                        this.$variable = localVariableProxyImpl;
                        super(0);
                    }
                }));
                String string = variable2.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variable.name()");
                return new NamedEntity(string, (Lazy<? extends com.sun.jdi.Type>)type2, (Lazy<? extends Value>)value2);
            }

            @NotNull
            public final NamedEntity of(@NotNull JavaValue variable2, @NotNull EvaluationContextImpl context2) {
                Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Lazy type2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<com.sun.jdi.Type>(variable2){
                    final /* synthetic */ JavaValue $variable;

                    @Nullable
                    public final com.sun.jdi.Type invoke() {
                        ValueDescriptorImpl valueDescriptorImpl = this.$variable.getDescriptor();
                        Intrinsics.checkNotNullExpressionValue((Object)valueDescriptorImpl, (String)"variable.descriptor");
                        return valueDescriptorImpl.getType();
                    }
                    {
                        this.$variable = javaValue;
                        super(0);
                    }
                }));
                Lazy value2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<Value>(variable2, context2){
                    final /* synthetic */ JavaValue $variable;
                    final /* synthetic */ EvaluationContextImpl $context;

                    @Nullable
                    public final Value invoke() {
                        ValueDescriptorImpl valueDescriptorImpl = this.$variable.getDescriptor();
                        Intrinsics.checkNotNullExpressionValue((Object)valueDescriptorImpl, (String)"variable.descriptor");
                        return SafeUtilKt.safeCalcValue(valueDescriptorImpl, this.$context);
                    }
                    {
                        this.$variable = javaValue;
                        this.$context = evaluationContextImpl;
                        super(0);
                    }
                }));
                String string = variable2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variable.name");
                return new NamedEntity(string, (Lazy<? extends com.sun.jdi.Type>)type2, (Lazy<? extends Value>)value2);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Companion;", "", "()V", "USE_UNSAFE_FALLBACK", "", "getUSE_UNSAFE_FALLBACK", "()Z", "getCapturedVariableNameRegex", "Lkotlin/text/Regex;", "capturedName", "", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private final boolean getUSE_UNSAFE_FALLBACK() {
            return true;
        }

        private final Regex getCapturedVariableNameRegex(String capturedName) {
            String escapedName = Regex.Companion.escape(capturedName);
            String escapedSuffix = Regex.Companion.escape("$inlined");
            return new Regex("^" + escapedName + "(?:" + escapedSuffix + ")?$");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

