/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.application.ReadAction;
import com.intellij.util.Range;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerSettings;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepIntoHandlerKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTarget;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J$\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0006 \u0010*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b0\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J$\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepIntoHandler;", "Lcom/intellij/debugger/actions/JvmSmartStepIntoHandler;", "()V", "createMethodFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "stepTarget", "Lcom/intellij/debugger/actions/SmartStepTarget;", "findSmartStepTargets", "", "position", "Lcom/intellij/debugger/SourcePosition;", "session", "Lcom/intellij/debugger/impl/DebuggerSession;", "findSmartStepTargetsAsync", "Lorg/jetbrains/concurrency/Promise;", "findSmartStepTargetsInReadAction", "kotlin.jvm.PlatformType", "findStepIntoTargets", "isAvailable", "", "kotlin.jvm-debugger.core"})
public final class KotlinSmartStepIntoHandler
extends JvmSmartStepIntoHandler {
    public boolean isAvailable(@Nullable SourcePosition position) {
        SourcePosition sourcePosition2 = position;
        return (sourcePosition2 != null ? sourcePosition2.getFile() : null) instanceof KtFile;
    }

    @NotNull
    public Promise<List<SmartStepTarget>> findStepIntoTargets(@NotNull SourcePosition position, @NotNull DebuggerSession session) {
        Promise promise;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (KotlinDebuggerSettings.Companion.getInstance().getAlwaysDoSmartStepInto()) {
            promise = this.findSmartStepTargetsAsync(position, session);
        } else {
            Promise promise2 = super.findStepIntoTargets(position, session);
            promise = promise2;
            Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"super.findStepIntoTargets(position, session)");
        }
        return promise;
    }

    @NotNull
    public Promise<List<SmartStepTarget>> findSmartStepTargetsAsync(@NotNull SourcePosition position, @NotNull DebuggerSession session) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        AsyncPromise result2 = new AsyncPromise();
        DebuggerCommandImpl command2 = new DebuggerCommandImpl(this, result2, position, session, PrioritizedTask.Priority.NORMAL){
            final /* synthetic */ KotlinSmartStepIntoHandler this$0;
            final /* synthetic */ AsyncPromise $result;
            final /* synthetic */ SourcePosition $position;
            final /* synthetic */ DebuggerSession $session;

            protected void action() {
                block2: {
                    List list2;
                    AsyncPromise $this$compute$iv = this.$result;
                    boolean $i$f$compute = false;
                    try {
                        boolean bl = false;
                        List list3 = KotlinSmartStepIntoHandler.access$findSmartStepTargetsInReadAction(this.this$0, this.$position, this.$session);
                        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"findSmartStepTargetsInRe\u2026Action(position, session)");
                        list2 = list3;
                    }
                    catch (Throwable e$iv) {
                        $this$compute$iv.setError(e$iv);
                        break block2;
                    }
                    List result$iv = list2;
                    $this$compute$iv.setResult((Object)result$iv);
                }
            }

            protected void commandCancelled() {
                this.$result.setError("Cancelled");
            }
            {
                this.this$0 = this$0;
                this.$result = $captured_local_variable$1;
                this.$position = $captured_local_variable$2;
                this.$session = $captured_local_variable$3;
                super($super_call_param$4);
            }
        };
        DebugProcessImpl debugProcessImpl = session.getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"session.process");
        DebuggerManagerThreadImpl debuggerManagerThreadImpl = debugProcessImpl.getManagerThread();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerManagerThreadImpl, (String)"session.process.managerThread");
        DebuggerManagerThreadImpl managerThread = debuggerManagerThreadImpl;
        if (DebuggerManagerThreadImpl.isManagerThread()) {
            managerThread.invoke(command2);
        } else {
            managerThread.schedule(command2);
        }
        return (Promise)result2;
    }

    @NotNull
    public List<SmartStepTarget> findSmartStepTargets(@NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        List<SmartStepTarget> list2 = this.findSmartStepTargetsInReadAction(position, null);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"findSmartStepTargetsInReadAction(position, null)");
        return list2;
    }

    @Nullable
    protected MethodFilter createMethodFilter(@Nullable SmartStepTarget stepTarget) {
        SmartStepTarget smartStepTarget = stepTarget;
        return smartStepTarget instanceof KotlinSmartStepTarget ? ((KotlinSmartStepTarget)stepTarget).createMethodFilter() : super.createMethodFilter(stepTarget);
    }

    private final List<SmartStepTarget> findSmartStepTargetsInReadAction(SourcePosition position, DebuggerSession session) {
        return (List)ReadAction.nonBlocking((Callable)new Callable(this, position, session){
            final /* synthetic */ KotlinSmartStepIntoHandler this$0;
            final /* synthetic */ SourcePosition $position;
            final /* synthetic */ DebuggerSession $session;

            public final List<SmartStepTarget> call() {
                return KotlinSmartStepIntoHandler.access$findSmartStepTargets(this.this$0, this.$position, this.$session);
            }
            {
                this.this$0 = kotlinSmartStepIntoHandler;
                this.$position = sourcePosition2;
                this.$session = debuggerSession;
            }
        }).executeSynchronously();
    }

    private final List<SmartStepTarget> findSmartStepTargets(SourcePosition position, DebuggerSession session) {
        KtElement ktElement = KotlinSmartStepIntoHandlerKt.access$getTopmostElement(position);
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement topmostElement = ktElement;
        Range range2 = KotlinSmartStepIntoHandlerKt.access$getLines(topmostElement);
        if (range2 == null) {
            return CollectionsKt.emptyList();
        }
        Range lines = range2;
        List targets = KotlinSmartStepIntoHandlerKt.access$findSmartStepTargets(topmostElement, lines);
        if (session != null) {
            DebugProcessImpl debugProcessImpl = session.getProcess();
            Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"session.process");
            targets = KotlinSmartStepIntoHandlerKt.access$calculateSmartStepTargetsToShow(targets, debugProcessImpl, (ClosedRange)KotlinSmartStepIntoHandlerKt.access$toClosedRange(lines));
        }
        List list2 = KotlinSmartStepIntoHandler.access$reorderWithSteppingFilters$s1042156406(targets);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"reorderWithSteppingFilters(targets)");
        return list2;
    }

    public static final /* synthetic */ List access$findSmartStepTargetsInReadAction(KotlinSmartStepIntoHandler $this, SourcePosition position, DebuggerSession session) {
        return $this.findSmartStepTargetsInReadAction(position, session);
    }

    public static final /* synthetic */ List access$findSmartStepTargets(KotlinSmartStepIntoHandler $this, SourcePosition position, DebuggerSession session) {
        return $this.findSmartStepTargets(position, session);
    }

    public static final /* synthetic */ List access$reorderWithSteppingFilters$s1042156406(List p0) {
        return JvmSmartStepIntoHandler.reorderWithSteppingFilters((List)p0);
    }
}

