/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.idea.editor.LtGtTypingUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;

public class KotlinBackspaceHandler
extends BackspaceHandlerDelegate {
    private boolean deleteGt;

    public void beforeCharDeleted(char c, PsiFile file2, Editor editor2) {
        int offset2 = editor2.getCaretModel().getOffset() - 1;
        this.deleteGt = c == '<' && file2 instanceof KtFile && (LtGtTypingUtils.isAfterToken(offset2, editor2, (KtToken)KtTokens.FUN_KEYWORD) || LtGtTypingUtils.isAfterToken(offset2, editor2, KtTokens.IDENTIFIER));
    }

    public boolean charDeleted(char c, PsiFile file2, Editor editor2) {
        int offset2 = editor2.getCaretModel().getOffset();
        CharSequence chars = editor2.getDocument().getCharsSequence();
        if (editor2.getDocument().getTextLength() <= offset2) {
            return false;
        }
        char c1 = chars.charAt(offset2);
        if (c == '<' && this.deleteGt) {
            if (c1 == '>') {
                LtGtTypingUtils.handleKotlinLTDeletion(editor2, offset2);
            }
            return true;
        }
        return false;
    }
}

