/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalModuleBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradleJava.configuration.GradleModuleBuilderUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0000\u00a8\u0006\n"}, d2={"addBrowserSupport", "", "module", "Lcom/intellij/openapi/module/Module;", "browserConfiguration", "", "getNewFileWriter", "Ljava/io/Writer;", "relativeDir", "fileName", "kotlin.gradle.gradle-java"})
public final class GradleKotlinFrameworkSupportProviderUtilsKt {
    @Nullable
    public static final Writer getNewFileWriter(@NotNull Module module2, @NotNull String relativeDir, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)relativeDir, (String)"relativeDir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        AbstractExternalModuleBuilder<?> abstractExternalModuleBuilder = GradleModuleBuilderUtilsKt.getGradleModuleBuilder(module2);
        String string = abstractExternalModuleBuilder == null ? null : abstractExternalModuleBuilder.getContentEntryPath();
        if (string == null) {
            return null;
        }
        String contentEntryPath = string;
        if (((CharSequence)contentEntryPath).length() == 0) {
            return null;
        }
        File contentRootDir = new File(contentEntryPath);
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(contentRootDir);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile modelContentRootDir = virtualFile2;
        VirtualFile virtualFile3 = VfsUtil.createDirectoryIfMissing((VirtualFile)modelContentRootDir, (String)relativeDir);
        if (virtualFile3 == null) {
            return null;
        }
        VirtualFile dir = virtualFile3;
        if (dir.findChild(fileName) != null) {
            return null;
        }
        Object object = dir.createChildData(null, fileName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dir.createChildData(null, fileName)");
        VirtualFile file2 = object;
        object = file2.getOutputStream(null);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.getOutputStream(null)");
        Charset charset = Charsets.UTF_8;
        return new OutputStreamWriter((OutputStream)object, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addBrowserSupport(@NotNull Module module2) {
        Writer it2;
        Throwable throwable;
        Closeable closeable;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Writer writer = GradleKotlinFrameworkSupportProviderUtilsKt.getNewFileWriter(module2, "src/main/resources", "index.html");
        if (writer != null) {
            closeable = writer;
            throwable = null;
            try {
                it2 = (Writer)closeable;
                boolean bl = false;
                it2.write(((Object)StringsKt.trim((CharSequence)StringsKt.trimIndent((String)("\n                <!DOCTYPE html>\n                <html lang=\"en\">\n                <head>\n                    <meta charset=\"UTF-8\">\n                    <title>" + module2.getName() + "</title>\n                    <script src=\"" + module2.getName() + ".js\"></script>\n                </head>\n                <body>\n                \n                </body>\n                </html>\n            ")))).toString());
                it2 = Unit.INSTANCE;
            }
            catch (Throwable it2) {
                throwable = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        Writer writer2 = GradleKotlinFrameworkSupportProviderUtilsKt.getNewFileWriter(module2, "src/main/kotlin", "main.kt");
        if (writer2 != null) {
            closeable = writer2;
            throwable = null;
            try {
                it2 = (Writer)closeable;
                boolean bl = false;
                it2.write(((Object)StringsKt.trim((CharSequence)"import kotlinx.browser.document\n\nfun main() {\n    document.write(\"Hello, world!\")\n}")).toString());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @NotNull
    public static final String browserConfiguration() {
        return "webpackTask {\n    cssSupport.enabled = true\n}\n\nrunTask {\n    cssSupport.enabled = true\n}\n\ntestTask {\n    useKarma {\n        useChromeHeadless()\n        webpackConfig.cssSupport.enabled = true\n    }\n}";
    }
}

