/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.grazie;

import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/grazie/KotlinProblemFilter;", "Lcom/intellij/grazie/text/ProblemFilter;", "()V", "shouldIgnore", "", "problem", "Lcom/intellij/grazie/text/TextProblem;", "kotlin.grazie"})
public final class KotlinProblemFilter
extends ProblemFilter {
    public boolean shouldIgnore(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"problem.text");
        TextContent.TextDomain domain = textContent.getDomain();
        if (domain == TextContent.TextDomain.LITERALS) {
            return problem.fitsGroup(RuleGroup.Companion.getLITERALS());
        }
        if (domain == TextContent.TextDomain.DOCUMENTATION) {
            TextContent textContent2 = problem.getText();
            Intrinsics.checkNotNullExpressionValue((Object)textContent2, (String)"problem.text");
            if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(textContent2.getCommonParent().getClass()), (Object)Reflection.getOrCreateKotlinClass(KDocTag.class))) {
                return problem.fitsGroup(RuleGroup.UNDECORATED_SINGLE_SENTENCE);
            }
        }
        return false;
    }
}

