/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.InspectionOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.RenameToUnderscoreFix;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinCatchMayIgnoreExceptionInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "ignoreCatchBlocksWithComments", "", "getIgnoreCatchBlocksWithComments", "()Z", "setIgnoreCatchBlocksWithComments", "(Z)V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "createOptionsPanel", "Ljavax/swing/JComponent;", "RenameToUnderscoreLocalQuickFix", "kotlin.idea"})
public final class KotlinCatchMayIgnoreExceptionInspection
extends AbstractKotlinInspection {
    private boolean ignoreCatchBlocksWithComments = true;

    public final boolean getIgnoreCatchBlocksWithComments() {
        return this.ignoreCatchBlocksWithComments;
    }

    public final void setIgnoreCatchBlocksWithComments(boolean bl) {
        this.ignoreCatchBlocksWithComments = bl;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return (JComponent)InspectionOptionsPanel.singleCheckBox((InspectionProfileEntry)((InspectionProfileEntry)this), (String)InspectionGadgetsBundle.message((String)"inspection.catch.ignores.exception.option.comments", (Object[])new Object[0]), (String)"ignoreCatchBlocksWithComments");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(this, holder){
            final /* synthetic */ KotlinCatchMayIgnoreExceptionInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitCatchSection(@NotNull KtCatchClause catchClause) {
                Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
                KtParameter ktParameter = catchClause.getCatchParameter();
                if (ktParameter == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"catchClause.catchParameter ?: return");
                KtParameter catchParameter = ktParameter;
                String string = catchParameter.getName();
                if (string == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"catchParameter.name ?: return");
                String name2 = string;
                if (PsiUtil.isIgnoredName((String)name2)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)name2, (Object)"_")) {
                    return;
                }
                KtExpression ktExpression = catchClause.getCatchBody();
                if (ktExpression == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"catchClause.catchBody ?: return");
                KtExpression catchBody = ktExpression;
                if (catchBody instanceof KtBlockExpression && ((KtBlockExpression)catchBody).getStatements().isEmpty()) {
                    if (this.this$0.getIgnoreCatchBlocksWithComments() && ExpressionExtKt.hasComments((PsiElement)catchBody)) {
                        return;
                    }
                    PsiElement psiElement2 = ((PsiElement)catchClause).getFirstChild();
                    Intrinsics.checkNotNull((Object)psiElement2);
                    this.$holder.registerProblem(psiElement2, KotlinBundle.message("inspection.message.empty.catch.block", new Object[0]), new LocalQuickFix[]{new RenameToUnderscoreLocalQuickFix(name2)});
                }
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinCatchMayIgnoreExceptionInspection$RenameToUnderscoreLocalQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "parameterName", "", "(Ljava/lang/String;)V", "getParameterName", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
    public static final class RenameToUnderscoreLocalQuickFix
    implements LocalQuickFix {
        @NotNull
        private final String parameterName;

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.rename.x.to.y", (Object[])new Object[]{this.parameterName, "_"});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CommonQuickFixBundle.mes\u2026o.y\", parameterName, \"_\")");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("rename.to.underscore", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            KtCatchClause ktCatchClause = (KtCatchClause)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getStartElement(), KtCatchClause.class);
            if (ktCatchClause == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktCatchClause, (String)"PsiTreeUtil.getParentOfT\u2026se::class.java) ?: return");
            KtCatchClause catchClause = ktCatchClause;
            KtParameter ktParameter = catchClause.getCatchParameter();
            if (ktParameter == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"catchClause.catchParameter ?: return");
            KtParameter parameter = ktParameter;
            RenameToUnderscoreFix renameToUnderscoreFix = new RenameToUnderscoreFix((KtCallableDeclaration)parameter);
            PsiFile psiFile2 = parameter.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"parameter.containingFile");
            renameToUnderscoreFix.invoke(project2, null, psiFile2);
        }

        @NotNull
        public final String getParameterName() {
            return this.parameterName;
        }

        public RenameToUnderscoreLocalQuickFix(@NotNull String parameterName2) {
            Intrinsics.checkNotNullParameter((Object)parameterName2, (String)"parameterName");
            this.parameterName = parameterName2;
        }
    }
}

