/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/IndentRawStringIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "kotlin.idea"})
public final class IndentRawStringIntention
extends SelfTargetingOffsetIndependentIntention<KtStringTemplateExpression> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtStringTemplateExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        String string = element3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        if (!StringsKt.startsWith$default((String)string, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            return false;
        }
        Sequence $this$any$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)element3));
        boolean $i$f$any = false;
        for (Object element$iv : $this$any$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            if (it instanceof KtAnnotationEntry) return false;
            PsiElement psiElement2 = it;
            if (!(psiElement2 instanceof KtProperty)) {
                psiElement2 = null;
            }
            KtProperty ktProperty = (KtProperty)psiElement2;
            if (ktProperty != null) {
                if (ktProperty.hasModifier(KtTokens.CONST_KEYWORD)) {
                    return false;
                }
            }
            boolean bl2 = false;
            if (!bl2) continue;
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        if (KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)element3)) != null) {
            return false;
        }
        KtStringTemplateEntry[] ktStringTemplateEntryArray = element3.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"element.entries");
        KtStringTemplateEntry[] entries2 = ktStringTemplateEntryArray;
        if (entries2.length <= 1) return false;
        KtStringTemplateEntry[] $this$any$iv2 = entries2;
        boolean $i$f$any2 = false;
        int n = 0;
        int n2 = $this$any$iv2.length;
        while (n < n2) {
            KtStringTemplateEntry element$iv;
            KtStringTemplateEntry it = element$iv = $this$any$iv2[n];
            boolean bl3 = false;
            KtStringTemplateEntry ktStringTemplateEntry = it;
            Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntry, (String)"it");
            String string2 = ktStringTemplateEntry.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.text");
            if (StringsKt.startsWith$default((String)string2, (String)" ", (boolean)false, (int)2, null)) return false;
            String string3 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.text");
            if (StringsKt.startsWith$default((String)string3, (String)"\t", (boolean)false, (int)2, null)) {
                return false;
            }
            boolean bl4 = false;
            if (bl4) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtStringTemplateExpression element3, @Nullable Editor editor2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
        KtFile file2 = ktFile;
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        Project project3 = project2;
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((PsiFile)((PsiFile)file2));
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"CodeStyle.getIndentOptions(file)");
        CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project3);
        PsiFile psiFile2 = (PsiFile)file2;
        PsiElement psiElement2 = element3.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.parent");
        String string = codeStyleManager.getLineIndent(psiFile2, PsiUtilsKt.getStartOffset((PsiElement)psiElement2));
        if (string == null) {
            string = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CodeStyleManager.getInst\u2026parent.startOffset) ?: \"\"");
        String parentIndent = string;
        String indent = indentOptions2.USE_TAB_CHARACTER ? parentIndent + "\t" : parentIndent + StringsKt.repeat((CharSequence)" ", (int)indentOptions2.INDENT_SIZE);
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        int maxIndex = element3.getEntries().length - 1;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = element3.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"element.entries");
        KtStringTemplateEntry[] $this$forEachIndexed$iv = ktStringTemplateEntryArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (KtStringTemplateEntry item$iv : $this$forEachIndexed$iv) {
            void entry;
            int n = index$iv++;
            KtStringTemplateEntry ktStringTemplateEntry = item$iv;
            int index2 = n;
            boolean bl2 = false;
            if (index2 == 0) {
                $this$buildString.append("\n" + indent);
            }
            void v9 = entry;
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"entry");
            $this$buildString.append(v9.getText());
            if (Intrinsics.areEqual((Object)entry.getText(), (Object)"\n")) {
                $this$buildString.append(indent);
            }
            if (index2 != maxIndex) continue;
            $this$buildString.append("\n" + indent);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String newString = string2;
        element3.replace((PsiElement)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null).createExpression("\"\"\"" + newString + "\"\"\".trimIndent()"));
    }

    public IndentRawStringIntention() {
        super(KtStringTemplateExpression.class, KotlinBundle.lazyMessage("indent.raw.string", new Object[0]), null, 4, null);
    }
}

